/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Locale;
import org.apache.iceberg.NullOrder;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortDirection;
import org.apache.iceberg.SortField;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.util.JsonUtil;

public class SortOrderParser {
    private static final String ORDER_ID = "order-id";
    private static final String FIELDS = "fields";
    private static final String DIRECTION = "direction";
    private static final String NULL_ORDER = "null-order";
    private static final String TRANSFORM = "transform";
    private static final String SOURCE_ID = "source-id";

    private SortOrderParser() {
    }

    public static void toJson(SortOrder sortOrder, JsonGenerator generator) throws IOException {
        generator.writeStartObject();
        generator.writeNumberField(ORDER_ID, sortOrder.orderId());
        generator.writeFieldName(FIELDS);
        SortOrderParser.toJsonFields(sortOrder, generator);
        generator.writeEndObject();
    }

    public static String toJson(SortOrder sortOrder) {
        return SortOrderParser.toJson(sortOrder, false);
    }

    public static String toJson(SortOrder sortOrder, boolean pretty) {
        try {
            StringWriter writer = new StringWriter();
            JsonGenerator generator = JsonUtil.factory().createGenerator((Writer)writer);
            if (pretty) {
                generator.useDefaultPrettyPrinter();
            }
            SortOrderParser.toJson(sortOrder, generator);
            generator.flush();
            return writer.toString();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static String toJson(SortDirection direction) {
        return direction.toString().toLowerCase(Locale.ROOT);
    }

    private static String toJson(NullOrder nullOrder) {
        return nullOrder == NullOrder.NULLS_FIRST ? "nulls-first" : "nulls-last";
    }

    private static void toJsonFields(SortOrder sortOrder, JsonGenerator generator) throws IOException {
        generator.writeStartArray();
        for (SortField field : sortOrder.fields()) {
            generator.writeStartObject();
            generator.writeStringField(TRANSFORM, field.transform().toString());
            generator.writeNumberField(SOURCE_ID, field.sourceId());
            generator.writeStringField(DIRECTION, SortOrderParser.toJson(field.direction()));
            generator.writeStringField(NULL_ORDER, SortOrderParser.toJson(field.nullOrder()));
            generator.writeEndObject();
        }
        generator.writeEndArray();
    }

    public static SortOrder fromJson(Schema schema, String json) {
        try {
            return SortOrderParser.fromJson(schema, (JsonNode)JsonUtil.mapper().readValue(json, JsonNode.class));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static SortOrder fromJson(Schema schema, JsonNode json) {
        Preconditions.checkArgument((boolean)json.isObject(), (String)"Cannot parse sort order from non-object: %s", (Object)json);
        int orderId = JsonUtil.getInt(ORDER_ID, json);
        SortOrder.Builder builder = SortOrder.builderFor((Schema)schema).withOrderId(orderId);
        SortOrderParser.buildFromJsonFields(builder, json.get(FIELDS));
        return builder.build();
    }

    private static void buildFromJsonFields(SortOrder.Builder builder, JsonNode json) {
        Preconditions.checkArgument((json != null ? 1 : 0) != 0, (Object)"Cannot parse null sort order fields");
        Preconditions.checkArgument((boolean)json.isArray(), (String)"Cannot parse sort order fields, not an array: %s", (Object)json);
        Iterator elements = json.elements();
        while (elements.hasNext()) {
            JsonNode element = (JsonNode)elements.next();
            Preconditions.checkArgument((boolean)element.isObject(), (String)"Cannot parse sort field, not an object: %s", (Object)element);
            String transform = JsonUtil.getString(TRANSFORM, element);
            int sourceId = JsonUtil.getInt(SOURCE_ID, element);
            String directionAsString = JsonUtil.getString(DIRECTION, element);
            SortDirection direction = SortOrderParser.toDirection(directionAsString);
            String nullOrderingAsString = JsonUtil.getString(NULL_ORDER, element);
            NullOrder nullOrder = SortOrderParser.toNullOrder(nullOrderingAsString);
            builder.addSortField(transform, sourceId, direction, nullOrder);
        }
    }

    private static SortDirection toDirection(String directionAsString) {
        return SortDirection.valueOf((String)directionAsString.toUpperCase(Locale.ROOT));
    }

    private static NullOrder toNullOrder(String nullOrderingAsString) {
        switch (nullOrderingAsString) {
            case "nulls-first": {
                return NullOrder.NULLS_FIRST;
            }
            case "nulls-last": {
                return NullOrder.NULLS_LAST;
            }
        }
        throw new IllegalArgumentException("Unexpected null order: " + nullOrderingAsString);
    }
}

