/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.hbase;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.avro.reflect.ReflectData;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.hbase.ColumnMappings;
import org.apache.hadoop.hive.hbase.CompositeHBaseKeyFactory;
import org.apache.hadoop.hive.hbase.HBaseCompositeKey;
import org.apache.hadoop.hive.hbase.LazyHBaseCellMap;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.avro.AvroObjectInspectorGenerator;
import org.apache.hadoop.hive.serde2.avro.AvroSerdeUtils;
import org.apache.hadoop.hive.serde2.lazy.LazyFactory;
import org.apache.hadoop.hive.serde2.lazy.LazyObjectBase;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazyMapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseSerDeHelper {
    public static final Logger LOG = LoggerFactory.getLogger(HBaseSerDeHelper.class);

    public static void generateColumns(Properties tbl, List<ColumnMappings.ColumnMapping> columnsMapping, StringBuilder sb) {
        if (columnsMapping == null) {
            throw new IllegalArgumentException("columnsMapping cannot be null");
        }
        if (sb == null) {
            throw new IllegalArgumentException("StringBuilder cannot be null");
        }
        for (int i = 0; i < columnsMapping.size(); ++i) {
            ColumnMappings.ColumnMapping colMap = columnsMapping.get(i);
            if (colMap.hbaseRowKey) {
                sb.append("key").append(",");
                continue;
            }
            if (colMap.qualifierName == null) {
                if (colMap.qualifierPrefix != null) {
                    sb.append(HBaseSerDeHelper.filter(colMap.familyName)).append("_").append(HBaseSerDeHelper.filter(colMap.qualifierPrefix) + i).append(",");
                    continue;
                }
                sb.append(HBaseSerDeHelper.filter(colMap.familyName)).append("_").append("col" + i).append(",");
                continue;
            }
            sb.append(HBaseSerDeHelper.filter(colMap.familyName)).append("_").append(HBaseSerDeHelper.filter(colMap.qualifierName)).append(",");
        }
        HBaseSerDeHelper.trim(sb);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Generated columns: [" + sb.toString() + "]");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void generateColumnTypes(Properties tbl, List<ColumnMappings.ColumnMapping> columnsMapping, StringBuilder sb, Configuration conf) throws SerDeException {
        if (tbl == null) {
            throw new IllegalArgumentException("tbl cannot be null");
        }
        if (columnsMapping == null) {
            throw new IllegalArgumentException("columnsMapping cannot be null");
        }
        if (sb == null) {
            throw new IllegalArgumentException("StringBuilder cannot be null");
        }
        for (int i = 0; i < columnsMapping.size(); ++i) {
            String serType;
            if (sb.length() > 0) {
                sb.append(":");
            }
            ColumnMappings.ColumnMapping colMap = columnsMapping.get(i);
            if (colMap.hbaseRowKey) {
                Map<String, String> compositeKeyParts = HBaseSerDeHelper.getCompositeKeyParts(tbl);
                StringBuilder keyStruct = new StringBuilder();
                if (compositeKeyParts == null || compositeKeyParts.isEmpty()) {
                    String compKeyClass = tbl.getProperty("hbase.composite.key.class");
                    String compKeyTypes = tbl.getProperty("hbase.composite.key.types");
                    if (compKeyTypes == null) {
                        if (compKeyClass != null) {
                            throw new SerDeException("Either the hbase.composite.key.types property should be set or the getParts method must be overridden in " + compKeyClass);
                        }
                        sb.append("string");
                    } else {
                        HBaseSerDeHelper.generateKeyStruct(compKeyTypes, keyStruct);
                    }
                } else {
                    HBaseSerDeHelper.generateKeyStruct(compositeKeyParts, keyStruct);
                }
                sb.append((CharSequence)keyStruct);
                continue;
            }
            if (colMap.qualifierName == null) {
                String serClassName = null;
                serType = null;
                String schemaLiteral = null;
                String schemaUrl = null;
                if (colMap.qualifierPrefix != null) {
                    serType = tbl.getProperty(colMap.familyName + "." + colMap.qualifierPrefix + ".serialization.type");
                    if (serType == null) {
                        throw new SerDeException("serialization.type property not provided for column family [" + colMap.familyName + "] and prefix [" + colMap.qualifierPrefix + "]");
                    }
                    serClassName = tbl.getProperty(colMap.familyName + "." + colMap.qualifierPrefix + ".serialization.class");
                    if (serClassName == null) {
                        if (!serType.equalsIgnoreCase("avro")) throw new SerDeException("serialization.class property not provided for column family [" + colMap.familyName + "] and prefix [" + colMap.qualifierPrefix + "]");
                        schemaLiteral = tbl.getProperty(colMap.familyName + "." + colMap.qualifierPrefix + "." + AvroSerdeUtils.AvroTableProperties.SCHEMA_LITERAL.getPropName());
                        schemaUrl = tbl.getProperty(colMap.familyName + "." + colMap.qualifierPrefix + "." + AvroSerdeUtils.AvroTableProperties.SCHEMA_URL.getPropName());
                        if (schemaLiteral == null && schemaUrl == null) {
                            throw new SerDeException("For an avro schema, either " + AvroSerdeUtils.AvroTableProperties.SCHEMA_LITERAL.getPropName() + ", " + AvroSerdeUtils.AvroTableProperties.SCHEMA_URL.getPropName() + " or serialization.class property must be set.");
                        }
                        if (schemaUrl != null) {
                            schemaLiteral = HBaseSerDeHelper.getSchemaFromFS(schemaUrl, conf).toString();
                        }
                    }
                } else {
                    serType = tbl.getProperty(colMap.familyName + ".serialization.type");
                    if (serType == null) {
                        throw new SerDeException("serialization.type property not provided for column family [" + colMap.familyName + "]");
                    }
                    serClassName = tbl.getProperty(colMap.familyName + ".serialization.class");
                    if (serClassName == null) {
                        if (!serType.equalsIgnoreCase("avro")) throw new SerDeException("serialization.class property not provided for column family [" + colMap.familyName + "]");
                        schemaLiteral = tbl.getProperty(colMap.familyName + "." + AvroSerdeUtils.AvroTableProperties.SCHEMA_LITERAL.getPropName());
                        schemaUrl = tbl.getProperty(colMap.familyName + "." + AvroSerdeUtils.AvroTableProperties.SCHEMA_URL.getPropName());
                        if (schemaLiteral == null && schemaUrl == null) {
                            throw new SerDeException("For an avro schema, either " + AvroSerdeUtils.AvroTableProperties.SCHEMA_LITERAL.getPropName() + " property or serialization.class property must be set.");
                        }
                        if (schemaUrl != null) {
                            schemaLiteral = HBaseSerDeHelper.getSchemaFromFS(schemaUrl, conf).toString();
                        }
                    }
                }
                StringBuilder generatedStruct = new StringBuilder();
                HBaseSerDeHelper.generateColumnStruct(serType, serClassName, schemaLiteral, colMap, generatedStruct);
                sb.append("map<string," + generatedStruct + ">");
                continue;
            }
            String qualifierName = colMap.qualifierName;
            if (colMap.qualifierName.endsWith("*")) {
                qualifierName = colMap.qualifierName.substring(0, colMap.qualifierName.length() - 1);
            }
            if ((serType = tbl.getProperty(colMap.familyName + "." + qualifierName + ".serialization.type")) == null) {
                throw new SerDeException("serialization.type property not provided for column family [" + colMap.familyName + "] and qualifier [" + qualifierName + "]");
            }
            String serClassName = tbl.getProperty(colMap.familyName + "." + qualifierName + ".serialization.class");
            String schemaLiteral = null;
            String schemaUrl = null;
            if (serClassName == null) {
                if (!serType.equalsIgnoreCase("avro")) throw new SerDeException("serialization.class property not provided for column family [" + colMap.familyName + "] and qualifier [" + qualifierName + "]");
                schemaLiteral = tbl.getProperty(colMap.familyName + "." + qualifierName + "." + AvroSerdeUtils.AvroTableProperties.SCHEMA_LITERAL.getPropName());
                schemaUrl = tbl.getProperty(colMap.familyName + "." + qualifierName + "." + AvroSerdeUtils.AvroTableProperties.SCHEMA_URL.getPropName());
                if (schemaLiteral == null && schemaUrl == null) {
                    throw new SerDeException("For an avro schema, either " + AvroSerdeUtils.AvroTableProperties.SCHEMA_LITERAL.getPropName() + ", " + AvroSerdeUtils.AvroTableProperties.SCHEMA_URL.getPropName() + " or serialization.class property must be set.");
                }
                if (schemaUrl != null) {
                    schemaLiteral = HBaseSerDeHelper.getSchemaFromFS(schemaUrl, conf).toString();
                }
            }
            StringBuilder generatedStruct = new StringBuilder();
            HBaseSerDeHelper.generateColumnStruct(serType, serClassName, schemaLiteral, colMap, generatedStruct);
            sb.append((CharSequence)generatedStruct);
        }
        HBaseSerDeHelper.trim(sb);
        if (!LOG.isDebugEnabled()) return;
        LOG.debug("Generated column types: [" + sb.toString() + "]");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Schema getSchemaFromFS(String schemaFSUrl, Configuration conf) throws SerDeException {
        Schema schema;
        FSDataInputStream in = null;
        FileSystem fs = null;
        try {
            Schema s;
            fs = FileSystem.get((URI)new URI(schemaFSUrl), (Configuration)conf);
            in = fs.open(new Path(schemaFSUrl));
            schema = s = Schema.parse((InputStream)in);
        }
        catch (URISyntaxException e) {
            try {
                throw new SerDeException("Failure reading schema from filesystem", (Throwable)e);
                catch (IOException e2) {
                    throw new SerDeException("Failure reading schema from filesystem", (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        return schema;
    }

    public static LazyObjectBase createLazyField(ColumnMappings.ColumnMapping[] columnMappings, int fieldID, ObjectInspector inspector) {
        ColumnMappings.ColumnMapping colMap = columnMappings[fieldID];
        if (colMap.getQualifierName() == null && !colMap.isHbaseRowKey()) {
            return new LazyHBaseCellMap((LazyMapObjectInspector)inspector);
        }
        return LazyFactory.createLazyObject((ObjectInspector)inspector, (boolean)colMap.getBinaryStorage().get(0));
    }

    private static void generateKeyStruct(Map<String, String> compositeKeyParts, StringBuilder sb) {
        sb.append("struct<");
        for (Map.Entry<String, String> entry : compositeKeyParts.entrySet()) {
            sb.append(entry.getKey()).append(":").append(entry.getValue()).append(",");
        }
        HBaseSerDeHelper.trim(sb);
        sb.append(">");
    }

    private static void generateKeyStruct(String compositeKeyTypes, StringBuilder sb) {
        sb.append("struct<");
        String[] keyTypes = compositeKeyTypes.split(",");
        for (int i = 0; i < keyTypes.length; ++i) {
            sb.append("col" + i).append(":").append(keyTypes[i]).append(",");
        }
        HBaseSerDeHelper.trim(sb);
        sb.append(">");
    }

    private static void generateColumnStruct(String serType, String serClassName, String schemaLiteral, ColumnMappings.ColumnMapping colMap, StringBuilder sb) throws SerDeException {
        if (serType.equalsIgnoreCase("avro")) {
            if (serClassName != null) {
                HBaseSerDeHelper.generateAvroStructFromClass(serClassName, sb);
            } else {
                HBaseSerDeHelper.generateAvroStructFromSchema(schemaLiteral, sb);
            }
        } else {
            throw new SerDeException("Unknown serialization.type found for column family [" + colMap.familyName + "]");
        }
    }

    private static void generateAvroStructFromClass(String serClassName, StringBuilder sb) throws SerDeException {
        Class serClass;
        try {
            serClass = JavaUtils.loadClass((String)serClassName);
        }
        catch (ClassNotFoundException e) {
            throw new SerDeException("Error obtaining descriptor for " + serClassName, (Throwable)e);
        }
        Schema schema = ReflectData.get().getSchema((Type)serClass);
        HBaseSerDeHelper.generateAvroStructFromSchema(schema, sb);
    }

    private static void generateAvroStructFromSchema(String schemaLiteral, StringBuilder sb) throws SerDeException {
        Schema schema = Schema.parse((String)schemaLiteral);
        HBaseSerDeHelper.generateAvroStructFromSchema(schema, sb);
    }

    private static void generateAvroStructFromSchema(Schema schema, StringBuilder sb) throws SerDeException {
        AvroObjectInspectorGenerator avig = new AvroObjectInspectorGenerator(schema);
        sb.append("struct<");
        List columnNames = avig.getColumnNames();
        List columnTypes = avig.getColumnTypes();
        if (columnNames.size() != columnTypes.size()) {
            throw new AssertionError((Object)"The number of column names should be the same as column types");
        }
        for (int i = 0; i < columnNames.size(); ++i) {
            sb.append((String)columnNames.get(i));
            sb.append(":");
            sb.append(((TypeInfo)columnTypes.get(i)).getTypeName());
            sb.append(",");
        }
        HBaseSerDeHelper.trim(sb).append(">");
    }

    private static StringBuilder trim(StringBuilder sb) {
        if (sb.charAt(sb.length() - 1) == ',') {
            return sb.deleteCharAt(sb.length() - 1);
        }
        return sb;
    }

    private static String filter(String name) {
        return name.replaceAll("[^a-zA-Z0-9]+", "").toLowerCase();
    }

    private static Map<String, String> getCompositeKeyParts(Properties tbl) throws SerDeException {
        String compKeyClassName = tbl.getProperty("hbase.composite.key.class");
        if (compKeyClassName == null) {
            return null;
        }
        CompositeHBaseKeyFactory keyFactory = null;
        try {
            Class keyClass = JavaUtils.loadClass((String)compKeyClassName);
            keyFactory = new CompositeHBaseKeyFactory(keyClass);
        }
        catch (Exception e) {
            throw new SerDeException((Throwable)e);
        }
        Object compKey = keyFactory.createKey(null);
        return ((HBaseCompositeKey)((Object)compKey)).getParts();
    }
}

