/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.jdbc;

import com.google.common.annotations.VisibleForTesting;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.util.Properties;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.calcite.adapter.jdbc.JdbcSchema;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlDialectFactory;
import org.apache.calcite.sql.SqlDialectFactoryImpl;
import org.apache.drill.common.AutoCloseables;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.ops.OptimizerRulesContext;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.store.AbstractStoragePlugin;
import org.apache.drill.exec.store.SchemaConfig;
import org.apache.drill.exec.store.jdbc.DrillJdbcConvention;
import org.apache.drill.exec.store.jdbc.JdbcDialect;
import org.apache.drill.exec.store.jdbc.JdbcDialectFactory;
import org.apache.drill.exec.store.jdbc.JdbcStorageConfig;
import org.apache.drill.exec.store.security.UsernamePasswordCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcStoragePlugin
extends AbstractStoragePlugin {
    private static final Logger logger = LoggerFactory.getLogger(JdbcStoragePlugin.class);
    private final JdbcStorageConfig config;
    private final HikariDataSource dataSource;
    private final SqlDialect dialect;
    private final DrillJdbcConvention convention;
    private final JdbcDialect jdbcDialect;

    public JdbcStoragePlugin(JdbcStorageConfig config, DrillbitContext context, String name) {
        super(context, name);
        this.config = config;
        this.dataSource = JdbcStoragePlugin.initDataSource(config);
        this.dialect = JdbcSchema.createDialect((SqlDialectFactory)SqlDialectFactoryImpl.INSTANCE, (DataSource)this.dataSource);
        this.convention = new DrillJdbcConvention(this.dialect, name, this);
        this.jdbcDialect = JdbcDialectFactory.getJdbcDialect(this, config.getUrl());
    }

    public void registerSchemas(SchemaConfig config, SchemaPlus parent) {
        this.jdbcDialect.registerSchemas(config, parent);
    }

    public JdbcDialect getJdbcDialect() {
        return this.jdbcDialect;
    }

    public DrillJdbcConvention getConvention() {
        return this.convention;
    }

    public JdbcStorageConfig getConfig() {
        return this.config;
    }

    public boolean supportsRead() {
        return true;
    }

    public boolean supportsWrite() {
        return this.config.isWritable();
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public SqlDialect getDialect() {
        return this.dialect;
    }

    public Set<RelOptRule> getPhysicalOptimizerRules(OptimizerRulesContext context) {
        return this.convention.getRules();
    }

    public void close() {
        AutoCloseables.closeSilently((AutoCloseable[])new AutoCloseable[]{this.dataSource});
    }

    @VisibleForTesting
    static HikariDataSource initDataSource(JdbcStorageConfig config) {
        try {
            Properties properties = new Properties();
            properties.setProperty("dataSource.idleTimeout", String.format("%d000", 3600));
            properties.setProperty("dataSource.keepaliveTime", String.format("%d000", 0));
            properties.setProperty("dataSource.maxLifetime", String.format("%d000", 21600));
            properties.setProperty("dataSource.minimumIdle", "0");
            properties.setProperty("dataSource.maximumPoolSize", "10");
            properties.putAll(config.getSourceParameters());
            HikariConfig hikariConfig = new HikariConfig(properties);
            hikariConfig.setDriverClassName(config.getDriver());
            hikariConfig.setJdbcUrl(config.getUrl());
            UsernamePasswordCredentials credentials = config.getUsernamePasswordCredentials();
            hikariConfig.setUsername(credentials.getUsername());
            hikariConfig.setPassword(credentials.getPassword());
            hikariConfig.setReadOnly(!config.isWritable());
            return new HikariDataSource(hikariConfig);
        }
        catch (RuntimeException e) {
            throw UserException.connectionError((Throwable)e).message("Unable to configure data source: %s", new Object[]{e.getMessage()}).build(logger);
        }
    }
}

