/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.calcite.adapter.jdbc.JdbcConvention;
import org.apache.calcite.adapter.jdbc.JdbcSchema;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Table;
import org.apache.calcite.sql.SqlDialect;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.Writer;
import org.apache.drill.exec.planner.logical.CreateTableEntry;
import org.apache.drill.exec.store.AbstractSchema;
import org.apache.drill.exec.store.StorageStrategy;
import org.apache.drill.exec.store.jdbc.DrillJdbcConvention;
import org.apache.drill.exec.store.jdbc.JdbcStoragePlugin;
import org.apache.drill.exec.store.jdbc.JdbcWriter;
import org.apache.drill.exec.store.jdbc.utils.CreateTableStmtBuilder;
import org.apache.drill.exec.store.jdbc.utils.JdbcDDLQueryUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CapitalizingJdbcSchema
extends AbstractSchema {
    private static final Logger logger = LoggerFactory.getLogger(CapitalizingJdbcSchema.class);
    private final Map<String, CapitalizingJdbcSchema> schemaMap = new HashMap<String, CapitalizingJdbcSchema>();
    private final JdbcSchema inner;
    private final boolean caseSensitive;
    private final JdbcStoragePlugin plugin;
    private final String catalog;
    private final String schema;

    public CapitalizingJdbcSchema(List<String> parentSchemaPath, String name, DataSource dataSource, SqlDialect dialect, DrillJdbcConvention convention, String catalog, String schema, boolean caseSensitive) {
        super(parentSchemaPath, name);
        this.inner = new JdbcSchema(dataSource, dialect, (JdbcConvention)convention, catalog, schema);
        this.caseSensitive = caseSensitive;
        this.plugin = convention.getPlugin();
        this.schema = schema;
        this.catalog = catalog;
    }

    public String getTypeName() {
        return "jdbc";
    }

    public Collection<Function> getFunctions(String name) {
        return this.inner.getFunctions(name);
    }

    public Set<String> getFunctionNames() {
        return this.inner.getFunctionNames();
    }

    public CapitalizingJdbcSchema getSubSchema(String name) {
        return this.schemaMap.get(name);
    }

    void setHolder(SchemaPlus plusOfThis) {
        for (String s : this.getSubSchemaNames()) {
            CapitalizingJdbcSchema inner = this.getSubSchema(s);
            SchemaPlus holder = plusOfThis.add(s, (Schema)inner);
            inner.setHolder(holder);
        }
    }

    public Set<String> getSubSchemaNames() {
        return this.schemaMap.keySet();
    }

    public Set<String> getTableNames() {
        if (this.isCatalogSchema()) {
            return Collections.emptySet();
        }
        return this.inner.getTableNames();
    }

    public CreateTableEntry createNewTable(final String tableName, List<String> partitionColumns, StorageStrategy strategy) {
        if (!this.plugin.getConfig().isWritable()) {
            throw UserException.dataWriteError().message(this.plugin.getName() + " is not writable.", new Object[0]).build(logger);
        }
        return new CreateTableEntry(){

            public Writer getWriter(PhysicalOperator child) throws IOException {
                String tableWithSchema = CreateTableStmtBuilder.buildCompleteTableName(tableName, CapitalizingJdbcSchema.this.catalog, CapitalizingJdbcSchema.this.schema);
                return new JdbcWriter(child, tableWithSchema, CapitalizingJdbcSchema.this.inner, CapitalizingJdbcSchema.this.plugin);
            }

            public List<String> getPartitionColumns() {
                return Collections.emptyList();
            }
        };
    }

    public void dropTable(String tableName) {
        if (!this.plugin.getConfig().isWritable()) {
            throw UserException.dataWriteError().message(this.plugin.getName() + " is not writable.", new Object[0]).build(logger);
        }
        String tableWithSchema = CreateTableStmtBuilder.buildCompleteTableName(tableName, this.catalog, this.schema);
        String dropTableQuery = String.format("DROP TABLE %s", tableWithSchema);
        dropTableQuery = JdbcDDLQueryUtils.cleanDDLQuery(dropTableQuery, this.plugin.getDialect());
        try (Connection conn = this.inner.getDataSource().getConnection();
             Statement stmt = conn.createStatement();){
            logger.debug("Executing drop table query: {}", (Object)dropTableQuery);
            int successfullyDropped = stmt.executeUpdate(dropTableQuery);
            logger.debug("Result: {}", (Object)successfullyDropped);
            if (successfullyDropped > 0) {
                throw UserException.dataWriteError().message("Error while dropping table " + tableName, new Object[0]).addContext(stmt.getWarnings().getMessage()).build(logger);
            }
        }
        catch (SQLException e) {
            throw UserException.dataWriteError((Throwable)e).message("Failure while trying to drop table '%s'.", new Object[]{tableName}).addContext("plugin", this.name).build(logger);
        }
    }

    public boolean isMutable() {
        return this.plugin.getConfig().isWritable();
    }

    public Table getTable(String name) {
        if (this.isCatalogSchema()) {
            logger.warn("Failed attempt to find table '{}' in catalog schema '{}'", (Object)name, (Object)this.getName());
            return null;
        }
        Table table = this.inner.getTable(name);
        if (table == null && !this.areTableNamesCaseSensitive() && (table = this.inner.getTable(name.toUpperCase())) == null) {
            table = this.inner.getTable(name.toLowerCase());
        }
        return table;
    }

    public boolean areTableNamesCaseSensitive() {
        return this.caseSensitive;
    }

    public CapitalizingJdbcSchema getDefaultSchema() {
        return this.isCatalogSchema() ? this.schemaMap.values().iterator().next().getDefaultSchema() : this;
    }

    private boolean isCatalogSchema() {
        return !this.schemaMap.isEmpty();
    }

    void addSubSchema(CapitalizingJdbcSchema subSchema) {
        this.schemaMap.put(subSchema.getName(), subSchema);
    }
}

