/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.mapreduce.VisibilityExpressionResolver;
import org.apache.hadoop.hbase.security.visibility.Authorizations;
import org.apache.hadoop.hbase.security.visibility.VisibilityConstants;
import org.apache.hadoop.hbase.security.visibility.VisibilityLabelOrdinalProvider;
import org.apache.hadoop.hbase.security.visibility.VisibilityUtils;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
public class DefaultVisibilityExpressionResolver
implements VisibilityExpressionResolver {
    private static final Log LOG = LogFactory.getLog(DefaultVisibilityExpressionResolver.class);
    private Configuration conf;
    private final Map<String, Integer> labels = new HashMap<String, Integer>();

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void init() {
        Table labelsTable = null;
        Connection connection = null;
        try {
            connection = ConnectionFactory.createConnection((Configuration)this.conf);
            try {
                labelsTable = connection.getTable(VisibilityConstants.LABELS_TABLE_NAME);
            }
            catch (IOException e) {
                LOG.error((Object)"Error opening 'labels' table", (Throwable)e);
                if (labelsTable != null) {
                    try {
                        labelsTable.close();
                    }
                    catch (IOException ioe) {
                        LOG.warn((Object)"Error closing 'labels' table", (Throwable)ioe);
                    }
                }
                if (connection == null) return;
                try {
                    connection.close();
                    return;
                }
                catch (IOException ioe) {
                    LOG.warn((Object)"Failed close of temporary connection", (Throwable)ioe);
                }
                return;
            }
            Scan scan = new Scan();
            scan.setAuthorizations(new Authorizations(new String[]{"system"}));
            scan.addColumn(VisibilityConstants.LABELS_TABLE_FAMILY, VisibilityConstants.LABEL_QUALIFIER);
            ResultScanner scanner = null;
            try {
                scanner = labelsTable.getScanner(scan);
                Result next = null;
                while ((next = scanner.next()) != null) {
                    byte[] row = next.getRow();
                    byte[] value = next.getValue(VisibilityConstants.LABELS_TABLE_FAMILY, VisibilityConstants.LABEL_QUALIFIER);
                    this.labels.put(Bytes.toString((byte[])value), Bytes.toInt((byte[])row));
                }
                if (scanner == null) return;
            }
            catch (TableNotFoundException e) {
                if (scanner != null) {
                    scanner.close();
                }
                if (labelsTable != null) {
                    try {
                        labelsTable.close();
                    }
                    catch (IOException ioe) {
                        LOG.warn((Object)"Error closing 'labels' table", (Throwable)ioe);
                    }
                }
                if (connection == null) return;
                try {
                    connection.close();
                    return;
                }
                catch (IOException ioe) {
                    LOG.warn((Object)"Failed close of temporary connection", (Throwable)ioe);
                }
                return;
            }
            catch (IOException e) {
                try {
                    LOG.error((Object)"Error scanning 'labels' table", (Throwable)e);
                    return;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    finally {
                        if (scanner != null) {
                            scanner.close();
                        }
                    }
                }
                catch (IOException ioe) {
                    LOG.error((Object)"Failed reading 'labels' tags", (Throwable)ioe);
                    return;
                }
                finally {
                }
            }
            scanner.close();
            return;
        }
        finally {
            if (labelsTable != null) {
                try {
                    labelsTable.close();
                }
                catch (IOException ioe) {
                    LOG.warn((Object)"Error closing 'labels' table", (Throwable)ioe);
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (IOException ioe) {
                    LOG.warn((Object)"Failed close of temporary connection", (Throwable)ioe);
                }
            }
        }
    }

    @Override
    public List<Tag> createVisibilityExpTags(String visExpression) throws IOException {
        VisibilityLabelOrdinalProvider provider = new VisibilityLabelOrdinalProvider(){

            @Override
            public int getLabelOrdinal(String label) {
                Integer ordinal = null;
                ordinal = DefaultVisibilityExpressionResolver.this.labels.get(label);
                if (ordinal != null) {
                    return ordinal;
                }
                return 0;
            }

            @Override
            public String getLabel(int ordinal) {
                throw new UnsupportedOperationException("getLabel should not be used in VisibilityExpressionResolver");
            }
        };
        return VisibilityUtils.createVisibilityExpTags(visExpression, true, false, null, provider);
    }
}

