/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.sulky.formatting;

public final class SimpleXml {
    private static final int XML_CHAR_RANGE_A_START = 32;
    private static final int XML_CHAR_RANGE_A_END = 55295;
    private static final int XML_CHAR_RANGE_B_START = 57344;
    private static final int XML_CHAR_RANGE_B_END = 65533;
    private static final int XML_CHAR_RANGE_C_START = 65536;
    private static final int XML_CHAR_RANGE_C_END = 0x10FFFF;

    private SimpleXml() {
    }

    public static boolean isValidXMLCharacter(char character) {
        return character == '\t' || character == '\r' || character == '\n' || character >= ' ' && character <= '\ud7ff' || character >= '\ue000' && character <= '\ufffd' || character >= '\u10000' && character <= '\u10ffff';
    }

    public static String escape(String input) {
        String result = input;
        result = result.replace('\u0000', ' ');
        result = result.replace("&", "&amp;");
        result = result.replace("<", "&lt;");
        result = result.replace(">", "&gt;");
        result = result.replace("\"", "&quot;");
        return result;
    }

    public static String unescape(String input) {
        String result = input;
        result = result.replace("&quot;", "\"");
        result = result.replace("&gt;", ">");
        result = result.replace("&lt;", "<");
        result = result.replace("&amp;", "&");
        return result;
    }

    public static String replaceNonValidXMLCharacters(String in, char replacementChar) {
        StringBuilder out = null;
        if (!SimpleXml.isValidXMLCharacter(replacementChar)) {
            throw new IllegalArgumentException("Replacement character 0x" + Integer.toString(replacementChar, 16) + " is invalid itself!");
        }
        for (int i = 0; i < in.length(); ++i) {
            char current = in.charAt(i);
            if (SimpleXml.isValidXMLCharacter(current)) continue;
            if (out == null) {
                out = new StringBuilder(in);
            }
            out.setCharAt(i, replacementChar);
        }
        if (out != null) {
            return out.toString();
        }
        return in;
    }
}

