/*
 * Decompiled with CFR 0.152.
 */
package com.bedatadriven.spss;

import com.bedatadriven.spss.ExtendedRecordHeader;
import com.bedatadriven.spss.SpssInputStream;
import com.bedatadriven.spss.SpssVariable;
import java.io.IOException;
import java.util.List;
import java.util.Map;

class LongStringRecord {
    static final int EXTENDED_RECORD_TYPE = 14;
    private final SpssInputStream inputStream;
    private byte[] longStrings;

    LongStringRecord(ExtendedRecordHeader header, SpssInputStream inputStream) throws IOException {
        this.inputStream = inputStream;
        this.longStrings = inputStream.readBytes(header.getTotalLength());
    }

    void parseInto(List<SpssVariable> variables, Map<String, SpssVariable> variableNames) {
        int longStringsLength = this.longStrings.length;
        String shortName = null;
        int strLen = 0;
        int tokenStart = 0;
        for (int i = 0; i <= longStringsLength; ++i) {
            if (i < longStringsLength && this.longStrings[i] == 61) {
                shortName = new String(this.longStrings, tokenStart, i - tokenStart);
                tokenStart = i + 1;
                continue;
            }
            if (i == tokenStart || i != longStringsLength && this.longStrings[i] != 9) continue;
            byte[] byteArr = new byte[i - tokenStart];
            System.arraycopy(this.longStrings, tokenStart, byteArr, 0, i - tokenStart);
            String strVal = this.inputStream.stringFromBytes(byteArr);
            strLen = Integer.parseInt(strVal.replaceAll("\\u0000", ""));
            SpssVariable target = variableNames.get(shortName);
            target.veryLongStringLength = strLen;
            int segments = (strLen + 251) / 252;
            for (int idx = target.getIndex() + 1; idx < target.getIndex() + segments; ++idx) {
                variables.get((int)idx).isVeryLongStringSegment = true;
            }
            tokenStart = i + 1;
        }
    }
}

