/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.metadata;

import org.apache.calcite.adapter.enumerable.EnumerableLimit;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Calc;
import org.apache.calcite.rel.core.Exchange;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Intersect;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.Minus;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.core.Union;
import org.apache.calcite.rel.core.Values;
import org.apache.calcite.rel.metadata.BuiltInMetadata;
import org.apache.calcite.rel.metadata.MetadataDef;
import org.apache.calcite.rel.metadata.MetadataHandler;
import org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMdUtil;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Util;

public class RelMdRowCount
implements MetadataHandler<BuiltInMetadata.RowCount> {
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource(BuiltInMethod.ROW_COUNT.method, new RelMdRowCount());

    @Override
    public MetadataDef<BuiltInMetadata.RowCount> getDef() {
        return BuiltInMetadata.RowCount.DEF;
    }

    public Double getRowCount(RelNode rel, RelMetadataQuery mq) {
        return rel.estimateRowCount(mq);
    }

    public Double getRowCount(RelSubset subset, RelMetadataQuery mq) {
        return mq.getRowCount(Util.first(subset.getBest(), subset.getOriginal()));
    }

    public Double getRowCount(Union rel, RelMetadataQuery mq) {
        double rowCount = 0.0;
        for (RelNode input : rel.getInputs()) {
            Double partialRowCount = mq.getRowCount(input);
            if (partialRowCount == null) {
                return null;
            }
            rowCount += partialRowCount.doubleValue();
        }
        if (!rel.all) {
            rowCount *= 0.5;
        }
        return rowCount;
    }

    public Double getRowCount(Intersect rel, RelMetadataQuery mq) {
        Double rowCount = null;
        for (RelNode input : rel.getInputs()) {
            Double partialRowCount = mq.getRowCount(input);
            if (rowCount != null && (partialRowCount == null || !(partialRowCount < rowCount))) continue;
            rowCount = partialRowCount;
        }
        return rowCount;
    }

    public Double getRowCount(Minus rel, RelMetadataQuery mq) {
        Double rowCount = null;
        for (RelNode input : rel.getInputs()) {
            Double partialRowCount = mq.getRowCount(input);
            if (rowCount != null && (partialRowCount == null || !(partialRowCount < rowCount))) continue;
            rowCount = partialRowCount;
        }
        return rowCount;
    }

    public Double getRowCount(Filter rel, RelMetadataQuery mq) {
        return RelMdUtil.estimateFilteredRows(rel.getInput(), rel.getCondition(), mq);
    }

    public Double getRowCount(Calc rel, RelMetadataQuery mq) {
        return RelMdUtil.estimateFilteredRows(rel.getInput(), rel.getProgram(), mq);
    }

    public Double getRowCount(Project rel, RelMetadataQuery mq) {
        return mq.getRowCount(rel.getInput());
    }

    public Double getRowCount(Sort rel, RelMetadataQuery mq) {
        Double rowCount = mq.getRowCount(rel.getInput());
        if (rowCount == null) {
            return null;
        }
        if (rel.offset instanceof RexDynamicParam) {
            return rowCount;
        }
        int offset = rel.offset == null ? 0 : RexLiteral.intValue(rel.offset);
        rowCount = Math.max(rowCount - (double)offset, 0.0);
        if (rel.fetch != null) {
            if (rel.fetch instanceof RexDynamicParam) {
                return rowCount;
            }
            int limit = RexLiteral.intValue(rel.fetch);
            if ((double)limit < rowCount) {
                return limit;
            }
        }
        return rowCount;
    }

    public Double getRowCount(EnumerableLimit rel, RelMetadataQuery mq) {
        Double rowCount = mq.getRowCount(rel.getInput());
        if (rowCount == null) {
            return null;
        }
        if (rel.offset instanceof RexDynamicParam) {
            return rowCount;
        }
        int offset = rel.offset == null ? 0 : RexLiteral.intValue(rel.offset);
        rowCount = Math.max(rowCount - (double)offset, 0.0);
        if (rel.fetch != null) {
            if (rel.fetch instanceof RexDynamicParam) {
                return rowCount;
            }
            int limit = RexLiteral.intValue(rel.fetch);
            if ((double)limit < rowCount) {
                return limit;
            }
        }
        return rowCount;
    }

    public Double getRowCount(SingleRel rel, RelMetadataQuery mq) {
        return mq.getRowCount(rel.getInput());
    }

    public Double getRowCount(Join rel, RelMetadataQuery mq) {
        return RelMdUtil.getJoinRowCount(mq, rel, rel.getCondition());
    }

    public Double getRowCount(Aggregate rel, RelMetadataQuery mq) {
        ImmutableBitSet groupKey = rel.getGroupSet();
        Double distinctRowCount = mq.getDistinctRowCount(rel.getInput(), groupKey, null);
        if (distinctRowCount == null) {
            distinctRowCount = mq.getRowCount(rel.getInput()) / 10.0;
        }
        distinctRowCount = distinctRowCount * (double)rel.getGroupSets().size();
        return distinctRowCount;
    }

    public Double getRowCount(TableScan rel, RelMetadataQuery mq) {
        return rel.estimateRowCount(mq);
    }

    public Double getRowCount(Values rel, RelMetadataQuery mq) {
        return rel.estimateRowCount(mq);
    }

    public Double getRowCount(Exchange rel, RelMetadataQuery mq) {
        return mq.getRowCount(rel.getInput());
    }
}

