/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.object.message;

import io.jhdf.Superblock;
import io.jhdf.Utils;
import io.jhdf.exceptions.HdfException;
import io.jhdf.object.message.Message;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;

public class LinkMessage
extends Message {
    private static final int CREATION_ORDER_PRESENT = 2;
    private static final int LINK_TYPE_PRESENT = 3;
    private static final int LINK_CHARACTER_SET_PRESENT = 4;
    private final byte version;
    private final LinkType linkType;
    private final long creationOrder;
    private final String linkName;
    private long hardLinkAddress;
    private String softLink;
    private String externalFile;
    private String externalPath;

    public static LinkMessage fromBuffer(ByteBuffer bb, Superblock sb) {
        return new LinkMessage(bb, sb, null);
    }

    LinkMessage(ByteBuffer bb, Superblock sb, BitSet messageFlags) {
        super(messageFlags);
        Charset linkNameCharset;
        int sizeOfLengthOfLinkName;
        this.version = bb.get();
        if (this.version != 1) {
            throw new HdfException("Unrecognized version = " + this.version);
        }
        BitSet flags = BitSet.valueOf(new byte[]{bb.get()});
        int sizeOfLengthOfLinkNameIndex = Utils.bitsToInt(flags, 0, 2);
        switch (sizeOfLengthOfLinkNameIndex) {
            case 0: {
                sizeOfLengthOfLinkName = 1;
                break;
            }
            case 1: {
                sizeOfLengthOfLinkName = 2;
                break;
            }
            case 2: {
                sizeOfLengthOfLinkName = 4;
                break;
            }
            case 3: {
                sizeOfLengthOfLinkName = 8;
                break;
            }
            default: {
                throw new HdfException("Unrecognized size of link name");
            }
        }
        this.linkType = flags.get(3) ? LinkType.fromInt(Utils.readBytesAsUnsignedInt(bb, 1)) : LinkType.HARD;
        this.creationOrder = flags.get(2) ? Utils.readBytesAsUnsignedLong(bb, 8) : -1L;
        if (flags.get(4)) {
            int charsetValue = Utils.readBytesAsUnsignedInt(bb, 1);
            switch (charsetValue) {
                case 0: {
                    linkNameCharset = StandardCharsets.US_ASCII;
                    break;
                }
                case 1: {
                    linkNameCharset = StandardCharsets.UTF_8;
                    break;
                }
                default: {
                    throw new HdfException("Unknown link charset value = " + charsetValue);
                }
            }
        } else {
            linkNameCharset = StandardCharsets.US_ASCII;
        }
        int lengthOfLinkName = Utils.readBytesAsUnsignedInt(bb, sizeOfLengthOfLinkName);
        ByteBuffer nameBuffer = Utils.createSubBuffer(bb, lengthOfLinkName);
        this.linkName = linkNameCharset.decode(nameBuffer).toString();
        switch (this.linkType) {
            case HARD: {
                this.hardLinkAddress = Utils.readBytesAsUnsignedLong(bb, sb.getSizeOfOffsets());
                break;
            }
            case SOFT: {
                int lengthOfSoftLink = Utils.readBytesAsUnsignedInt(bb, 2);
                ByteBuffer linkBuffer = Utils.createSubBuffer(bb, lengthOfSoftLink);
                this.softLink = StandardCharsets.US_ASCII.decode(linkBuffer).toString();
                break;
            }
            case EXTERNAL: {
                int lengthOfExternalLink = Utils.readBytesAsUnsignedInt(bb, 2);
                ByteBuffer externalLinkBuffer = Utils.createSubBuffer(bb, lengthOfExternalLink);
                externalLinkBuffer.position(1);
                this.externalFile = Utils.readUntilNull(externalLinkBuffer);
                this.externalPath = Utils.readUntilNull(externalLinkBuffer);
                break;
            }
            default: {
                throw new HdfException("Unrecognized link type = " + (Object)((Object)this.linkType));
            }
        }
    }

    public byte getVersion() {
        return this.version;
    }

    public LinkType getLinkType() {
        return this.linkType;
    }

    public long getCreationOrder() {
        return this.creationOrder;
    }

    public String getLinkName() {
        return this.linkName;
    }

    public long getHardLinkAddress() {
        if (this.linkType == LinkType.HARD) {
            return this.hardLinkAddress;
        }
        throw new HdfException("This link message is not a hard link. Link type is: " + (Object)((Object)this.linkType));
    }

    public String getSoftLink() {
        if (this.linkType == LinkType.SOFT) {
            return this.softLink;
        }
        throw new HdfException("This link message is not a soft link. Link type is: " + (Object)((Object)this.linkType));
    }

    public String getExternalFile() {
        if (this.linkType == LinkType.EXTERNAL) {
            return this.externalFile;
        }
        throw new HdfException("This link message is not a external link. Link type is: " + (Object)((Object)this.linkType));
    }

    public String getExternalPath() {
        if (this.linkType == LinkType.EXTERNAL) {
            return this.externalPath;
        }
        throw new HdfException("This link message is not a external link. Link type is: " + (Object)((Object)this.linkType));
    }

    public static enum LinkType {
        HARD,
        SOFT,
        EXTERNAL;


        private static LinkType fromInt(int typeInt) {
            switch (typeInt) {
                case 0: {
                    return HARD;
                }
                case 1: {
                    return SOFT;
                }
                case 64: {
                    return EXTERNAL;
                }
            }
            throw new HdfException("Unrecognized link type: " + typeInt);
        }
    }
}

