/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.metastore.rdbms.transform;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.drill.metastore.metadata.MetadataType;
import org.apache.drill.metastore.operate.Delete;
import org.apache.drill.metastore.rdbms.exception.RdbmsMetastoreException;
import org.apache.drill.metastore.rdbms.operate.RdbmsOperation;
import org.apache.drill.metastore.rdbms.transform.MetadataMapper;
import org.apache.drill.metastore.rdbms.transform.Transformer;
import org.jooq.Condition;

public abstract class AbstractTransformer<T>
implements Transformer<T> {
    @Override
    public List<RdbmsOperation.Delete> toDelete(Delete delete) {
        Set mappers = this.toMappers(delete.metadataTypes());
        return mappers.stream().map(mapper -> new RdbmsOperation.Delete(mapper.table(), mapper.toCondition(delete.filter()))).collect(Collectors.toList());
    }

    @Override
    public List<RdbmsOperation.Delete> toDeleteAll() {
        Set mappers = this.toMappers(Collections.singleton(MetadataType.ALL));
        return mappers.stream().map(MetadataMapper::table).map(RdbmsOperation.Delete::new).collect(Collectors.toList());
    }

    protected RdbmsOperation.Overwrite toOverwrite(String metadataTypeString, List<T> units) {
        MetadataType metadataType = MetadataType.fromValue((String)metadataTypeString);
        if (metadataType == null) {
            throw new RdbmsMetastoreException("Metadata type must be specified during insert / update");
        }
        MetadataMapper mapper = this.toMapper(metadataType);
        List<Condition> deleteConditions = mapper.toDeleteConditions(units);
        List records = units.stream().map(mapper::toRecord).collect(Collectors.toList());
        return new RdbmsOperation.Overwrite(mapper.table(), deleteConditions, records);
    }
}

