/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.metastore.rdbms.operate;

import java.util.ArrayList;
import java.util.List;
import org.apache.drill.metastore.operate.AbstractModify;
import org.apache.drill.metastore.operate.Delete;
import org.apache.drill.metastore.operate.MetadataTypeValidator;
import org.apache.drill.metastore.rdbms.RdbmsMetastoreContext;
import org.apache.drill.metastore.rdbms.exception.RdbmsMetastoreException;
import org.apache.drill.metastore.rdbms.operate.RdbmsOperation;
import org.apache.drill.metastore.rdbms.transform.Transformer;
import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.impl.DSL;

public class RdbmsModify<T>
extends AbstractModify<T> {
    private final RdbmsMetastoreContext<T> context;
    private final Transformer<T> transformer;
    private final List<RdbmsOperation> operations = new ArrayList<RdbmsOperation>();

    public RdbmsModify(MetadataTypeValidator metadataTypeValidator, RdbmsMetastoreContext<T> context) {
        super(metadataTypeValidator);
        this.context = context;
        this.transformer = context.transformer();
    }

    public void execute() {
        this.executeOperations(this.operations);
    }

    public void purge() {
        ArrayList<RdbmsOperation> deletes = new ArrayList<RdbmsOperation>(this.transformer.toDeleteAll());
        this.executeOperations(deletes);
    }

    private void executeOperations(List<RdbmsOperation> operations) {
        try (DSLContext executor = this.context.executorProvider().executor();){
            executor.transaction(configuration -> {
                DSLContext transactionalExecutor = DSL.using((Configuration)configuration);
                operations.forEach(operation -> operation.execute(transactionalExecutor));
            });
        }
        catch (RuntimeException e) {
            throw new RdbmsMetastoreException("Error during Metastore modify operation execution: " + e.getMessage(), e);
        }
    }

    protected void addOverwrite(List<T> units) {
        this.operations.addAll(this.transformer.toOverwrite(units));
    }

    protected void addDelete(Delete delete) {
        this.operations.addAll(this.transformer.toDelete(delete));
    }
}

