/*
 * Decompiled with CFR 0.152.
 */
package org.ojai.json.mapreduce;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.ReflectionUtils;
import org.ojai.Document;
import org.ojai.json.mapreduce.JSONFileOutputRecordWriter;

public class JSONFileOutputFormat
extends FileOutputFormat<LongWritable, Document> {
    public RecordWriter<LongWritable, Document> getRecordWriter(TaskAttemptContext job) throws IOException, InterruptedException {
        Configuration conf = job.getConfiguration();
        boolean isCompressed = JSONFileOutputFormat.getCompressOutput((JobContext)job);
        CompressionCodec codec = null;
        String extension = "";
        if (isCompressed) {
            Class codecClass = JSONFileOutputFormat.getOutputCompressorClass((JobContext)job, GzipCodec.class);
            codec = (CompressionCodec)ReflectionUtils.newInstance((Class)codecClass, (Configuration)conf);
            extension = codec.getDefaultExtension();
        }
        Path path = this.getDefaultWorkFile(job, extension);
        FileSystem fs = path.getFileSystem(conf);
        FSDataOutputStream out = fs.create(path, false);
        if (!isCompressed) {
            return new JSONFileOutputRecordWriter((OutputStream)out);
        }
        return new JSONFileOutputRecordWriter(new DataOutputStream((OutputStream)codec.createOutputStream((OutputStream)out)));
    }
}

