/*
 * Decompiled with CFR 0.152.
 */
package org.ojai.json.mapreduce;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.ojai.DocumentStream;
import org.ojai.FieldPath;
import org.ojai.Value;
import org.ojai.annotation.API;
import org.ojai.exceptions.DecodingException;
import org.ojai.exceptions.OjaiException;
import org.ojai.json.Events;
import org.ojai.json.impl.JsonDocumentStream;

@API.Public
@API.Factory
public class Hadoop {
    public static DocumentStream newDocumentStream(@API.NonNullable FileSystem fs, @API.NonNullable String path) throws DecodingException, IOException {
        return Hadoop.newDocumentStream(fs, new Path(path), null, null);
    }

    public static DocumentStream newDocumentStream(@API.NonNullable FileSystem fs, @API.NonNullable String path, @API.NonNullable Map<FieldPath, Value.Type> fieldPathTypeMap) throws DecodingException, IOException {
        Preconditions.checkNotNull(fieldPathTypeMap);
        return Hadoop.newDocumentStream(fs, new Path(path), fieldPathTypeMap, null);
    }

    public static DocumentStream newDocumentStream(@API.NonNullable FileSystem fs, @API.NonNullable String path, @API.NonNullable Events.Delegate eventDelegate) throws DecodingException, IOException {
        Preconditions.checkNotNull((Object)eventDelegate);
        return Hadoop.newDocumentStream(fs, new Path(path), null, eventDelegate);
    }

    public static DocumentStream newDocumentStream(FileSystem fs, String path, Map<FieldPath, Value.Type> map, Events.Delegate delegate) throws IllegalArgumentException, IOException {
        Preconditions.checkNotNull(map);
        Preconditions.checkNotNull((Object)delegate);
        return Hadoop.newDocumentStream(fs, new Path(path), map, delegate);
    }

    private static DocumentStream newDocumentStream(@API.NonNullable FileSystem fs, @API.NonNullable Path path, @API.Nullable Map<FieldPath, Value.Type> map, @API.Nullable Events.Delegate delegate) throws IllegalArgumentException, IOException {
        Preconditions.checkNotNull((Object)fs);
        FSDataInputStream in = fs.open(path);
        return new JsonDocumentStream((InputStream)in, map, delegate, (InputStream)in){
            final /* synthetic */ InputStream val$in;
            {
                this.val$in = inputStream;
                super(x0, x1, x2);
            }

            public void close() {
                try {
                    super.close();
                }
                finally {
                    try {
                        this.val$in.close();
                    }
                    catch (IOException e) {
                        throw new OjaiException((Throwable)e);
                    }
                }
            }
        };
    }
}

