/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.metastore.metadata;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.metastore.components.tables.TableMetadataUnit;
import org.apache.drill.metastore.metadata.BaseMetadata;
import org.apache.hadoop.fs.Path;

public class PartitionMetadata
extends BaseMetadata {
    private final SchemaPath column;
    private final List<String> partitionValues;
    private final Set<Path> locations;

    private PartitionMetadata(PartitionMetadataBuilder builder) {
        super(builder);
        this.column = builder.column;
        this.partitionValues = builder.partitionValues;
        this.locations = builder.locations;
    }

    public SchemaPath getColumn() {
        return this.column;
    }

    public Set<Path> getLocations() {
        return this.locations;
    }

    public List<String> getPartitionValues() {
        return this.partitionValues;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PartitionMetadata that = (PartitionMetadata)o;
        return Objects.equals(this.column, that.column) && Objects.equals(this.partitionValues, that.partitionValues) && Objects.equals(this.locations, that.locations);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.column, this.partitionValues, this.locations);
    }

    public String toString() {
        return new StringJoiner(",\n", PartitionMetadata.class.getSimpleName() + "[\n", "]").add("column=" + this.column).add("partitionValues=" + this.partitionValues).add("locations=" + this.locations).add("tableInfo=" + this.tableInfo).add("metadataInfo=" + this.metadataInfo).add("schema=" + this.schema).add("columnsStatistics=" + this.columnsStatistics).add("metadataStatistics=" + this.metadataStatistics).add("lastModifiedTime=" + this.lastModifiedTime).toString();
    }

    @Override
    protected void toMetadataUnitBuilder(TableMetadataUnit.Builder builder) {
        builder.column(this.column.toString());
        builder.partitionValues(this.partitionValues);
        builder.locations(this.locations.stream().map(location -> location.toUri().getPath()).collect(Collectors.toList()));
    }

    public PartitionMetadataBuilder toBuilder() {
        return ((PartitionMetadataBuilder)((PartitionMetadataBuilder)((PartitionMetadataBuilder)((PartitionMetadataBuilder)((PartitionMetadataBuilder)((PartitionMetadataBuilder)PartitionMetadata.builder().tableInfo(this.tableInfo)).metadataInfo(this.metadataInfo)).schema(this.schema)).columnsStatistics(this.columnsStatistics)).metadataStatistics(this.metadataStatistics.values())).lastModifiedTime(this.lastModifiedTime)).column(this.column).partitionValues(this.partitionValues).locations(this.locations);
    }

    public static PartitionMetadataBuilder builder() {
        return new PartitionMetadataBuilder();
    }

    public static class PartitionMetadataBuilder
    extends BaseMetadata.BaseMetadataBuilder<PartitionMetadataBuilder> {
        private SchemaPath column;
        private List<String> partitionValues;
        private Set<Path> locations;

        public PartitionMetadataBuilder locations(Set<Path> locations) {
            this.locations = locations;
            return this.self();
        }

        public PartitionMetadataBuilder partitionValues(List<String> partitionValues) {
            this.partitionValues = partitionValues;
            return this.self();
        }

        public PartitionMetadataBuilder column(SchemaPath column) {
            this.column = column;
            return this.self();
        }

        @Override
        protected void checkRequiredValues() {
            super.checkRequiredValues();
            Objects.requireNonNull(this.column, "column was not set");
            Objects.requireNonNull(this.partitionValues, "partitionValues were not set");
            Objects.requireNonNull(this.locations, "locations were not set");
        }

        @Override
        public PartitionMetadata build() {
            this.checkRequiredValues();
            return new PartitionMetadata(this);
        }

        @Override
        protected PartitionMetadataBuilder self() {
            return this;
        }

        @Override
        protected PartitionMetadataBuilder metadataUnitInternal(TableMetadataUnit unit) {
            if (unit.locations() != null) {
                this.locations(unit.locations().stream().map(Path::new).collect(Collectors.toSet()));
            }
            this.partitionValues(unit.partitionValues());
            this.column(SchemaPath.parseFromString((String)unit.column()));
            return this.self();
        }
    }
}

