/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.cassandra;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.drill.common.logical.AbstractSecuredStoragePluginConfig;
import org.apache.drill.common.logical.security.CredentialsProvider;
import org.apache.drill.exec.store.security.CredentialProviderUtils;
import org.apache.drill.exec.store.security.UsernamePasswordCredentials;

@JsonTypeName(value="cassandra")
public class CassandraStorageConfig
extends AbstractSecuredStoragePluginConfig {
    public static final String NAME = "cassandra";
    private final String host;
    private final int port;

    @JsonCreator
    public CassandraStorageConfig(@JsonProperty(value="host") String host, @JsonProperty(value="port") int port, @JsonProperty(value="username") String username, @JsonProperty(value="password") String password, @JsonProperty(value="credentialsProvider") CredentialsProvider credentialsProvider) {
        super(CredentialProviderUtils.getCredentialsProvider((String)username, (String)password, (CredentialsProvider)credentialsProvider), credentialsProvider == null);
        this.host = host;
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    @JsonIgnore
    public UsernamePasswordCredentials getUsernamePasswordCredentials() {
        return new UsernamePasswordCredentials(this.credentialsProvider);
    }

    public String getUsername() {
        if (this.directCredentials) {
            return this.getUsernamePasswordCredentials().getUsername();
        }
        return null;
    }

    public String getPassword() {
        if (this.directCredentials) {
            return this.getUsernamePasswordCredentials().getPassword();
        }
        return null;
    }

    @JsonIgnore
    public Map<String, Object> toConfigMap() {
        UsernamePasswordCredentials credentials = this.getUsernamePasswordCredentials();
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("host", this.host);
        result.put("port", this.port);
        result.put("username", credentials.getUsername());
        result.put("password", credentials.getPassword());
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        CassandraStorageConfig that = (CassandraStorageConfig)((Object)o);
        return Objects.equals(this.host, that.host) && Objects.equals(this.credentialsProvider, that.credentialsProvider);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.credentialsProvider);
    }
}

