/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.avro;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import io.confluent.kafka.schemaregistry.utils.JacksonMapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericContainer;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.io.JsonEncoder;
import org.apache.avro.reflect.ReflectData;
import org.apache.kafka.common.errors.SerializationException;

public class AvroSchemaUtils {
    private static final EncoderFactory encoderFactory = EncoderFactory.get();
    private static final DecoderFactory decoderFactory = DecoderFactory.get();
    private static final ObjectMapper jsonMapper = JacksonMapper.INSTANCE;
    private static final Map<String, Schema> primitiveSchemas = new HashMap<String, Schema>();

    private static Schema createPrimitiveSchema(String type) {
        String schemaString = String.format("{\"type\" : \"%s\"}", type);
        return new AvroSchema(schemaString).rawSchema();
    }

    public static AvroSchema copyOf(AvroSchema schema) {
        return schema.copy();
    }

    public static Map<String, Schema> getPrimitiveSchemas() {
        return Collections.unmodifiableMap(primitiveSchemas);
    }

    public static Schema getSchema(Object object) {
        return AvroSchemaUtils.getSchema(object, false, false);
    }

    public static Schema getSchema(Object object, boolean useReflection, boolean removeJavaProperties) {
        if (object == null) {
            return primitiveSchemas.get("Null");
        }
        if (object instanceof Boolean) {
            return primitiveSchemas.get("Boolean");
        }
        if (object instanceof Integer) {
            return primitiveSchemas.get("Integer");
        }
        if (object instanceof Long) {
            return primitiveSchemas.get("Long");
        }
        if (object instanceof Float) {
            return primitiveSchemas.get("Float");
        }
        if (object instanceof Double) {
            return primitiveSchemas.get("Double");
        }
        if (object instanceof CharSequence) {
            return primitiveSchemas.get("String");
        }
        if (object instanceof byte[] || object instanceof ByteBuffer) {
            return primitiveSchemas.get("Bytes");
        }
        if (useReflection) {
            Schema schema = ReflectData.get().getSchema(object.getClass());
            if (schema == null) {
                throw new SerializationException("Schema is null for object of class " + object.getClass().getCanonicalName());
            }
            return schema;
        }
        if (object instanceof GenericContainer) {
            Schema schema = ((GenericContainer)object).getSchema();
            if (removeJavaProperties) {
                schema = AvroSchemaUtils.removeJavaProperties(schema);
            }
            return schema;
        }
        if (object instanceof Map) {
            Map mapValue = (Map)object;
            if (mapValue.isEmpty()) {
                return Schema.createMap((Schema)primitiveSchemas.get("Null"));
            }
            Schema valueSchema = AvroSchemaUtils.getSchema(mapValue.values().iterator().next());
            return Schema.createMap((Schema)valueSchema);
        }
        throw new IllegalArgumentException("Unsupported Avro type. Supported types are null, Boolean, Integer, Long, Float, Double, String, byte[] and IndexedRecord");
    }

    private static Schema removeJavaProperties(Schema schema) {
        try {
            JsonNode node = jsonMapper.readTree(schema.toString());
            AvroSchemaUtils.removeProperty(node, "avro.java.string");
            AvroSchema avroSchema = new AvroSchema(node.toString());
            return avroSchema.rawSchema();
        }
        catch (IOException e) {
            throw new SerializationException("Could not parse schema: " + schema.toString());
        }
    }

    private static void removeProperty(JsonNode node, String propertyName) {
        block3: {
            block2: {
                if (!node.isObject()) break block2;
                ObjectNode objectNode = (ObjectNode)node;
                objectNode.remove(propertyName);
                Iterator elements = objectNode.elements();
                while (elements.hasNext()) {
                    AvroSchemaUtils.removeProperty((JsonNode)elements.next(), propertyName);
                }
                break block3;
            }
            if (!node.isArray()) break block3;
            ArrayNode arrayNode = (ArrayNode)node;
            Iterator elements = arrayNode.elements();
            while (elements.hasNext()) {
                AvroSchemaUtils.removeProperty((JsonNode)elements.next(), propertyName);
            }
        }
    }

    public static Object toObject(JsonNode value, AvroSchema schema) throws IOException {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            Object object;
            Schema rawSchema = schema.rawSchema();
            jsonMapper.writeValue((OutputStream)out, (Object)value);
            GenericDatumReader reader = new GenericDatumReader(rawSchema);
            Object object2 = object = reader.read(null, (Decoder)decoderFactory.jsonDecoder(rawSchema, (InputStream)new ByteArrayInputStream(out.toByteArray())));
            return object2;
        }
    }

    public static Object toObject(String value, AvroSchema schema) throws IOException {
        Schema rawSchema = schema.rawSchema();
        GenericDatumReader reader = new GenericDatumReader(rawSchema);
        Object object = reader.read(null, (Decoder)decoderFactory.jsonDecoder(rawSchema, value));
        return object;
    }

    public static byte[] toJson(Object value) throws IOException {
        if (value == null) {
            return null;
        }
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            AvroSchemaUtils.toJson(value, out);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }

    public static void toJson(Object value, OutputStream out) throws IOException {
        Schema schema = AvroSchemaUtils.getSchema(value);
        JsonEncoder encoder = encoderFactory.jsonEncoder(schema, out);
        GenericDatumWriter writer = new GenericDatumWriter(schema);
        Object wrappedValue = value;
        if (value instanceof byte[]) {
            wrappedValue = ByteBuffer.wrap((byte[])value);
        }
        writer.write(wrappedValue, (Encoder)encoder);
        encoder.flush();
    }

    static {
        primitiveSchemas.put("Null", AvroSchemaUtils.createPrimitiveSchema("null"));
        primitiveSchemas.put("Boolean", AvroSchemaUtils.createPrimitiveSchema("boolean"));
        primitiveSchemas.put("Integer", AvroSchemaUtils.createPrimitiveSchema("int"));
        primitiveSchemas.put("Long", AvroSchemaUtils.createPrimitiveSchema("long"));
        primitiveSchemas.put("Float", AvroSchemaUtils.createPrimitiveSchema("float"));
        primitiveSchemas.put("Double", AvroSchemaUtils.createPrimitiveSchema("double"));
        primitiveSchemas.put("String", AvroSchemaUtils.createPrimitiveSchema("string"));
        primitiveSchemas.put("Bytes", AvroSchemaUtils.createPrimitiveSchema("bytes"));
    }
}

