/*
 * Decompiled with CFR 0.152.
 */
package technology.tabula;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.pdfbox.contentstream.PDFGraphicsStreamEngine;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.image.PDImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import technology.tabula.Ruling;
import technology.tabula.Utils;

class ObjectExtractorStreamEngine
extends PDFGraphicsStreamEngine {
    protected List<Ruling> rulings;
    private AffineTransform pageTransform;
    private boolean extractRulingLines = true;
    private Logger logger;
    private int clipWindingRule = -1;
    private GeneralPath currentPath = new GeneralPath();
    private static final float RULING_MINIMUM_LENGTH = 0.01f;

    protected ObjectExtractorStreamEngine(PDPage page) {
        super(page);
        this.logger = LoggerFactory.getLogger(ObjectExtractorStreamEngine.class);
        this.rulings = new ArrayList<Ruling>();
        this.pageTransform = new AffineTransform();
        PDRectangle pageCropBox = this.getPage().getCropBox();
        int rotationAngleInDegrees = this.getPage().getRotation();
        if (Math.abs(rotationAngleInDegrees) == 90 || Math.abs(rotationAngleInDegrees) == 270) {
            double rotationAngleInRadians = (double)rotationAngleInDegrees * (Math.PI / 180);
            this.pageTransform = AffineTransform.getRotateInstance(rotationAngleInRadians, 0.0, 0.0);
        } else {
            double deltaX = 0.0;
            double deltaY = pageCropBox.getHeight();
            this.pageTransform.concatenate(AffineTransform.getTranslateInstance(deltaX, deltaY));
        }
        this.pageTransform.concatenate(AffineTransform.getScaleInstance(1.0, -1.0));
        this.pageTransform.translate(-pageCropBox.getLowerLeftX(), -pageCropBox.getLowerLeftY());
    }

    public void appendRectangle(Point2D p0, Point2D p1, Point2D p2, Point2D p3) {
        this.currentPath.moveTo((float)p0.getX(), (float)p0.getY());
        this.currentPath.lineTo((float)p1.getX(), (float)p1.getY());
        this.currentPath.lineTo((float)p2.getX(), (float)p2.getY());
        this.currentPath.lineTo((float)p3.getX(), (float)p3.getY());
        this.currentPath.closePath();
    }

    public void clip(int windingRule) {
        this.clipWindingRule = windingRule;
    }

    public void closePath() {
        this.currentPath.closePath();
    }

    public void curveTo(float x1, float y1, float x2, float y2, float x3, float y3) {
        this.currentPath.curveTo(x1, y1, x2, y2, x3, y3);
    }

    public void drawImage(PDImage arg0) {
    }

    public void endPath() {
        if (this.clipWindingRule != -1) {
            this.currentPath.setWindingRule(this.clipWindingRule);
            this.getGraphicsState().intersectClippingPath(this.currentPath);
            this.clipWindingRule = -1;
        }
        this.currentPath.reset();
    }

    public void fillAndStrokePath(int arg0) {
        this.strokeOrFillPath(true);
    }

    public void fillPath(int arg0) {
        this.strokeOrFillPath(true);
    }

    public Point2D getCurrentPoint() {
        return this.currentPath.getCurrentPoint();
    }

    public void lineTo(float x, float y) {
        this.currentPath.lineTo(x, y);
    }

    public void moveTo(float x, float y) {
        this.currentPath.moveTo(x, y);
    }

    public void shadingFill(COSName arg0) {
    }

    public void strokePath() {
        this.strokeOrFillPath(false);
    }

    private void strokeOrFillPath(boolean isFill) {
        Point2D.Float startPoint;
        if (!this.extractRulingLines) {
            this.currentPath.reset();
            return;
        }
        boolean didNotPassedTheFilter = this.filterPathBySegmentType();
        if (didNotPassedTheFilter) {
            return;
        }
        PathIterator pathIterator = this.currentPath.getPathIterator(this.getPageTransform());
        float[] coordinates = new float[6];
        Point2D.Float last_move = startPoint = this.getStartPoint(pathIterator);
        Point2D.Float endPoint = null;
        PointComparator pointComparator = new PointComparator();
        while (!pathIterator.isDone()) {
            int currentSegment;
            pathIterator.next();
            try {
                currentSegment = pathIterator.currentSegment(coordinates);
            }
            catch (IndexOutOfBoundsException ex) {
                continue;
            }
            switch (currentSegment) {
                case 1: {
                    endPoint = new Point2D.Float(coordinates[0], coordinates[1]);
                    if (startPoint == null || endPoint == null) break;
                    Line2D.Float line = this.getLineBetween(startPoint, endPoint, pointComparator);
                    this.verifyLineIntersectsClipping(line);
                    break;
                }
                case 0: {
                    endPoint = last_move = new Point2D.Float(coordinates[0], coordinates[1]);
                    break;
                }
                case 4: {
                    if (startPoint == null || endPoint == null) break;
                    Line2D.Float line = this.getLineBetween(endPoint, last_move, pointComparator);
                    this.verifyLineIntersectsClipping(line);
                }
            }
            startPoint = endPoint;
        }
        this.currentPath.reset();
    }

    private boolean filterPathBySegmentType() {
        float[] coordinates;
        PathIterator pathIterator = this.currentPath.getPathIterator(this.pageTransform);
        int currentSegmentType = pathIterator.currentSegment(coordinates = new float[6]);
        if (currentSegmentType != 0) {
            this.currentPath.reset();
            return true;
        }
        pathIterator.next();
        while (!pathIterator.isDone()) {
            currentSegmentType = pathIterator.currentSegment(coordinates);
            if (currentSegmentType != 1 && currentSegmentType != 4 && currentSegmentType != 0) {
                this.currentPath.reset();
                return true;
            }
            pathIterator.next();
        }
        return false;
    }

    private Point2D.Float getStartPoint(PathIterator pathIterator) {
        float[] startPointCoordinates = new float[6];
        pathIterator.currentSegment(startPointCoordinates);
        float x = Utils.round(startPointCoordinates[0], 2);
        float y = Utils.round(startPointCoordinates[1], 2);
        return new Point2D.Float(x, y);
    }

    private Line2D.Float getLineBetween(Point2D.Float pointA, Point2D.Float pointB, PointComparator pointComparator) {
        if (pointComparator.compare(pointA, pointB) == -1) {
            return new Line2D.Float(pointA, pointB);
        }
        return new Line2D.Float(pointB, pointA);
    }

    private void verifyLineIntersectsClipping(Line2D.Float line) {
        Ruling ruling;
        Rectangle2D currentClippingPath = this.currentClippingPath();
        if (line.intersects(currentClippingPath) && (ruling = new Ruling(line.getP1(), line.getP2()).intersect(currentClippingPath)).length() > (double)0.01f) {
            this.rulings.add(ruling);
        }
    }

    public AffineTransform getPageTransform() {
        return this.pageTransform;
    }

    public Rectangle2D currentClippingPath() {
        Area currentClippingPath = this.getGraphicsState().getCurrentClippingPath();
        Shape transformedClippingPath = this.getPageTransform().createTransformedShape(currentClippingPath);
        return transformedClippingPath.getBounds2D();
    }

    class PointComparator
    implements Comparator<Point2D> {
        PointComparator() {
        }

        @Override
        public int compare(Point2D p1, Point2D p2) {
            float p1X = Utils.round(p1.getX(), 2);
            float p1Y = Utils.round(p1.getY(), 2);
            float p2X = Utils.round(p2.getX(), 2);
            float p2Y = Utils.round(p2.getY(), 2);
            if (p1Y > p2Y) {
                return 1;
            }
            if (p1Y < p2Y) {
                return -1;
            }
            if (p1X > p2X) {
                return 1;
            }
            if (p1X < p2X) {
                return -1;
            }
            return 0;
        }
    }
}

