/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.TransactionOptions;
import com.mongodb.annotations.Immutable;
import com.mongodb.annotations.NotThreadSafe;
import com.mongodb.assertions.Assertions;
import com.mongodb.lang.Nullable;
import java.util.Objects;

@Immutable
public final class ClientSessionOptions {
    private final Boolean causallyConsistent;
    private final Boolean snapshot;
    private final TransactionOptions defaultTransactionOptions;

    @Nullable
    public Boolean isCausallyConsistent() {
        return this.causallyConsistent;
    }

    @Nullable
    public Boolean isSnapshot() {
        return this.snapshot;
    }

    public TransactionOptions getDefaultTransactionOptions() {
        return this.defaultTransactionOptions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientSessionOptions that = (ClientSessionOptions)o;
        if (!Objects.equals(this.causallyConsistent, that.causallyConsistent)) {
            return false;
        }
        if (!Objects.equals(this.snapshot, that.snapshot)) {
            return false;
        }
        return Objects.equals(this.defaultTransactionOptions, that.defaultTransactionOptions);
    }

    public int hashCode() {
        int result = this.causallyConsistent != null ? this.causallyConsistent.hashCode() : 0;
        result = 31 * result + (this.snapshot != null ? this.snapshot.hashCode() : 0);
        result = 31 * result + (this.defaultTransactionOptions != null ? this.defaultTransactionOptions.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ClientSessionOptions{causallyConsistent=" + this.causallyConsistent + "snapshot=" + this.snapshot + ", defaultTransactionOptions=" + this.defaultTransactionOptions + '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ClientSessionOptions options) {
        Assertions.notNull("options", options);
        Builder builder = new Builder();
        builder.causallyConsistent = options.isCausallyConsistent();
        builder.snapshot = options.isSnapshot();
        builder.defaultTransactionOptions = options.getDefaultTransactionOptions();
        return builder;
    }

    private ClientSessionOptions(Builder builder) {
        if (builder.causallyConsistent != null && builder.causallyConsistent.booleanValue() && builder.snapshot != null && builder.snapshot.booleanValue()) {
            throw new IllegalArgumentException("A session can not be both a snapshot and causally consistent");
        }
        this.causallyConsistent = builder.causallyConsistent != null || builder.snapshot == null ? builder.causallyConsistent : Boolean.valueOf(builder.snapshot == false);
        this.snapshot = builder.snapshot;
        this.defaultTransactionOptions = builder.defaultTransactionOptions;
    }

    @NotThreadSafe
    public static final class Builder {
        private Boolean causallyConsistent;
        private Boolean snapshot;
        private TransactionOptions defaultTransactionOptions = TransactionOptions.builder().build();

        public Builder causallyConsistent(boolean causallyConsistent) {
            this.causallyConsistent = causallyConsistent;
            return this;
        }

        public Builder snapshot(boolean snapshot) {
            this.snapshot = snapshot;
            return this;
        }

        public Builder defaultTransactionOptions(TransactionOptions defaultTransactionOptions) {
            this.defaultTransactionOptions = Assertions.notNull("defaultTransactionOptions", defaultTransactionOptions);
            return this;
        }

        public ClientSessionOptions build() {
            return new ClientSessionOptions(this);
        }

        private Builder() {
        }
    }
}

