/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.iceberg;

import com.google.common.collect.ImmutableRangeMap;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.store.TimedCallable;
import org.apache.drill.exec.store.iceberg.IcebergCompleteWork;
import org.apache.drill.exec.store.schedule.EndpointByteMap;
import org.apache.drill.exec.store.schedule.EndpointByteMapImpl;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.BaseCombinedScanTask;
import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.FileScanTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcebergBlockMapBuilder {
    private static final Logger logger = LoggerFactory.getLogger(IcebergBlockMapBuilder.class);
    private final Map<FileScanTask, RangeMap<Long, BlockLocation>> blockMapMap;
    private final Map<String, CoordinationProtos.DrillbitEndpoint> endPointMap;
    private final FileSystem fs;

    public IcebergBlockMapBuilder(FileSystem fs, Collection<CoordinationProtos.DrillbitEndpoint> endpoints) {
        this.fs = fs;
        this.blockMapMap = new ConcurrentHashMap<FileScanTask, RangeMap<Long, BlockLocation>>();
        this.endPointMap = endpoints.stream().collect(Collectors.toMap(CoordinationProtos.DrillbitEndpoint::getAddress, endpoint -> endpoint, (a, b) -> b));
    }

    public List<IcebergCompleteWork> generateFileWork(Iterable<CombinedScanTask> combinedScanTasks) throws IOException {
        ArrayList<BlockMapReader> readers = new ArrayList<BlockMapReader>();
        combinedScanTasks.forEach(task -> readers.add(new BlockMapReader((CombinedScanTask)task)));
        if (readers.isEmpty()) {
            readers.add(new BlockMapReader((CombinedScanTask)new BaseCombinedScanTask(new FileScanTask[0])));
        }
        return TimedCallable.run((String)"Get block maps", (Logger)logger, readers, (int)16);
    }

    private RangeMap<Long, BlockLocation> buildBlockMap(FileScanTask work) throws IOException {
        BlockLocation[] blocks = this.fs.getFileBlockLocations(new Path(work.file().path().toString()), work.start(), work.length());
        ImmutableRangeMap.Builder blockMapBuilder = new ImmutableRangeMap.Builder();
        for (BlockLocation block : blocks) {
            long start = block.getOffset();
            long end = start + block.getLength();
            Range range = Range.closedOpen((Comparable)Long.valueOf(start), (Comparable)Long.valueOf(end));
            blockMapBuilder.put(range, (Object)block);
        }
        ImmutableRangeMap blockMap = blockMapBuilder.build();
        this.blockMapMap.put(work, (RangeMap<Long, BlockLocation>)blockMap);
        return blockMap;
    }

    private RangeMap<Long, BlockLocation> getBlockMap(FileScanTask work) throws IOException {
        RangeMap<Long, BlockLocation> blockMap = this.blockMapMap.get(work);
        if (blockMap == null) {
            blockMap = this.buildBlockMap(work);
        }
        return blockMap;
    }

    public EndpointByteMap getEndpointByteMap(CombinedScanTask scanTask) throws IOException {
        EndpointByteMapImpl endpointByteMap = new EndpointByteMapImpl();
        for (FileScanTask work : scanTask.files()) {
            RangeMap<Long, BlockLocation> blockMap = this.getBlockMap(work);
            long start = work.start();
            long end = start + work.length();
            Range scanTaskRange = Range.closedOpen((Comparable)Long.valueOf(start), (Comparable)Long.valueOf(end));
            RangeMap subRangeMap = blockMap.subRangeMap(scanTaskRange);
            for (Map.Entry block : subRangeMap.asMapOfRanges().entrySet()) {
                Range intersection = scanTaskRange.intersection((Range)block.getKey());
                long bytes = (Long)intersection.upperEndpoint() - (Long)intersection.lowerEndpoint();
                for (String host : ((BlockLocation)block.getValue()).getHosts()) {
                    CoordinationProtos.DrillbitEndpoint endpoint = this.endPointMap.get(host);
                    if (endpoint == null) continue;
                    endpointByteMap.add(endpoint, bytes);
                }
            }
            logger.debug("FileScanTask group ({},{}) max bytes {}", new Object[]{work.file().path(), work.start(), endpointByteMap.getMaxBytes()});
        }
        return endpointByteMap;
    }

    private class BlockMapReader
    extends TimedCallable<IcebergCompleteWork> {
        private final CombinedScanTask scanTask;

        public BlockMapReader(CombinedScanTask scanTask) {
            this.scanTask = scanTask;
        }

        protected IcebergCompleteWork runInner() throws Exception {
            return new IcebergCompleteWork(IcebergBlockMapBuilder.this.getEndpointByteMap(this.scanTask), this.scanTask);
        }
    }
}

