/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.modularinput;

import com.splunk.modularinput.MalformedDataException;
import com.splunk.modularinput.Parameter;
import com.splunk.modularinput.XmlUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class InputDefinition {
    private Map<String, String> metadata;
    private Map<String, Map<String, Parameter>> inputs = new HashMap<String, Map<String, Parameter>>();
    private final String serverHostField = "server_host";
    private final String serverUriField = "server_uri";
    private final String checkpointDirField = "checkpoint_dir";
    private final String sessionKeyField = "session_key";

    InputDefinition() {
        this.metadata = new HashMap<String, String>();
    }

    public String getField(String fieldName) {
        return this.metadata.get(fieldName);
    }

    public void setServerHost(String serverHost) {
        this.metadata.put("server_host", serverHost);
    }

    public String getServerHost() {
        return this.metadata.get("server_host");
    }

    public void setServerUri(String serverUri) {
        this.metadata.put("server_uri", serverUri);
    }

    public String getServerUri() {
        return this.metadata.get("server_uri");
    }

    public void setCheckpointDir(String checkpointDir) {
        this.metadata.put("checkpoint_dir", checkpointDir);
    }

    public String getCheckpointDir() {
        return this.metadata.get("checkpoint_dir");
    }

    public void setSessionKey(String sessionKey) {
        this.metadata.put("session_key", sessionKey);
    }

    public String getSessionKey() {
        return this.metadata.get("session_key");
    }

    public void addInput(String name, Collection<Parameter> parameters) {
        HashMap<String, Parameter> paramMap = new HashMap<String, Parameter>();
        for (Parameter p : parameters) {
            paramMap.put(p.getName(), p);
        }
        this.inputs.put(name, paramMap);
    }

    public Map<String, Map<String, Parameter>> getInputs() {
        return this.inputs;
    }

    public static InputDefinition parseDefinition(InputStream stream) throws ParserConfigurationException, IOException, SAXException, MalformedDataException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setIgnoringElementContentWhitespace(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document doc = documentBuilder.parse(stream);
        InputDefinition definition = new InputDefinition();
        for (Node node = doc.getDocumentElement().getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() == 3) continue;
            if (node.getNodeName().equals("configuration")) {
                for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    if (child.getNodeType() == 3) continue;
                    if (!child.getNodeName().equals("stanza")) {
                        throw new MalformedDataException("Expected stanza element; found " + child.getNodeName());
                    }
                    String name = child.getAttributes().getNamedItem("name").getNodeValue();
                    List<Parameter> parameter = Parameter.nodeToParameterList(child);
                    definition.addInput(name, parameter);
                }
                continue;
            }
            definition.metadata.put(node.getNodeName(), XmlUtil.textInNode(node, "Expected a text value in element " + node.getNodeName()));
        }
        return definition;
    }

    public boolean equals(Object other) {
        if (!(other instanceof InputDefinition)) {
            return false;
        }
        InputDefinition that = (InputDefinition)other;
        return this.metadata.equals(that.metadata) && this.inputs.equals(that.inputs);
    }

    public int hashCode() {
        return this.metadata.hashCode() ^ (this.getInputs() == null ? 0 : this.getInputs().hashCode());
    }
}

