/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.reflection;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.reflection.ParameterReflection;

public final class AnnotationReflection {
    private AnnotationReflection() {
    }

    @Nonnull
    public static String readAnnotationAttribute(@Nonnull Object annotationInstance, @Nonnull String attributeName) {
        try {
            return AnnotationReflection.readAttribute(annotationInstance, attributeName);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    public static String readAnnotationAttributeIfAvailable(@Nonnull Object annotationInstance, @Nonnull String attributeName) {
        try {
            return AnnotationReflection.readAttribute(annotationInstance, attributeName);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    @Nonnull
    private static String readAttribute(@Nonnull Object annotationInstance, @Nonnull String attributeName) throws NoSuchMethodException {
        try {
            Method publicMethod = annotationInstance.getClass().getMethod(attributeName, ParameterReflection.NO_PARAMETERS);
            String result = (String)publicMethod.invoke(annotationInstance, new Object[0]);
            return result;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
    }
}

