/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.reporting.packages;

import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.coverage.data.FileCoverageData;
import mockit.coverage.reporting.packages.ListWithFilesAndPercentages;

final class PackageCoverageReport
extends ListWithFilesAndPercentages {
    @Nonnull
    private final Map<String, FileCoverageData> filesToFileData;
    @Nullable
    private final Collection<String> sourceFilesNotFound;
    @Nonnull
    private final char[] fileNameWithSpaces;

    PackageCoverageReport(@Nonnull PrintWriter output, @Nullable Collection<String> sourceFilesNotFound, @Nonnull Map<String, FileCoverageData> filesToFileData, @Nonnull Collection<List<String>> allSourceFileNames) {
        super(output, "          ");
        this.sourceFilesNotFound = sourceFilesNotFound;
        this.filesToFileData = filesToFileData;
        this.fileNameWithSpaces = new char[PackageCoverageReport.maximumSourceFileNameLength(allSourceFileNames)];
    }

    @Nonnegative
    private static int maximumSourceFileNameLength(@Nonnull Collection<List<String>> allSourceFileNames) {
        int maxLength = 0;
        for (List<String> files : allSourceFileNames) {
            for (String fileName : files) {
                int n = fileName.length();
                if (n <= maxLength) continue;
                maxLength = n;
            }
        }
        return maxLength;
    }

    @Override
    protected void writeMetricsForFile(@Nullable String packageName, @Nonnull String fileName) {
        String filePath = packageName == null || packageName.isEmpty() ? fileName : packageName + '/' + fileName;
        FileCoverageData fileData = this.filesToFileData.get(filePath);
        this.writeRowStart();
        this.printIndent();
        this.output.write("  <td class='file ");
        this.output.write(fileData.kindOfTopLevelType != null ? fileData.kindOfTopLevelType : "class");
        this.output.write("'>");
        int fileNameLength = this.buildFileNameWithTrailingSpaces(fileName);
        this.writeTableCellWithFileName(filePath, fileNameLength);
        this.writeCodeCoverageMetricForFile(fileData);
        this.writeRowClose();
    }

    @Nonnegative
    private int buildFileNameWithTrailingSpaces(@Nonnull String fileName) {
        int n = fileName.length();
        fileName.getChars(0, n, this.fileNameWithSpaces, 0);
        Arrays.fill(this.fileNameWithSpaces, n, this.fileNameWithSpaces.length, ' ');
        return n;
    }

    private void writeTableCellWithFileName(@Nonnull String filePath, @Nonnegative int fileNameLen) {
        if (this.sourceFilesNotFound == null || this.sourceFilesNotFound.contains(filePath)) {
            this.output.write(this.fileNameWithSpaces);
        } else {
            this.output.write("<a target='_blank' href='");
            int p = filePath.lastIndexOf(46);
            this.output.write(filePath.substring(0, p));
            this.output.write(".html'>");
            this.output.write(this.fileNameWithSpaces, 0, fileNameLen);
            this.output.write("</a>");
            this.output.write(this.fileNameWithSpaces, fileNameLen, this.fileNameWithSpaces.length - fileNameLen);
        }
        this.output.println("</td>");
    }

    private void writeCodeCoverageMetricForFile(@Nonnull FileCoverageData coverageInfo) {
        int percentage = coverageInfo.getCoveragePercentage();
        int covered = coverageInfo.getCoveredItems();
        int total = coverageInfo.getTotalItems();
        this.coveredItems += covered;
        this.totalItems += total;
        this.printCoveragePercentage(covered, total, percentage);
    }

    @Override
    protected void writeClassAttributeForCoveragePercentageCell() {
    }
}

