/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.esri;

import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.logical.FormatPluginConfig;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.physical.impl.scan.file.FileScanFramework;
import org.apache.drill.exec.physical.impl.scan.framework.ManagedReader;
import org.apache.drill.exec.physical.impl.scan.framework.ManagedScanFramework;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.server.options.OptionManager;
import org.apache.drill.exec.store.dfs.easy.EasyFormatPlugin;
import org.apache.drill.exec.store.dfs.easy.EasySubScan;
import org.apache.drill.exec.store.esri.ShpBatchReader;
import org.apache.drill.exec.store.esri.ShpFormatConfig;
import org.apache.hadoop.conf.Configuration;

public class ShpFormatPlugin
extends EasyFormatPlugin<ShpFormatConfig> {
    public static final String PLUGIN_NAME = "shp";

    public ShpFormatPlugin(String name, DrillbitContext context, Configuration fsConf, StoragePluginConfig storageConfig, ShpFormatConfig formatConfig) {
        super(name, ShpFormatPlugin.easyConfig(fsConf, formatConfig), context, storageConfig, (FormatPluginConfig)formatConfig);
    }

    public ManagedReader<? extends FileScanFramework.FileSchemaNegotiator> newBatchReader(EasySubScan scan, OptionManager options) throws ExecutionSetupException {
        return new ShpBatchReader(scan.getMaxRecords());
    }

    protected FileScanFramework.FileScanBuilder frameworkBuilder(OptionManager options, EasySubScan scan) {
        FileScanFramework.FileScanBuilder builder = new FileScanFramework.FileScanBuilder();
        builder.setReaderFactory((ManagedScanFramework.ReaderFactory)new ShpReaderFactory(scan.getMaxRecords()));
        this.initScanBuilder(builder, scan);
        builder.nullType(Types.optional((TypeProtos.MinorType)TypeProtos.MinorType.VARCHAR));
        return builder;
    }

    private static EasyFormatPlugin.EasyFormatConfig easyConfig(Configuration fsConf, ShpFormatConfig pluginConfig) {
        return EasyFormatPlugin.EasyFormatConfig.builder().readable(true).writable(false).blockSplittable(false).compressible(false).supportsProjectPushdown(true).extensions(pluginConfig.getExtensions()).fsConf(fsConf).defaultName(PLUGIN_NAME).useEnhancedScan(true).supportsLimitPushdown(true).build();
    }

    public static class ShpReaderFactory
    extends FileScanFramework.FileReaderFactory {
        private final int maxRecords;

        public ShpReaderFactory(int maxRecords) {
            this.maxRecords = maxRecords;
        }

        public ManagedReader<? extends FileScanFramework.FileSchemaNegotiator> newReader() {
            return new ShpBatchReader(this.maxRecords);
        }
    }
}

