/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent;

import com.esotericsoftware.kryo.DefaultSerializer;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import nl.basjes.parse.useragent.AbstractUserAgentAnalyzerDirect;
import nl.basjes.parse.useragent.UserAgent;
import org.apache.commons.collections4.map.LRUMap;

@DefaultSerializer(value=KryoSerializer.class)
public class AbstractUserAgentAnalyzer
extends AbstractUserAgentAnalyzerDirect
implements Serializable {
    public static final int DEFAULT_PARSE_CACHE_SIZE = 10000;
    protected int cacheSize = 10000;
    private transient Map<String, UserAgent.ImmutableUserAgent> parseCache;
    private CacheInstantiator cacheInstantiator = new DefaultCacheInstantiator();
    private transient UserAgent.ImmutableUserAgent nullAgent = null;
    protected boolean wasBuilt = false;

    protected AbstractUserAgentAnalyzer() {
    }

    @Override
    public synchronized void destroy() {
        super.destroy();
        if (this.parseCache != null) {
            this.parseCache.clear();
            this.parseCache = null;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.initializeCache();
    }

    public static void configureKryo(Object kryoInstance) {
        Kryo kryo = (Kryo)kryoInstance;
        kryo.register(AbstractUserAgentAnalyzer.class);
        kryo.register(DefaultCacheInstantiator.class);
        AbstractUserAgentAnalyzerDirect.configureKryo(kryo);
    }

    public void disableCaching() {
        this.setCacheSize(0);
        this.setClientHintsCacheSize(0);
    }

    public void setCacheSize(int newCacheSize) {
        this.cacheSize = Math.max(newCacheSize, 0);
        if (this.wasBuilt) {
            this.initializeCache();
        }
    }

    public void clearCache() {
        if (this.parseCache != null) {
            this.parseCache.clear();
        }
        this.clientHintsAnalyzer.clearCache();
    }

    public void setCacheInstantiator(CacheInstantiator newCacheInstantiator) {
        this.cacheInstantiator = newCacheInstantiator;
        if (this.wasBuilt) {
            this.initializeCache();
        }
    }

    synchronized void initializeCache() {
        this.parseCache = this.cacheSize >= 1 ? this.cacheInstantiator.instantiateCache(this.cacheSize) : null;
        this.clientHintsAnalyzer.initializeCache();
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setClientHintsCacheSize(int newCacheSize) {
        this.clientHintsAnalyzer.setCacheSize(newCacheSize);
    }

    public int getClientHintsCacheSize() {
        return this.clientHintsAnalyzer.getCacheSize();
    }

    public void setClientHintsCacheInstantiator(ClientHintsCacheInstantiator<?> clientHintsCacheInstantiator) {
        this.clientHintsAnalyzer.setCacheInstantiator(clientHintsCacheInstantiator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public UserAgent.ImmutableUserAgent parse(UserAgent.MutableUserAgent userAgent) {
        if (userAgent == null || userAgent.getUserAgentString() == null) {
            AbstractUserAgentAnalyzer abstractUserAgentAnalyzer = this;
            synchronized (abstractUserAgentAnalyzer) {
                if (this.nullAgent == null) {
                    this.nullAgent = super.parse(new UserAgent.MutableUserAgent((String)null));
                }
                return this.nullAgent;
            }
        }
        if (this.parseCache == null) {
            return super.parse(userAgent);
        }
        String cachingKey = userAgent.getUserAgentString();
        if (userAgent.getHeaders().size() > 1) {
            TreeMap<String, String> cleanedHeaders = new TreeMap<String, String>();
            cleanedHeaders.put("User-Agent", userAgent.getUserAgentString());
            for (Map.Entry<String, String> entry : userAgent.getHeaders().entrySet()) {
                String headerName = entry.getKey();
                if (!this.isSupportedClientHintHeader(headerName)) continue;
                cleanedHeaders.put(headerName.toLowerCase(Locale.ROOT), entry.getValue());
            }
            userAgent.setHeaders(cleanedHeaders);
            cachingKey = userAgent.getHeaders().toString();
        }
        return this.parseCache.computeIfAbsent(cachingKey, ua -> super.parse(userAgent));
    }

    @Override
    public String toString() {
        return "UserAgentAnalyzer {\ncacheSize=" + this.cacheSize + ",\n" + super.toString() + "\n} ";
    }

    private static class DefaultCacheInstantiator
    implements CacheInstantiator {
        private DefaultCacheInstantiator() {
        }

        @Override
        public Map<String, UserAgent.ImmutableUserAgent> instantiateCache(int cacheSize) {
            return Caffeine.newBuilder().maximumSize((long)cacheSize).build().asMap();
        }
    }

    public static interface CacheInstantiator
    extends Serializable {
        public Map<String, UserAgent.ImmutableUserAgent> instantiateCache(int var1);
    }

    public static interface ClientHintsCacheInstantiator<T extends Serializable>
    extends Serializable {
        public Map<String, T> instantiateCache(int var1);
    }

    public static abstract class AbstractUserAgentAnalyzerBuilder<UAA extends AbstractUserAgentAnalyzer, B extends AbstractUserAgentAnalyzerBuilder<UAA, B>>
    extends AbstractUserAgentAnalyzerDirect.AbstractUserAgentAnalyzerDirectBuilder<UAA, B> {
        private final UAA uaa;

        protected AbstractUserAgentAnalyzerBuilder(UAA newUaa) {
            super(newUaa);
            this.uaa = newUaa;
        }

        public B withCache(int newCacheSize) {
            this.failIfAlreadyBuilt();
            ((AbstractUserAgentAnalyzer)this.uaa).setCacheSize(newCacheSize);
            return (B)this;
        }

        public B withoutCache() {
            this.failIfAlreadyBuilt();
            ((AbstractUserAgentAnalyzer)this.uaa).setCacheSize(0);
            return (B)this;
        }

        public B withCacheInstantiator(CacheInstantiator cacheInstantiator) {
            this.failIfAlreadyBuilt();
            ((AbstractUserAgentAnalyzer)this.uaa).setCacheInstantiator(cacheInstantiator);
            return (B)this;
        }

        public B withClientHintsCache(int newCacheSize) {
            this.failIfAlreadyBuilt();
            ((AbstractUserAgentAnalyzer)this.uaa).setClientHintsCacheSize(newCacheSize);
            return (B)this;
        }

        public B withoutClientHintsCache() {
            this.failIfAlreadyBuilt();
            ((AbstractUserAgentAnalyzer)this.uaa).setClientHintsCacheSize(0);
            return (B)this;
        }

        public B withClientHintCacheInstantiator(ClientHintsCacheInstantiator<?> cacheInstantiator) {
            this.failIfAlreadyBuilt();
            ((AbstractUserAgentAnalyzer)this.uaa).setClientHintsCacheInstantiator(cacheInstantiator);
            return (B)this;
        }

        public B useJava8CompatibleCaching() {
            this.failIfAlreadyBuilt();
            return ((AbstractUserAgentAnalyzerBuilder)this.withCacheInstantiator(size -> Collections.synchronizedMap(new LRUMap(size)))).withClientHintCacheInstantiator(size -> Collections.synchronizedMap(new LRUMap(size)));
        }

        @Override
        public UAA build() {
            ((AbstractUserAgentAnalyzer)this.uaa).wasBuilt = true;
            ((AbstractUserAgentAnalyzer)this.uaa).initializeCache();
            return (UAA)((AbstractUserAgentAnalyzer)super.build());
        }
    }

    public static class KryoSerializer
    extends AbstractUserAgentAnalyzerDirect.KryoSerializer {
        public KryoSerializer(Kryo kryo, Class<?> type) {
            super(kryo, type);
        }

        @Override
        public void write(Kryo kryo, Output output, AbstractUserAgentAnalyzerDirect object) {
            super.write(kryo, output, object);
            output.writeInt(((AbstractUserAgentAnalyzer)object).cacheSize);
        }

        @Override
        public AbstractUserAgentAnalyzer read(Kryo kryo, Input input, Class<? extends AbstractUserAgentAnalyzerDirect> type) {
            AbstractUserAgentAnalyzer uaa = (AbstractUserAgentAnalyzer)super.read(kryo, input, (Class)type);
            uaa.cacheSize = input.readInt();
            uaa.initializeCache();
            return uaa;
        }
    }
}

