/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc.impl;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DrillStatementRegistry {
    private static final Logger logger = LoggerFactory.getLogger(DrillStatementRegistry.class);
    private final Map<Statement, Object> openStatements = new IdentityHashMap<Statement, Object>();

    DrillStatementRegistry() {
    }

    void addStatement(Statement statement) {
        logger.debug("Adding to open-statements registry: " + statement);
        this.openStatements.put(statement, statement);
    }

    void removeStatement(Statement statement) {
        logger.debug("Removing from open-statements registry: " + statement);
        this.openStatements.remove(statement);
    }

    void close() {
        ArrayList<Statement> copiedList = new ArrayList<Statement>(this.openStatements.keySet());
        for (Statement statement : copiedList) {
            try {
                logger.debug("Auto-closing (via open-statements registry): " + statement);
                statement.close();
            }
            catch (SQLException e) {
                logger.error("Error auto-closing statement " + statement + ": " + e, (Throwable)e);
            }
        }
        this.openStatements.clear();
    }
}

