/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mapr.db.TabletInfo;
import com.mapr.db.exceptions.DBException;
import com.mapr.db.exceptions.ExceptionHandler;
import com.mapr.db.impl.BaseMetaTable;
import com.mapr.db.impl.ConditionImpl;
import com.mapr.db.impl.ConditionNode;
import com.mapr.db.impl.MapRDBHashedIndexImpl;
import com.mapr.db.impl.MapRDBIndexImpl;
import com.mapr.db.scan.ScanRange;
import com.mapr.db.util.ByteBufs;
import com.mapr.fs.MapRTabletScanner;
import com.mapr.fs.proto.Dbserver;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.ojai.store.QueryCondition;

public class HashedIndexMetaTableImpl
extends BaseMetaTable {
    private MapRDBHashedIndexImpl hashedIndexTable = null;

    public HashedIndexMetaTableImpl(MapRDBHashedIndexImpl hashedIndexTable) {
        super(hashedIndexTable);
        this.hashedIndexTable = hashedIndexTable;
    }

    @Override
    public List<ScanRange> getScanRanges(QueryCondition condition) throws DBException {
        TabletInfo[] hashedTabletKeyRanges;
        Preconditions.checkNotNull((Object)condition);
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        ImmutableList.Builder scanRanges = ImmutableList.builder();
        if (condition == TOKEN_CONDITION) {
            TabletInfo[] tabletInfos;
            for (TabletInfo ti : tabletInfos = this.hashedIndexTable.getTabletInfos(false, true)) {
                scanRanges.add((Object)ti);
            }
            return scanRanges.build();
        }
        ConditionImpl hashedQC = this.hashedIndexTable._cloneCondition(condition);
        List<ConditionNode.RowkeyRange> ranges = hashedQC.getRowkeyRanges();
        TreeMap<ByteBuffer, ByteBuffer> sortedHashedRanges = new TreeMap<ByteBuffer, ByteBuffer>();
        for (ConditionNode.RowkeyRange range : ranges) {
            sortedHashedRanges.put(ByteBufs.wrap(range.getStartRow()), ByteBufs.wrap(range.getStopRow()));
        }
        for (TabletInfo ti : hashedTabletKeyRanges = this.generateHashedIndexScanRanges(sortedHashedRanges)) {
            scanRanges.add((Object)ti);
        }
        return scanRanges.build();
    }

    private TabletInfo[] generateHashedIndexScanRanges(TreeMap<ByteBuffer, ByteBuffer> sortedKeyRanges) {
        ArrayList hashedScanRange = Lists.newArrayList();
        try {
            MapRTabletScanner scanner = this.hashedIndexTable.maprTable().getTabletScanner(false, true);
            List nextTabletSet = scanner.nextSet();
            Iterator tabItr = nextTabletSet.iterator();
            boolean nextTab = true;
            Dbserver.TabletDesc tab = null;
            block2: for (Map.Entry<ByteBuffer, ByteBuffer> entry : sortedKeyRanges.entrySet()) {
                ByteBuffer start = entry.getKey();
                ByteBuffer stop = entry.getValue();
                while (tabItr.hasNext() || !nextTab) {
                    if (nextTab) {
                        tab = (Dbserver.TabletDesc)tabItr.next();
                        nextTab = false;
                    }
                    byte[] startArr = start.array();
                    byte[] stopArr = stop.array();
                    byte[] tabStartArr = tab.getStartKey().toByteArray();
                    byte[] tabStopArr = tab.getEndKey().toByteArray();
                    ByteBuffer tabStart = ByteBufs.wrap(tabStartArr);
                    ByteBuffer tabStop = ByteBufs.wrap(tabStopArr);
                    boolean leftInRange = false;
                    boolean rightInRange = false;
                    if (MapRDBIndexImpl.CompareKeys(startArr, tabStopArr) >= 0 && tabStop.hasRemaining()) {
                        assert (MapRDBIndexImpl.CompareKeys(startArr, tabStartArr) > 0 || !tabStart.hasRemaining());
                        nextTab = true;
                        continue;
                    }
                    leftInRange = true;
                    if (MapRDBIndexImpl.CompareKeys(stopArr, tabStopArr) < 0 || !tabStop.hasRemaining()) {
                        rightInRange = true;
                    }
                    if (leftInRange && rightInRange) {
                        assert (MapRDBIndexImpl.CompareKeys(startArr, tabStartArr) >= 0);
                        hashedScanRange.add(this.hashedIndexTable.toTabletInfo(tab, new ConditionNode.RowkeyRange(startArr, stopArr)));
                        continue block2;
                    }
                    if (leftInRange) {
                        assert (MapRDBIndexImpl.CompareKeys(startArr, tabStartArr) >= 0);
                        hashedScanRange.add(this.hashedIndexTable.toTabletInfo(tab, new ConditionNode.RowkeyRange(startArr, tabStopArr)));
                        start = tabStop;
                    }
                    assert (leftInRange || leftInRange == rightInRange);
                    assert (MapRDBIndexImpl.CompareKeys(stopArr, tabStartArr) > 0 && MapRDBIndexImpl.CompareKeys(stopArr, tabStopArr) >= 0);
                    nextTab = true;
                    if (tabItr.hasNext() || (nextTabletSet = scanner.nextSet()) == null) continue;
                    tabItr = nextTabletSet.iterator();
                }
            }
        }
        catch (IOException e) {
            throw ExceptionHandler.handle(e, "generateHashedIndexScanRanges()");
        }
        return hashedScanRange.toArray(new TabletInfo[hashedScanRange.size()]);
    }
}

