/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.kudu;

import com.google.common.base.Preconditions;
import java.util.LinkedList;
import java.util.List;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.exec.ops.ExecutorFragmentContext;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.impl.BatchCreator;
import org.apache.drill.exec.physical.impl.ScanBatch;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.store.kudu.KuduRecordReader;
import org.apache.drill.exec.store.kudu.KuduSubScan;

public class KuduScanBatchCreator
implements BatchCreator<KuduSubScan> {
    public ScanBatch getBatch(ExecutorFragmentContext context, KuduSubScan subScan, List<RecordBatch> children) throws ExecutionSetupException {
        Preconditions.checkArgument((boolean)children.isEmpty());
        LinkedList<KuduRecordReader> readers = new LinkedList<KuduRecordReader>();
        List columns = null;
        for (KuduSubScan.KuduSubScanSpec scanSpec : subScan.getTabletScanSpecList()) {
            try {
                columns = subScan.getColumns();
                if (columns == null) {
                    columns = GroupScan.ALL_COLUMNS;
                }
                readers.add(new KuduRecordReader(subScan.getStorageEngine().getClient(), scanSpec, columns));
            }
            catch (Exception e1) {
                throw new ExecutionSetupException((Throwable)e1);
            }
        }
        return new ScanBatch((PhysicalOperator)subScan, (FragmentContext)context, readers);
    }
}

