/*
 * Decompiled with CFR 0.152.
 */
package sqlline;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import sqlline.BuiltInDialect;
import sqlline.Dialect;

class DialectImpl
implements Dialect {
    private static final DialectImpl DEFAULT = DialectImpl.create(null, null, null);
    private final Set<String> keywords;
    private final Set<String> oneLineComments;
    private final char openQuote;
    private final char closeQuote;
    private final boolean storesUpperCaseIdentifier;
    private final boolean storesLowerCaseIdentifier;
    private final String extraNameCharacters;
    private final Dialect.CodeBlocks codeBlocks;

    static DialectImpl create(Set<String> keywords, String identifierQuote, String productName) {
        return DialectImpl.create(keywords, identifierQuote, productName, false, true, "");
    }

    static DialectImpl create(Set<String> keywords, String identifierQuote, String productName, boolean storesLowerCaseIdentifier, boolean storesUpperCaseIdentifier, String extraNameCharacters) {
        char closeQuote;
        char openQuote;
        Set<String> keywords2 = keywords == null ? Collections.emptySet() : Collections.unmodifiableSet(keywords);
        BuiltInDialect dialect = BuiltInDialect.valueOf(productName, true);
        if (identifierQuote == null) {
            openQuote = dialect.getOpenQuote();
            closeQuote = dialect.getCloseQuote();
        } else {
            openQuote = identifierQuote.charAt(0);
            switch (openQuote) {
                case '[': {
                    closeQuote = ']';
                    break;
                }
                default: {
                    closeQuote = openQuote;
                }
            }
        }
        return new DialectImpl(keywords2, storesLowerCaseIdentifier, storesUpperCaseIdentifier, dialect.getOneLineComments(), openQuote, closeQuote, extraNameCharacters, dialect.getCodeBlocks());
    }

    private DialectImpl(Set<String> keywords, boolean storesLowerCaseIdentifier, boolean storesUpperCaseIdentifier, Set<String> oneLineComments, char openQuote, char closeQuote, String extraNameCharacters, Dialect.CodeBlocks codeBlocks) {
        this.keywords = Objects.requireNonNull(keywords);
        this.storesLowerCaseIdentifier = storesLowerCaseIdentifier;
        this.storesUpperCaseIdentifier = storesUpperCaseIdentifier;
        this.oneLineComments = oneLineComments;
        this.openQuote = openQuote;
        this.closeQuote = closeQuote;
        this.extraNameCharacters = extraNameCharacters;
        this.codeBlocks = codeBlocks;
    }

    public static Dialect getDefault() {
        return DEFAULT;
    }

    @Override
    public boolean containsKeyword(String keyword) {
        return this.keywords.contains(keyword) || DEFAULT_KEYWORD_SET.contains(keyword);
    }

    @Override
    public Set<String> getOneLineComments() {
        return this.oneLineComments;
    }

    @Override
    public char getOpenQuote() {
        return this.openQuote;
    }

    @Override
    public char getCloseQuote() {
        return this.closeQuote;
    }

    @Override
    public boolean isLower() {
        return this.storesLowerCaseIdentifier;
    }

    @Override
    public boolean isUpper() {
        return this.storesUpperCaseIdentifier;
    }

    @Override
    public String getExtraNameCharacters() {
        return this.extraNameCharacters;
    }

    @Override
    public Dialect.CodeBlocks getCodeBlocks() {
        return this.codeBlocks;
    }
}

