/*
 * Decompiled with CFR 0.152.
 */
package sqlline;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.sql.DatabaseMetaData;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import org.jline.builtins.Completers;
import org.jline.reader.Completer;
import org.jline.reader.impl.completer.StringsCompleter;
import sqlline.AnsiConsoleOutputFormat;
import sqlline.BuiltInHighlightStyle;
import sqlline.BuiltInProperty;
import sqlline.BuiltInTableOutputFormatStyles;
import sqlline.CommandHandler;
import sqlline.ConnectionCompleter;
import sqlline.HighlightStyle;
import sqlline.JsonOutputFormat;
import sqlline.OutputFormat;
import sqlline.PromptHandler;
import sqlline.ReflectiveCommandHandler;
import sqlline.SeparatedValuesOutputFormat;
import sqlline.SqlLine;
import sqlline.SqlLineOpts;
import sqlline.TableNameCompleter;
import sqlline.TableOutputFormat;
import sqlline.TableOutputFormatStyle;
import sqlline.VerticalOutputFormat;
import sqlline.XmlAttributeOutputFormat;
import sqlline.XmlElementOutputFormat;

public class Application {
    public static final String DEFAULT_APP_INFO_MESSAGE = "sqlline version ???";
    private static final String[] CONNECTION_URLS = new String[]{"jdbc:JSQLConnect://<hostname>/database=<database>", "jdbc:cloudscape:<database>;create=true", "jdbc:twtds:sqlserver://<hostname>/<database>", "jdbc:daffodilDB_embedded:<database>;create=true", "jdbc:datadirect:db2://<hostname>:50000;databaseName=<database>", "jdbc:inetdae:<hostname>:1433", "jdbc:datadirect:oracle://<hostname>:1521;SID=<database>;MaxPooledStatements=0", "jdbc:datadirect:sqlserver://<hostname>:1433;SelectMethod=cursor;DatabaseName=<database>", "jdbc:datadirect:sybase://<hostname>:5000", "jdbc:db2://<hostname>/<database>", "jdbc:hsqldb:<database>", "jdbc:hive2://<hostname>:<port>/<database>", "jdbc:hive2://<hostname>:<port>/<database>;transportMode=http;httpPath=<http_endpoint>", "jdbc:hive2://<hostname>:<port>/<database>;ssl=true;sslTrustStore=<trust_store_path>;trustStorePassword=<trust_store_password>", "jdbc:idb:<database>.properties", "jdbc:informix-sqli://<hostname>:1526/<database>:INFORMIXSERVER=<database>", "jdbc:interbase://<hostname>//<database>.gdb", "jdbc:luciddb:http://<hostname>", "jdbc:microsoft:sqlserver://<hostname>:1433;DatabaseName=<database>;SelectMethod=cursor", "jdbc:mysql://<hostname>/<database>?autoReconnect=true", "jdbc:oracle:thin:@<hostname>:1521:<database>", "jdbc:pointbase:<database>,database.home=<database>,create=true", "jdbc:postgresql://<hostname>:5432/<database>", "jdbc:postgresql:net//<hostname>/<database>", "jdbc:sybase:Tds:<hostname>:4100/<database>?ServiceName=<database>", "jdbc:weblogic:mssqlserver4:<database>@<hostname>:1433", "jdbc:odbc:<database>", "jdbc:sequelink://<hostname>:4003/[Oracle]", "jdbc:sequelink://<hostname>:4004/[Informix];Database=<database>", "jdbc:sequelink://<hostname>:4005/[Sybase];Database=<database>", "jdbc:sequelink://<hostname>:4006/[SQLServer];Database=<database>", "jdbc:sequelink://<hostname>:4011/[ODBC MS Access];Database=<database>", "jdbc:openlink://<hostname>/DSN=SQLServerDB/UID=sa/PWD=", "jdbc:solid://<hostname>:<port>/<UID>/<PWD>", "jdbc:dbaw://<hostname>:8889/<database>"};
    private static final List<String> DEFAULT_CONNECTION_URL_EXAMPLES = Collections.unmodifiableList(Arrays.asList(CONNECTION_URLS));
    private static final String[] ISOLATION_LEVELS = new String[]{"TRANSACTION_NONE", "TRANSACTION_READ_COMMITTED", "TRANSACTION_READ_UNCOMMITTED", "TRANSACTION_REPEATABLE_READ", "TRANSACTION_SERIALIZABLE"};
    private static final List<String> ISOLATION_LEVEL_LIST = Collections.unmodifiableList(Arrays.asList(ISOLATION_LEVELS));
    private static final String[] CONNECT_MODES = new String[]{"askCredentials", "notAskCredentials", "useNPTogetherOrEmpty"};
    private static final List<String> CONNECT_INTERACTIVE_MODES = Collections.unmodifiableList(Arrays.asList(CONNECT_MODES));

    public String getInfoMessage() {
        return this.getVersion();
    }

    public String getVersion() {
        String path = "/META-INF/maven/sqlline/sqlline/pom.properties";
        InputStream inputStream = this.getClass().getResourceAsStream("/META-INF/maven/sqlline/sqlline/pom.properties");
        Properties properties = new Properties();
        properties.put("artifactId", "sqlline");
        properties.put("version", "???");
        if (inputStream != null) {
            try {
                properties.load(inputStream);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return String.format(Locale.ROOT, "%s version %s", properties.getProperty("artifactId"), properties.getProperty("version"));
    }

    @Deprecated
    public Collection<String> initDrivers() {
        return this.allowedDrivers();
    }

    public List<String> allowedDrivers() {
        return null;
    }

    public Map<String, OutputFormat> getOutputFormats(SqlLine sqlLine) {
        HashMap<String, OutputFormat> outputFormats = new HashMap<String, OutputFormat>();
        outputFormats.put("vertical", new VerticalOutputFormat(sqlLine));
        outputFormats.put("table", new TableOutputFormat(sqlLine));
        outputFormats.put("ansiconsole", new AnsiConsoleOutputFormat(sqlLine));
        outputFormats.put("csv", new SeparatedValuesOutputFormat(sqlLine, ","));
        outputFormats.put("tsv", new SeparatedValuesOutputFormat(sqlLine, "\t"));
        XmlAttributeOutputFormat xmlAttrs = new XmlAttributeOutputFormat(sqlLine);
        outputFormats.put("xmlattr", xmlAttrs);
        outputFormats.put("xmlattrs", xmlAttrs);
        outputFormats.put("xmlelements", new XmlElementOutputFormat(sqlLine));
        outputFormats.put("json", new JsonOutputFormat(sqlLine));
        return Collections.unmodifiableMap(outputFormats);
    }

    public Collection<String> getConnectionUrlExamples() {
        return DEFAULT_CONNECTION_URL_EXAMPLES;
    }

    public Collection<CommandHandler> getCommandHandlers(SqlLine sqlLine) {
        TableNameCompleter tableCompleter = new TableNameCompleter(sqlLine);
        List<Completer> empty = Collections.emptyList();
        Map<String, OutputFormat> outputFormats = this.getOutputFormats(sqlLine);
        HashMap<BuiltInProperty, Collection<String>> customPropertyCompletions = new HashMap<BuiltInProperty, Collection<String>>();
        customPropertyCompletions.put(BuiltInProperty.OUTPUT_FORMAT, outputFormats.keySet());
        CommandHandler[] handlers = new CommandHandler[]{new ReflectiveCommandHandler(sqlLine, empty, "quit", "done", "exit"), new ReflectiveCommandHandler(sqlLine, (Completer)new StringsCompleter(this.getConnectionUrlExamples()), "connect", "open"), new ReflectiveCommandHandler(sqlLine, empty, "showconfconnections"), new ReflectiveCommandHandler(sqlLine, (Completer)new Completers.FileNameCompleter(), "rereadconfconnections"), new ReflectiveCommandHandler(sqlLine, empty, "nickname"), new ReflectiveCommandHandler(sqlLine, tableCompleter, "describe"), new ReflectiveCommandHandler(sqlLine, tableCompleter, "indexes"), new ReflectiveCommandHandler(sqlLine, tableCompleter, "primarykeys"), new ReflectiveCommandHandler(sqlLine, tableCompleter, "exportedkeys"), new ReflectiveCommandHandler(sqlLine, empty, "manual"), new ReflectiveCommandHandler(sqlLine, tableCompleter, "importedkeys"), new ReflectiveCommandHandler(sqlLine, empty, "procedures"), new ReflectiveCommandHandler(sqlLine, empty, "schemas"), new ReflectiveCommandHandler(sqlLine, empty, "tables"), new ReflectiveCommandHandler(sqlLine, empty, "typeinfo"), new ReflectiveCommandHandler(sqlLine, empty, "commandhandler"), new ReflectiveCommandHandler(sqlLine, tableCompleter, "columns"), new ReflectiveCommandHandler(sqlLine, empty, "reconnect"), new ReflectiveCommandHandler(sqlLine, tableCompleter, "dropall"), new ReflectiveCommandHandler(sqlLine, empty, "history"), new ReflectiveCommandHandler(sqlLine, (Completer)new StringsCompleter(this.getMetadataMethodNames()), "metadata"), new ReflectiveCommandHandler(sqlLine, empty, "nativesql"), new ReflectiveCommandHandler(sqlLine, empty, "dbinfo"), new ReflectiveCommandHandler(sqlLine, empty, "rehash"), new ReflectiveCommandHandler(sqlLine, empty, "resize"), new ReflectiveCommandHandler(sqlLine, empty, "verbose"), new ReflectiveCommandHandler(sqlLine, (Completer)new Completers.FileNameCompleter(), "run"), new ReflectiveCommandHandler(sqlLine, empty, "batch"), new ReflectiveCommandHandler(sqlLine, empty, "list"), new ReflectiveCommandHandler(sqlLine, empty, "all"), new ReflectiveCommandHandler(sqlLine, new ConnectionCompleter(sqlLine), "go", "#"), new ReflectiveCommandHandler(sqlLine, (Completer)new Completers.FileNameCompleter(), new String[]{"script"}){

            @Override
            public boolean echoToFile() {
                return false;
            }
        }, new ReflectiveCommandHandler(sqlLine, (Completer)new Completers.FileNameCompleter(), "record"), new ReflectiveCommandHandler(sqlLine, empty, "brief"), new ReflectiveCommandHandler(sqlLine, empty, "close"), new ReflectiveCommandHandler(sqlLine, empty, "closeall"), new ReflectiveCommandHandler(sqlLine, (Completer)new StringsCompleter(this.getIsolationLevels()), "isolation"), new ReflectiveCommandHandler(sqlLine, (Completer)new StringsCompleter(outputFormats.keySet()), "outputformat"), new ReflectiveCommandHandler(sqlLine, empty, "autocommit"), new ReflectiveCommandHandler(sqlLine, empty, "readonly"), new ReflectiveCommandHandler(sqlLine, empty, "commit"), new ReflectiveCommandHandler(sqlLine, (Completer)new Completers.FileNameCompleter(), "properties"), new ReflectiveCommandHandler(sqlLine, empty, "rollback"), new ReflectiveCommandHandler(sqlLine, () -> this.getOpts(sqlLine).helpCompleters(), "help", "?"), new ReflectiveCommandHandler(sqlLine, this.getOpts(sqlLine).setOptionCompleters(customPropertyCompletions), "set"), new ReflectiveCommandHandler(sqlLine, this.getOpts(sqlLine).resetOptionCompleters(), "reset"), new ReflectiveCommandHandler(sqlLine, empty, "save"), new ReflectiveCommandHandler(sqlLine, empty, "scan"), new ReflectiveCommandHandler(sqlLine, empty, "sql"), new ReflectiveCommandHandler(sqlLine, empty, "call"), new ReflectiveCommandHandler(sqlLine, empty, "appconfig"), new ReflectiveCommandHandler(sqlLine, empty, "rerun", "/"), new ReflectiveCommandHandler(sqlLine, empty, "prompthandler")};
        return Collections.unmodifiableList(Arrays.asList(handlers));
    }

    public SqlLineOpts getOpts(SqlLine sqlLine) {
        return new SqlLineOpts(sqlLine);
    }

    public PromptHandler getPromptHandler(SqlLine sqlLine) {
        return new PromptHandler(sqlLine);
    }

    private Set<String> getMetadataMethodNames() {
        try {
            TreeSet<String> methodNames = new TreeSet<String>();
            for (Method method : DatabaseMetaData.class.getDeclaredMethods()) {
                methodNames.add(method.getName());
            }
            return methodNames;
        }
        catch (Throwable t) {
            return Collections.emptySet();
        }
    }

    List<String> getIsolationLevels() {
        return ISOLATION_LEVEL_LIST;
    }

    public Map<String, HighlightStyle> getName2HighlightStyle() {
        return BuiltInHighlightStyle.BY_NAME;
    }

    public Collection<String> getConnectInteractiveModes() {
        return CONNECT_INTERACTIVE_MODES;
    }

    public String getDefaultInteractiveMode() {
        return "askCredentials";
    }

    public Map<String, TableOutputFormatStyle> getName2TableOutputFormatStyle() {
        return BuiltInTableOutputFormatStyles.BY_NAME;
    }

    public Set<String> getAvailableScriptEngineNames() {
        HashSet<String> result = new HashSet<String>();
        HashMap<String, HashSet<String>> fName2Aliases = new HashMap<String, HashSet<String>>();
        List<ScriptEngineFactory> factories = new ScriptEngineManager().getEngineFactories();
        for (ScriptEngineFactory scriptEngineFactory : factories) {
            fName2Aliases.put(scriptEngineFactory.getEngineName(), new HashSet<String>(scriptEngineFactory.getNames()));
        }
        for (Map.Entry entry : fName2Aliases.entrySet()) {
            TreeSet aliases = new TreeSet((Collection)entry.getValue());
            for (Map.Entry fEntry2 : fName2Aliases.entrySet()) {
                if (((String)entry.getKey()).equals(fEntry2.getKey())) continue;
                aliases.removeAll((Collection)fEntry2.getValue());
            }
            if (aliases.isEmpty()) continue;
            result.add((String)aliases.iterator().next());
        }
        return result;
    }
}

