/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.security.SecureRandom;
import org.bouncycastle.crypto.fips.FipsDRBG;
import org.bouncycastle.crypto.fips.FipsSecureRandom;
import org.bouncycastle.tls.crypto.TlsNonceGenerator;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class JcaNonceGenerator
implements TlsNonceGenerator {
    private final FipsSecureRandom random;

    JcaNonceGenerator(SecureRandom secureRandom, byte[] byArray) {
        byte[] byArray2 = new byte[32];
        secureRandom.nextBytes(byArray2);
        this.random = FipsDRBG.SHA512.fromEntropySource(secureRandom, false).setPersonalizationString(byArray).build(byArray2, false);
    }

    @Override
    public byte[] generateNonce(int n) {
        byte[] byArray = new byte[n];
        this.random.nextBytes(byArray);
        return byArray;
    }
}

