/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.yarn.zk;

import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.collect.Collections2;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.curator.retry.RetryNTimes;
import org.apache.curator.x.discovery.ServiceCache;
import org.apache.curator.x.discovery.ServiceDiscovery;
import org.apache.curator.x.discovery.ServiceDiscoveryBuilder;
import org.apache.curator.x.discovery.ServiceInstance;
import org.apache.curator.x.discovery.details.ServiceCacheListener;
import org.apache.drill.common.AutoCloseables;
import org.apache.drill.exec.coord.ClusterCoordinator;
import org.apache.drill.exec.coord.DistributedSemaphore;
import org.apache.drill.exec.coord.DrillServiceInstanceHelper;
import org.apache.drill.exec.coord.store.CachingTransientStoreFactory;
import org.apache.drill.exec.coord.store.TransientStore;
import org.apache.drill.exec.coord.store.TransientStoreConfig;
import org.apache.drill.exec.coord.store.TransientStoreFactory;
import org.apache.drill.exec.coord.zk.ZKRegistrationHandle;
import org.apache.drill.exec.coord.zk.ZkDistributedSemaphore;
import org.apache.drill.exec.coord.zk.ZkEphemeralStore;
import org.apache.drill.exec.coord.zk.ZkTransientStoreFactory;
import org.apache.drill.exec.proto.CoordinationProtos;

public class ZKClusterCoordinator
extends ClusterCoordinator {
    protected static final Log logger = LogFactory.getLog(ZKClusterCoordinator.class);
    private CuratorFramework curator;
    private ServiceDiscovery<CoordinationProtos.DrillbitEndpoint> discovery;
    private volatile Collection<CoordinationProtos.DrillbitEndpoint> endpoints = Collections.emptyList();
    private final String serviceName;
    private final CountDownLatch initialConnection = new CountDownLatch(1);
    private final TransientStoreFactory factory;
    private ServiceCache<CoordinationProtos.DrillbitEndpoint> serviceCache;

    public ZKClusterCoordinator(String connect, String zkRoot, String clusterId, int retryCount, int retryDelayMs, int connectTimeoutMs) throws IOException {
        logger.debug((Object)("ZK connect: " + connect + ", zkRoot: " + zkRoot + ", clusterId: " + clusterId));
        this.serviceName = clusterId;
        RetryNTimes rp = new RetryNTimes(retryCount, retryDelayMs);
        this.curator = CuratorFrameworkFactory.builder().namespace(zkRoot).connectionTimeoutMs(connectTimeoutMs).retryPolicy((RetryPolicy)rp).connectString(connect).build();
        this.curator.getConnectionStateListenable().addListener((Object)new InitialConnectionListener());
        this.curator.start();
        this.discovery = this.newDiscovery();
        this.factory = CachingTransientStoreFactory.of((TransientStoreFactory)new ZkTransientStoreFactory(this.curator));
    }

    public CuratorFramework getCurator() {
        return this.curator;
    }

    public void start(long millisToWait) throws Exception {
        logger.debug((Object)"Starting ZKClusterCoordination.");
        this.discovery.start();
        if (millisToWait != 0L) {
            boolean success = this.initialConnection.await(millisToWait, TimeUnit.MILLISECONDS);
            if (!success) {
                throw new IOException(String.format("Failure to connect to the zookeeper cluster service within the allotted time of %d milliseconds.", millisToWait));
            }
        } else {
            this.initialConnection.await();
        }
        this.serviceCache = this.discovery.serviceCacheBuilder().name(this.serviceName).build();
        this.serviceCache.addListener((Object)new EndpointListener());
        this.serviceCache.start();
        this.updateEndpoints();
    }

    public void close() throws Exception {
        AutoCloseables.close((AutoCloseable[])new AutoCloseable[]{this.serviceCache, this.discovery, this.factory, this.curator});
    }

    public ClusterCoordinator.RegistrationHandle register(CoordinationProtos.DrillbitEndpoint data) {
        try {
            ServiceInstance<CoordinationProtos.DrillbitEndpoint> serviceInstance = this.newServiceInstance(data);
            this.discovery.registerService(serviceInstance);
            return new ZKRegistrationHandle(serviceInstance.getId(), data);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void unregister(ClusterCoordinator.RegistrationHandle handle) {
        if (!(handle instanceof ZKRegistrationHandle)) {
            throw new UnsupportedOperationException("Unknown handle type: " + handle.getClass().getName());
        }
        this.listeners.clear();
        ZKRegistrationHandle h = (ZKRegistrationHandle)handle;
        try {
            ServiceInstance serviceInstance = ServiceInstance.builder().address("").port(0).id(h.id).name(this.serviceName).build();
            this.discovery.unregisterService(serviceInstance);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public Collection<CoordinationProtos.DrillbitEndpoint> getAvailableEndpoints() {
        return this.endpoints;
    }

    public DistributedSemaphore getSemaphore(String name, int maximumLeases) {
        return new ZkDistributedSemaphore(this.curator, "/semaphore/" + name, maximumLeases);
    }

    public <V> TransientStore<V> getOrCreateTransientStore(TransientStoreConfig<V> config) {
        ZkEphemeralStore store = (ZkEphemeralStore)this.factory.getOrCreateStore(config);
        return store;
    }

    private synchronized void updateEndpoints() {
        try {
            Collection newDrillbitSet = Collections2.transform((Collection)this.discovery.queryForInstances(this.serviceName), (Function)new Function<ServiceInstance<CoordinationProtos.DrillbitEndpoint>, CoordinationProtos.DrillbitEndpoint>(){

                public CoordinationProtos.DrillbitEndpoint apply(ServiceInstance<CoordinationProtos.DrillbitEndpoint> input) {
                    return (CoordinationProtos.DrillbitEndpoint)input.getPayload();
                }
            });
            HashSet<CoordinationProtos.DrillbitEndpoint> unregisteredBits = new HashSet<CoordinationProtos.DrillbitEndpoint>(this.endpoints);
            unregisteredBits.removeAll(newDrillbitSet);
            HashSet registeredBits = new HashSet(newDrillbitSet);
            registeredBits.removeAll(this.endpoints);
            this.endpoints = newDrillbitSet;
            if (logger.isDebugEnabled()) {
                StringBuilder builder = new StringBuilder();
                builder.append("Active drillbit set changed.  Now includes ");
                builder.append(newDrillbitSet.size());
                builder.append(" total bits.");
                if (!newDrillbitSet.isEmpty()) {
                    builder.append(" New active drillbits: \n");
                }
                for (CoordinationProtos.DrillbitEndpoint bit : newDrillbitSet) {
                    builder.append('\t');
                    builder.append(bit.getAddress());
                    builder.append(':');
                    builder.append(bit.getUserPort());
                    builder.append(':');
                    builder.append(bit.getControlPort());
                    builder.append(':');
                    builder.append(bit.getDataPort());
                    builder.append('\n');
                }
                logger.debug((Object)builder.toString());
            }
            if (!unregisteredBits.isEmpty()) {
                this.drillbitUnregistered(unregisteredBits);
            }
            if (!registeredBits.isEmpty()) {
                this.drillbitRegistered(registeredBits);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failure while update Drillbit service location cache.", (Throwable)e);
        }
    }

    protected ServiceInstance<CoordinationProtos.DrillbitEndpoint> newServiceInstance(CoordinationProtos.DrillbitEndpoint endpoint) throws Exception {
        return ServiceInstance.builder().name(this.serviceName).payload((Object)endpoint).build();
    }

    protected ServiceDiscovery<CoordinationProtos.DrillbitEndpoint> newDiscovery() {
        return ServiceDiscoveryBuilder.builder(CoordinationProtos.DrillbitEndpoint.class).basePath("/").client(this.curator).serializer(DrillServiceInstanceHelper.SERIALIZER).build();
    }

    public Collection<CoordinationProtos.DrillbitEndpoint> getOnlineEndPoints() {
        throw new UnsupportedOperationException();
    }

    public ClusterCoordinator.RegistrationHandle update(ClusterCoordinator.RegistrationHandle handle, CoordinationProtos.DrillbitEndpoint.State state) {
        throw new UnsupportedOperationException();
    }

    private class EndpointListener
    implements ServiceCacheListener {
        private EndpointListener() {
        }

        public void stateChanged(CuratorFramework client, ConnectionState newState) {
        }

        public void cacheChanged() {
            logger.debug((Object)"Got cache changed --> updating endpoints");
            ZKClusterCoordinator.this.updateEndpoints();
        }
    }

    private class InitialConnectionListener
    implements ConnectionStateListener {
        private InitialConnectionListener() {
        }

        public void stateChanged(CuratorFramework client, ConnectionState newState) {
            if (newState == ConnectionState.CONNECTED) {
                ZKClusterCoordinator.this.initialConnection.countDown();
                client.getConnectionStateListenable().removeListener((Object)this);
            }
        }
    }
}

