/*
 * Decompiled with CFR 0.152.
 */
package org.ojai.util;

import com.google.common.collect.BiMap;
import com.google.common.collect.EnumBiMap;
import com.google.common.collect.Maps;
import java.util.Map;
import org.ojai.DocumentReader;
import org.ojai.Value;
import org.ojai.annotation.API;

@API.Public
public class Types {
    @Deprecated
    public static final String TAG_BINARY = "$binary";
    @Deprecated
    public static final String TAG_INTERVAL = "$interval";
    @Deprecated
    public static final String TAG_TIMESTAMP = "$date";
    @Deprecated
    public static final String TAG_TIME = "$time";
    @Deprecated
    public static final String TAG_DATE = "$dateDay";
    @Deprecated
    public static final String TAG_DECIMAL = "$decimal";
    @Deprecated
    public static final String TAG_LONG = "$numberLong";
    @Deprecated
    public static final String TAG_BYTE = "$numberByte";
    @Deprecated
    public static final String TAG_SHORT = "$numberShort";
    @Deprecated
    public static final String TAG_INT = "$numberInt";
    @Deprecated
    public static final String TAG_FLOAT = "$numberFloat";
    private static final Map<Value.Type, String> TYPE_TAG_MAP = Maps.newEnumMap(Value.Type.class);
    public static final BiMap<Value.Type, DocumentReader.EventType> TYPE_EVENTTYPE_MAP;

    public static boolean isExtendedType(@API.NonNullable Value value) {
        return Types.isExtendedType(value.getType());
    }

    public static boolean isExtendedType(@API.NonNullable Value.Type type) {
        return TYPE_TAG_MAP.containsKey((Object)type);
    }

    public static String getTypeTag(@API.NonNullable Value value) {
        return Types.getTypeTag(value.getType());
    }

    public static String getTypeTag(@API.NonNullable Value.Type type) {
        return TYPE_TAG_MAP.get((Object)type);
    }

    public static DocumentReader.EventType getEventTypeForType(@API.NonNullable Value.Type type) {
        return (DocumentReader.EventType)((Object)TYPE_EVENTTYPE_MAP.get((Object)type));
    }

    public static Value.Type getTypeForEventType(@API.NonNullable DocumentReader.EventType event) {
        return (Value.Type)((Object)TYPE_EVENTTYPE_MAP.inverse().get((Object)event));
    }

    static {
        TYPE_TAG_MAP.put(Value.Type.BYTE, TAG_BYTE);
        TYPE_TAG_MAP.put(Value.Type.SHORT, TAG_SHORT);
        TYPE_TAG_MAP.put(Value.Type.INT, TAG_INT);
        TYPE_TAG_MAP.put(Value.Type.LONG, TAG_LONG);
        TYPE_TAG_MAP.put(Value.Type.FLOAT, TAG_FLOAT);
        TYPE_TAG_MAP.put(Value.Type.DECIMAL, TAG_DECIMAL);
        TYPE_TAG_MAP.put(Value.Type.DATE, TAG_DATE);
        TYPE_TAG_MAP.put(Value.Type.TIME, TAG_TIME);
        TYPE_TAG_MAP.put(Value.Type.TIMESTAMP, TAG_TIMESTAMP);
        TYPE_TAG_MAP.put(Value.Type.INTERVAL, TAG_INTERVAL);
        TYPE_TAG_MAP.put(Value.Type.BINARY, TAG_BINARY);
        assert (TYPE_TAG_MAP.size() == Value.Type.values().length - 6) : "Map is missing some of the Type enum elements";
        TYPE_EVENTTYPE_MAP = EnumBiMap.create(Value.Type.class, DocumentReader.EventType.class);
        TYPE_EVENTTYPE_MAP.put((Object)Value.Type.NULL, (Object)DocumentReader.EventType.NULL);
        TYPE_EVENTTYPE_MAP.put((Object)Value.Type.BOOLEAN, (Object)DocumentReader.EventType.BOOLEAN);
        TYPE_EVENTTYPE_MAP.put((Object)Value.Type.STRING, (Object)DocumentReader.EventType.STRING);
        TYPE_EVENTTYPE_MAP.put((Object)Value.Type.BYTE, (Object)DocumentReader.EventType.BYTE);
        TYPE_EVENTTYPE_MAP.put((Object)Value.Type.SHORT, (Object)DocumentReader.EventType.SHORT);
        TYPE_EVENTTYPE_MAP.put((Object)Value.Type.INT, (Object)DocumentReader.EventType.INT);
        TYPE_EVENTTYPE_MAP.put((Object)Value.Type.LONG, (Object)DocumentReader.EventType.LONG);
        TYPE_EVENTTYPE_MAP.put((Object)Value.Type.FLOAT, (Object)DocumentReader.EventType.FLOAT);
        TYPE_EVENTTYPE_MAP.put((Object)Value.Type.DOUBLE, (Object)DocumentReader.EventType.DOUBLE);
        TYPE_EVENTTYPE_MAP.put((Object)Value.Type.DECIMAL, (Object)DocumentReader.EventType.DECIMAL);
        TYPE_EVENTTYPE_MAP.put((Object)Value.Type.DATE, (Object)DocumentReader.EventType.DATE);
        TYPE_EVENTTYPE_MAP.put((Object)Value.Type.TIME, (Object)DocumentReader.EventType.TIME);
        TYPE_EVENTTYPE_MAP.put((Object)Value.Type.TIMESTAMP, (Object)DocumentReader.EventType.TIMESTAMP);
        TYPE_EVENTTYPE_MAP.put((Object)Value.Type.INTERVAL, (Object)DocumentReader.EventType.INTERVAL);
        TYPE_EVENTTYPE_MAP.put((Object)Value.Type.BINARY, (Object)DocumentReader.EventType.BINARY);
        TYPE_EVENTTYPE_MAP.put((Object)Value.Type.MAP, (Object)DocumentReader.EventType.START_MAP);
        TYPE_EVENTTYPE_MAP.put((Object)Value.Type.ARRAY, (Object)DocumentReader.EventType.START_ARRAY);
        assert (TYPE_EVENTTYPE_MAP.size() == Value.Type.values().length) : "Map is missing some of the Type enum elements";
    }
}

