/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.ddl;

import org.apache.calcite.jdbc.CalcitePrepare;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.materialize.MaterializationKey;
import org.apache.calcite.materialize.MaterializationService;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.Wrapper;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.ddl.SqlDdlNodes;
import org.apache.calcite.sql.ddl.SqlDropObject;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.Pair;

public class SqlDropMaterializedView
extends SqlDropObject {
    private static final SqlOperator OPERATOR = new SqlSpecialOperator("DROP MATERIALIZED VIEW", SqlKind.DROP_MATERIALIZED_VIEW);

    SqlDropMaterializedView(SqlParserPos pos, boolean ifExists, SqlIdentifier name) {
        super(OPERATOR, pos, ifExists, name);
    }

    @Override
    public void execute(CalcitePrepare.Context context) {
        Pair<CalciteSchema, String> pair = SqlDdlNodes.schema(context, true, this.name);
        Table table = ((CalciteSchema)pair.left).plus().getTable((String)pair.right);
        if (table != null) {
            MaterializationKey materializationKey;
            super.execute(context);
            if (table instanceof Wrapper && (materializationKey = (MaterializationKey)((Wrapper)table).unwrap(MaterializationKey.class)) != null) {
                MaterializationService.instance().removeMaterialization(materializationKey);
            }
        }
    }
}

