# This file is empty by default. Default Drill environment settings appear
# in drill-config.sh. Distributions can replace this file with a
# distribution-specific version that sets environment variables and options
# specific to that distribution. Users should not put anything in this file;
# put user options in drill-env.sh instead.

# MapR-specific environment settings for Drill

MAPR_HOME="${MAPR_HOME:-/opt/mapr}"
export HADOOP_VERSION=`cat /opt/mapr/hadoop/hadoopversion`
export HADOOP_HOME=${HADOOP_HOME:-"/opt/mapr/hadoop/hadoop-${HADOOP_VERSION}"}

export DRILL_JAVA_OPTS="${DRILL_JAVA_OPTS} -Djava.io.tmpdir=/tmp/drill -Djava.security.auth.login.config=/opt/mapr/conf/mapr.login.conf -Dhadoop.login=hybrid_keytab -Dzookeeper.sasl.client=false"
export DRILL_LOG_DIR=${DRILL_LOG_DIR:-"/opt/mapr/drill/drill-1.16.0/logs"}
export DRILL_PID_DIR=${DRILL_PID_DIR:-"/opt/mapr/pid"}
export MAPR_IMPERSONATION_ENABLED=${MAPR_IMPERSONATION_ENABLED:-"true"}

# Only set MAPR_TICKETFILE_LOCATION when invoked in context of drillbit setup NOT sqlline. It is expected
# to generate a separate ticket when sqlline is used.
if [ "$DRILLBIT_CONTEXT" = "1" ]; then
    export MAPR_TICKETFILE_LOCATION=${MAPR_TICKETFILE_LOCATION:-"/opt/mapr/conf/mapruserticket"}
fi
export SQLLINE_JAVA_OPTS="${SQLLINE_JAVA_OPTS} -Ddrill.customAuthFactories=org.apache.drill.exec.rpc.security.maprsasl.MapRSaslFactory -Dzookeeper.sasl.client=false -Djava.security.auth.login.config=/opt/mapr/conf/mapr.login.conf"

#Enable JMX for MaprMonitoring - tag to prevent older collectds from changing stuff

# import JMX variable from /opt/mapr/conf/env_override.sh
# since drill does not use # $MAPR_HOME/conf/env.sh

MAPR_ENV_OVERRIDE_FILE="/opt/mapr/conf/env_override.sh"
if [ -e "$MAPR_ENV_OVERRIDE_FILE" ]; then
    for v in "$(grep -F MAPR_JMX "$MAPR_ENV_OVERRIDE_FILE")"; do
        eval $v
    done
fi

isSecure="false"
if [ -f "${MAPR_HOME}/conf/mapr-clusters.conf" ]; then
  isSecure=$(head -1 ${MAPR_HOME}/conf/mapr-clusters.conf | grep -o 'secure=\w*' | cut -d= -f2)
fi

#Mapr JMX handling
MAPR_JMX_PORT=${MAPR_JMX_DRILL_PORT:-6090}

if [ -z "$MAPR_JMXLOCALBINDING" ]; then
    MAPR_JMXLOCALBINDING="false"
fi

if [ -z "$MAPR_JMXAUTH" ]; then
    MAPR_JMXAUTH="false"
fi

if [ -z "$MAPR_JMXSSL" ]; then
    MAPR_JMXSSL="false"
fi

if [ -z "$MAPR_JMXDISABLE" ] && [ -z "$MAPR_JMXLOCALHOST" ] && [ -z "$MAPR_JMXREMOTEHOST" ]; then
    echo "No MapR JMX options given - defaulting to local binding"
fi

if [[ ( -z "$MAPR_JMXDISABLE" || "$MAPR_JMXDISABLE" = 'false' ) && \
      ( -z "$MAPR_JMX_DRILLBITS_ENABLE" || "$MAPR_JMX_DRILLBITS_ENABLE" = "true" ) ]]; then
    # default setting for localBinding
    MAPR_JMX_OPTS="-Dcom.sun.management.jmxremote"
    if [ "$MAPR_JMXAUTH" = "true" ]; then
        if [ "$isSecure" = "true" ]; then
            if [ -f "$MAPR_HOME/conf/jmxremote.password" ] && [ -f "$MAPR_HOME/conf/jmxremote.access" ]; then
                MAPR_JMX_OPTS="$MAPR_JMX_OPTS -Dcom.sun.management.jmxremote.authenticate=true \
                    -Dcom.sun.management.jmxremote.password.file=$MAPR_HOME/conf/jmxremote.password \
                    -Dcom.sun.management.jmxremote.access.file=$MAPR_HOME/conf/jmxremote.access"
            else
                echo "JMX password and/or access files missing - not starting since we are in secure mode"
                exit 1
            fi
        else
            echo "JMX Authentication configured - not starting since we are not in secure mode"
            exit 1
        fi
    else
        MAPR_JMX_OPTS="$MAPR_JMX_OPTS -Dcom.sun.management.jmxremote.authenticate=false"
    fi

    if [ "$MAPR_JMXLOCALHOST" = "true" ] && [ "$MAPR_JMXREMOTEHOST" = "true" ]; then
        echo "WARNING: Both MAPR_JMXLOCALHOST and MAPR_JMXREMOTEHOST options are enabled - defaulting to MAPR_JMXLOCALHOST config"
        MAPR_JMXREMOTEHOST=false
    fi
    if [ "$MAPR_JMXLOCALHOST" = "true" ] || [ "$MAPR_JMXREMOTEHOST" = "true" ]; then
        if [ "$MAPR_JMXSSL" = "true" ]; then
            MAPR_JMX_OPTS="$MAPR_JMX_OPTS -Dcom.sun.management.jmxremote.ssl=true"
        else
            MAPR_JMX_OPTS="$MAPR_JMX_OPTS -Dcom.sun.management.jmxremote.ssl=false"
        fi

        if [ "$MAPR_JMXLOCALHOST" = "true" ]; then
            MAPR_JMX_OPTS="$MAPR_JMX_OPTS -Djava.rmi.server.hostname=localhost \
                -Dcom.sun.management.jmxremote.host=localhost \
                -Dcom.sun.management.jmxremote.local.only=true"
        fi

        if [ -z "$MAPR_JMX_PORT" ]; then
            echo "WARNING: No JMX port given for drill - disabling TCP base JMX service"
            MAPR_JMX_OPTS=""
        else
            if [ "$MAPR_JMXLOCALHOST" = "true" ]; then
                echo "Enabling TCP JMX for drill only on localhost port $MAPR_JMX_PORT"
            else
                echo "Enabling TCP JMX for drill on port $MAPR_JMX_PORT"
            fi
            MAPR_JMX_OPTS="$MAPR_JMX_OPTS -Dcom.sun.management.jmxremote.port=$MAPR_JMX_PORT"
        fi
    fi

    if [ "$MAPR_JMXLOCALBINDING" = "true" ] && [ -z "$MAPR_JMX_OPTS" ]; then
        echo "Enabling JMX local binding only"
        MAPR_JMX_OPTS="-Dcom.sun.management.jmxremote"
    fi
else
    echo "JMX disabled by user request"
    MAPR_JMX_OPTS=""
fi

export DRILL_JAVA_OPTS="$MAPR_JMX_OPTS $DRILL_JAVA_OPTS"
