

package org.apache.drill.exec.expr.fn.impl;

import io.netty.buffer.ByteBuf;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.NullHandling;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.holders.*;
import org.apache.drill.exec.record.RecordBatch;
import org.joda.time.MutableDateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.DateMidnight;

/*
 * This class is generated using freemarker and the DateIntervalFunctionTemplates/IntervalIntervalArithmetic.java template.
 */

public class IntervalYearFunctions {

    @SuppressWarnings("unused")
    @FunctionTemplate(name = "add", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.NULL_IF_NULL)
    public static class IntervalYearAddFunction implements DrillSimpleFunc {
    @Param IntervalYearHolder left;
    @Param IntervalYearHolder right;
    @Output IntervalYearHolder out;

        public void setup() {
        }

        public void eval() {
            out.value = left.value + right.value;
        }
    }

    @SuppressWarnings("unused")
    @FunctionTemplate(name = "subtract", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.NULL_IF_NULL)
    public static class IntervalYearSubtractFunction implements DrillSimpleFunc {
    @Param IntervalYearHolder left;
    @Param IntervalYearHolder right;
    @Output IntervalYearHolder out;

        public void setup() {
        }

        public void eval() {
            out.value = left.value - right.value;
        }
    }
    @SuppressWarnings("unused")
    @FunctionTemplate(names = {"negative", "u-", "-"}, scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.NULL_IF_NULL)
    public static class IntervalYearNegateFunction implements DrillSimpleFunc {
    @Param IntervalYearHolder left;
    @Output IntervalYearHolder out;

        public void setup() {
        }

        public void eval() {
            out.value = -left.value;
        }
    }
}
