

package org.apache.drill.exec.expr.fn.impl;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.NullHandling;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.fn.FunctionGenerationHelper;
import org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers;
import org.apache.drill.exec.expr.holders.*;
import org.apache.drill.exec.record.RecordBatch;
import javax.inject.Inject;
import io.netty.buffer.DrillBuf;

/*
 * This class is generated using freemarker and the ComparisonFunctions.java template.
 */

@SuppressWarnings("unused")
public class GCompareIntVsInt {



  @FunctionTemplate(name = FunctionGenerationHelper.COMPARE_TO_NULLS_HIGH,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.INTERNAL)
  public static class GCompareIntVsIntNullHigh implements DrillSimpleFunc {

    @Param IntHolder left;
    @Param IntHolder right;
    @Output IntHolder out;

    public void setup() {}

    public void eval() {
     outside:
      {


    // NaN is the biggest possible value, and NaN == NaN
      if(Double.isNaN(left.value) && Double.isNaN(right.value)) {
        out.value = 0;
      } else if (!Double.isNaN(left.value) && Double.isNaN(right.value)) {
        out.value = -1;
      } else if (Double.isNaN(left.value) && !Double.isNaN(right.value)) {
        out.value = 1;
      } else {
        out.value = left.value < right.value ? -1 : (left.value == right.value ? 0 : 1);
      }


      } // outside
    }
  }

  @FunctionTemplate(name = FunctionGenerationHelper.COMPARE_TO_NULLS_LOW,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.INTERNAL)
  public static class GCompareIntVsIntNullLow implements DrillSimpleFunc {

    @Param IntHolder left;
    @Param IntHolder right;
    @Output IntHolder out;

    public void setup() {}

    public void eval() {
     outside:
      {


    // NaN is the biggest possible value, and NaN == NaN
      if(Double.isNaN(left.value) && Double.isNaN(right.value)) {
        out.value = 0;
      } else if (!Double.isNaN(left.value) && Double.isNaN(right.value)) {
        out.value = -1;
      } else if (Double.isNaN(left.value) && !Double.isNaN(right.value)) {
        out.value = 1;
      } else {
        out.value = left.value < right.value ? -1 : (left.value == right.value ? 0 : 1);
      }


      } // outside
    }
  }



  @FunctionTemplate(name = FunctionGenerationHelper.COMPARE_TO_NULLS_HIGH,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.INTERNAL)
  public static class GCompareIntVsNullableIntNullHigh implements DrillSimpleFunc {

    @Param IntHolder left;
    @Param NullableIntHolder right;
    @Output IntHolder out;

    public void setup() {}

    public void eval() {
     outside:
      {

      if ( right.isSet == 0 ) {
        out.value = -1;
        break outside;
      }

    // NaN is the biggest possible value, and NaN == NaN
      if(Double.isNaN(left.value) && Double.isNaN(right.value)) {
        out.value = 0;
      } else if (!Double.isNaN(left.value) && Double.isNaN(right.value)) {
        out.value = -1;
      } else if (Double.isNaN(left.value) && !Double.isNaN(right.value)) {
        out.value = 1;
      } else {
        out.value = left.value < right.value ? -1 : (left.value == right.value ? 0 : 1);
      }


      } // outside
    }
  }

  @FunctionTemplate(name = FunctionGenerationHelper.COMPARE_TO_NULLS_LOW,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.INTERNAL)
  public static class GCompareIntVsNullableIntNullLow implements DrillSimpleFunc {

    @Param IntHolder left;
    @Param NullableIntHolder right;
    @Output IntHolder out;

    public void setup() {}

    public void eval() {
     outside:
      {

      if ( right.isSet == 0 ) {
        out.value = 1;
        break outside;
      }

    // NaN is the biggest possible value, and NaN == NaN
      if(Double.isNaN(left.value) && Double.isNaN(right.value)) {
        out.value = 0;
      } else if (!Double.isNaN(left.value) && Double.isNaN(right.value)) {
        out.value = -1;
      } else if (Double.isNaN(left.value) && !Double.isNaN(right.value)) {
        out.value = 1;
      } else {
        out.value = left.value < right.value ? -1 : (left.value == right.value ? 0 : 1);
      }


      } // outside
    }
  }



  @FunctionTemplate(name = FunctionGenerationHelper.COMPARE_TO_NULLS_HIGH,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.INTERNAL)
  public static class GCompareNullableIntVsIntNullHigh implements DrillSimpleFunc {

    @Param NullableIntHolder left;
    @Param IntHolder right;
    @Output IntHolder out;

    public void setup() {}

    public void eval() {
     outside:
      {

        if ( left.isSet == 0 ) {
          out.value = 1;
          break outside;
        }

    // NaN is the biggest possible value, and NaN == NaN
      if(Double.isNaN(left.value) && Double.isNaN(right.value)) {
        out.value = 0;
      } else if (!Double.isNaN(left.value) && Double.isNaN(right.value)) {
        out.value = -1;
      } else if (Double.isNaN(left.value) && !Double.isNaN(right.value)) {
        out.value = 1;
      } else {
        out.value = left.value < right.value ? -1 : (left.value == right.value ? 0 : 1);
      }


      } // outside
    }
  }

  @FunctionTemplate(name = FunctionGenerationHelper.COMPARE_TO_NULLS_LOW,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.INTERNAL)
  public static class GCompareNullableIntVsIntNullLow implements DrillSimpleFunc {

    @Param NullableIntHolder left;
    @Param IntHolder right;
    @Output IntHolder out;

    public void setup() {}

    public void eval() {
     outside:
      {

        if ( left.isSet == 0 ) {
          out.value = -1;
          break outside;
        }

    // NaN is the biggest possible value, and NaN == NaN
      if(Double.isNaN(left.value) && Double.isNaN(right.value)) {
        out.value = 0;
      } else if (!Double.isNaN(left.value) && Double.isNaN(right.value)) {
        out.value = -1;
      } else if (Double.isNaN(left.value) && !Double.isNaN(right.value)) {
        out.value = 1;
      } else {
        out.value = left.value < right.value ? -1 : (left.value == right.value ? 0 : 1);
      }


      } // outside
    }
  }



  @FunctionTemplate(name = FunctionGenerationHelper.COMPARE_TO_NULLS_HIGH,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.INTERNAL)
  public static class GCompareNullableIntVsNullableIntNullHigh implements DrillSimpleFunc {

    @Param NullableIntHolder left;
    @Param NullableIntHolder right;
    @Output IntHolder out;

    public void setup() {}

    public void eval() {
     outside:
      {

        if ( left.isSet == 0 ) {
          if ( right.isSet == 0 ) {
            out.value = 0;
            break outside;
          } else {
            out.value = 1;
            break outside;
          }
        } else if ( right.isSet == 0 ) {
          out.value = -1;
          break outside;
        }

    // NaN is the biggest possible value, and NaN == NaN
      if(Double.isNaN(left.value) && Double.isNaN(right.value)) {
        out.value = 0;
      } else if (!Double.isNaN(left.value) && Double.isNaN(right.value)) {
        out.value = -1;
      } else if (Double.isNaN(left.value) && !Double.isNaN(right.value)) {
        out.value = 1;
      } else {
        out.value = left.value < right.value ? -1 : (left.value == right.value ? 0 : 1);
      }


      } // outside
    }
  }

  @FunctionTemplate(name = FunctionGenerationHelper.COMPARE_TO_NULLS_LOW,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.INTERNAL)
  public static class GCompareNullableIntVsNullableIntNullLow implements DrillSimpleFunc {

    @Param NullableIntHolder left;
    @Param NullableIntHolder right;
    @Output IntHolder out;

    public void setup() {}

    public void eval() {
     outside:
      {

        if ( left.isSet == 0 ) {
          if ( right.isSet == 0 ) {
            out.value = 0;
            break outside;
          } else {
            out.value = -1;
            break outside;
          }
        } else if ( right.isSet == 0 ) {
          out.value = 1;
          break outside;
        }

    // NaN is the biggest possible value, and NaN == NaN
      if(Double.isNaN(left.value) && Double.isNaN(right.value)) {
        out.value = 0;
      } else if (!Double.isNaN(left.value) && Double.isNaN(right.value)) {
        out.value = -1;
      } else if (Double.isNaN(left.value) && !Double.isNaN(right.value)) {
        out.value = 1;
      } else {
        out.value = left.value < right.value ? -1 : (left.value == right.value ? 0 : 1);
      }


      } // outside
    }
  }

   @FunctionTemplate(names = {"less_than", "<"},
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.NULL_IF_NULL)
  public static class LessThanIntVsInt implements DrillSimpleFunc {

      @Param IntHolder left;
      @Param IntHolder right;
      @Output BitHolder out;

      public void setup() {}

      public void eval() {

        // NaN is the biggest possible value, and NaN == NaN
        if (Double.isNaN(left.value) || ( Double.isNaN(left.value) && Double.isNaN(right.value))) {
          out.value=0;
        } else if (Double.isNaN(right.value) && !Double.isNaN(left.value)) {
          out.value = 1;
        } else {
          out.value = left.value < right.value ? 1 : 0;
        }

      }
  }

  @FunctionTemplate(names = {"less_than_or_equal_to", "<="},
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.NULL_IF_NULL)
  public static class LessThanEqIntVsInt implements DrillSimpleFunc {

      @Param IntHolder left;
      @Param IntHolder right;
      @Output BitHolder out;

      public void setup() {}

      public void eval() {

        // NaN is the biggest possible value, and NaN == NaN
        if (Double.isNaN(right.value)){
          out.value = 1;
        } else if (!Double.isNaN(right.value) && Double.isNaN(left.value)) {
          out.value = 0;
        } else {
          out.value = left.value <= right.value ? 1 : 0;
        }

    }
  }

  @FunctionTemplate(names = {"greater_than", ">"},
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.NULL_IF_NULL)
  public static class GreaterThanIntVsInt implements DrillSimpleFunc {

      @Param IntHolder left;
      @Param IntHolder right;
      @Output BitHolder out;

      public void setup() {}

      public void eval() {

        // NaN is the biggest possible value, and NaN == NaN
        if (Double.isNaN(right.value) || ( Double.isNaN(left.value) && Double.isNaN(right.value))) {
          out.value = 0;
        } else if (Double.isNaN(left.value) && !Double.isNaN(right.value)) {
          out.value = 1;
        } else {
          out.value = left.value > right.value ? 1 : 0;
        }

    }
  }

  @FunctionTemplate(names = {"greater_than_or_equal_to", ">="},
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.NULL_IF_NULL)
  public static class GreaterThanEqIntVsInt implements DrillSimpleFunc {

      @Param IntHolder left;
      @Param IntHolder right;
      @Output BitHolder out;

      public void setup() {}

      public void eval() {

        // NaN is the biggest possible value, and NaN == NaN
        if (Double.isNaN(left.value)){
          out.value=1;
        } else if (!Double.isNaN(left.value) && Double.isNaN(right.value)) {
          out.value = 0;
        } else {
          out.value = left.value >= right.value ? 1 : 0;
        }


      }
  }

  @FunctionTemplate(names = {"equal", "==", "="},
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.NULL_IF_NULL)
  public static class EqualsIntVsInt implements DrillSimpleFunc {

      @Param IntHolder left;
      @Param IntHolder right;
      @Output BitHolder out;

      public void setup() {}

      public void eval() {

        // NaN is the biggest possible value, and NaN == NaN
        if (Double.isNaN(left.value) && Double.isNaN(right.value)) {
          out.value = 1;
        } else {
          out.value = left.value == right.value ? 1 : 0;
        }

      }
  }

  @FunctionTemplate(names = {"not_equal", "<>", "!="},
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.NULL_IF_NULL)
  public static class NotEqualsIntVsInt implements DrillSimpleFunc {

      @Param IntHolder left;
      @Param IntHolder right;
      @Output BitHolder out;

      public void setup() {}

      public void eval() {

        // NaN is the biggest possible value, and NaN == NaN
        if (Double.isNaN(left.value) && Double.isNaN(right.value)) {
          out.value = 0;
        } else {
          out.value = left.value != right.value ? 1 : 0;
        }

      }
  }

}


 



