/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hive.readers;

import io.netty.buffer.DrillBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.expr.TypeHelper;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.ops.OperatorContext;
import org.apache.drill.exec.physical.impl.OutputMutator;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.server.options.OptionManager;
import org.apache.drill.exec.server.options.OptionSet;
import org.apache.drill.exec.store.AbstractRecordReader;
import org.apache.drill.exec.store.hive.HiveFieldConverter;
import org.apache.drill.exec.store.hive.HivePartition;
import org.apache.drill.exec.store.hive.HiveTableWithColumnCache;
import org.apache.drill.exec.store.hive.HiveUtilities;
import org.apache.drill.exec.vector.AllocationHelper;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.apache.drill.shaded.guava.com.google.common.util.concurrent.ListenableFuture;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HiveAbstractReader
extends AbstractRecordReader {
    protected static final Logger logger = LoggerFactory.getLogger(HiveAbstractReader.class);
    protected final DrillBuf managedBuffer;
    protected HiveTableWithColumnCache table;
    protected HivePartition partition;
    protected Iterator<InputSplit> inputSplitsIterator;
    protected List<String> selectedColumnNames;
    protected List<StructField> selectedStructFieldRefs = Lists.newArrayList();
    protected List<TypeInfo> selectedColumnTypes = Lists.newArrayList();
    protected List<ObjectInspector> selectedColumnObjInspectors = Lists.newArrayList();
    protected List<HiveFieldConverter> selectedColumnFieldConverters = Lists.newArrayList();
    protected List<String> selectedPartitionNames = Lists.newArrayList();
    protected List<TypeInfo> selectedPartitionTypes = Lists.newArrayList();
    protected List<Object> selectedPartitionValues = Lists.newArrayList();
    protected Deserializer partitionDeserializer;
    protected StructObjectInspector partitionOI;
    protected StructObjectInspector finalOI;
    protected ObjectInspectorConverters.Converter partTblObjectInspectorConverter;
    protected Object key;
    protected RecordReader<Object, Object> reader;
    protected List<ValueVector> vectors = Lists.newArrayList();
    protected List<ValueVector> pVectors = Lists.newArrayList();
    protected boolean empty;
    protected HiveConf hiveConf;
    protected FragmentContext fragmentContext;
    protected String defaultPartitionValue;
    protected final UserGroupInformation proxyUgi;
    protected JobConf job;
    public static final int TARGET_RECORD_COUNT = 4000;

    public HiveAbstractReader(HiveTableWithColumnCache table, HivePartition partition, Collection<InputSplit> inputSplits, List<SchemaPath> projectedColumns, FragmentContext context, HiveConf hiveConf, UserGroupInformation proxyUgi) throws ExecutionSetupException {
        this.table = table;
        this.partition = partition;
        this.empty = inputSplits == null || inputSplits.isEmpty();
        this.inputSplitsIterator = this.empty ? Collections.emptyIterator() : inputSplits.iterator();
        this.hiveConf = hiveConf;
        this.fragmentContext = context;
        this.proxyUgi = proxyUgi;
        this.managedBuffer = this.fragmentContext.getManagedBuffer().reallocIfNeeded(256);
        this.setColumns(projectedColumns);
    }

    public abstract void internalInit(Properties var1, RecordReader<Object, Object> var2);

    private void init() throws ExecutionSetupException {
        Properties tableProperties;
        this.job = new JobConf((Configuration)this.hiveConf);
        this.defaultPartitionValue = this.hiveConf.get(HiveConf.ConfVars.DEFAULTPARTITIONNAME.varname);
        try {
            int i;
            tableProperties = HiveUtilities.getTableMetadata(this.table);
            Properties partitionProperties = this.partition == null ? tableProperties : HiveUtilities.getPartitionMetadata(this.partition, this.table);
            HiveUtilities.addConfToJob(this.job, partitionProperties);
            Deserializer tableDeserializer = HiveAbstractReader.createDeserializer(this.job, this.table.getSd().getSerdeInfo().getSerializationLib(), tableProperties);
            StructObjectInspector tableOI = HiveAbstractReader.getStructOI(tableDeserializer);
            if (this.partition != null) {
                this.partitionDeserializer = HiveAbstractReader.createDeserializer(this.job, this.partition.getSd().getSerdeInfo().getSerializationLib(), partitionProperties);
                this.partitionOI = HiveAbstractReader.getStructOI(this.partitionDeserializer);
                this.finalOI = (StructObjectInspector)ObjectInspectorConverters.getConvertedOI((ObjectInspector)this.partitionOI, (ObjectInspector)tableOI);
                this.partTblObjectInspectorConverter = ObjectInspectorConverters.getConverter((ObjectInspector)this.partitionOI, (ObjectInspector)this.finalOI);
                this.job.setInputFormat(HiveUtilities.getInputFormatClass(this.job, this.partition.getSd(), this.table));
                HiveUtilities.verifyAndAddTransactionalProperties(this.job, this.partition.getSd());
            } else {
                this.partitionDeserializer = tableDeserializer;
                this.partitionOI = tableOI;
                this.partTblObjectInspectorConverter = null;
                this.finalOI = tableOI;
                this.job.setInputFormat(HiveUtilities.getInputFormatClass(this.job, this.table.getSd(), this.table));
                HiveUtilities.verifyAndAddTransactionalProperties(this.job, this.table.getSd());
            }
            if (logger.isTraceEnabled()) {
                for (StructField field : this.finalOI.getAllStructFieldRefs()) {
                    logger.trace("field in finalOI: {}", (Object)field.getClass().getName());
                }
                logger.trace("partitionDeserializer class is {} {}", (Object)this.partitionDeserializer.getClass().getName());
            }
            ArrayList partitionNames = Lists.newArrayList();
            for (FieldSchema field : this.table.getPartitionKeys()) {
                partitionNames.add(field.getName());
            }
            StructTypeInfo sTypeInfo = (StructTypeInfo)TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)this.finalOI);
            ArrayList tableColumnNames = sTypeInfo.getAllStructFieldNames();
            ArrayList columnIds = Lists.newArrayList();
            if (this.isStarQuery()) {
                this.selectedColumnNames = tableColumnNames;
                for (int i2 = 0; i2 < this.selectedColumnNames.size(); ++i2) {
                    columnIds.add(i2);
                }
                this.selectedPartitionNames = partitionNames;
            } else {
                List<String> paths = this.getColumns().stream().map(SchemaPath::getRootSegmentPath).collect(Collectors.toList());
                partitionNames.forEach(partitionName -> {
                    for (int index = 0; index < paths.size(); ++index) {
                        if (!partitionName.equals(paths.get(index))) continue;
                        this.selectedPartitionNames.add((String)partitionName);
                        paths.remove(index);
                        break;
                    }
                });
                this.selectedColumnNames = Lists.newArrayList();
                paths.forEach(columnName -> {
                    columnIds.add(tableColumnNames.indexOf(columnName));
                    this.selectedColumnNames.add((String)columnName);
                });
            }
            List paths = this.getColumns().stream().map(SchemaPath::getRootSegmentPath).collect(Collectors.toList());
            ColumnProjectionUtils.appendReadColumns((Configuration)this.job, (List)columnIds, this.selectedColumnNames, paths);
            for (String columnName2 : this.selectedColumnNames) {
                StructField fieldRef = this.finalOI.getStructFieldRef(columnName2);
                this.selectedStructFieldRefs.add(fieldRef);
                ObjectInspector fieldOI = fieldRef.getFieldObjectInspector();
                TypeInfo typeInfo = TypeInfoUtils.getTypeInfoFromTypeString((String)fieldOI.getTypeName());
                this.selectedColumnObjInspectors.add(fieldOI);
                this.selectedColumnTypes.add(typeInfo);
                this.selectedColumnFieldConverters.add(HiveFieldConverter.create(typeInfo));
            }
            for (i = 0; i < this.selectedColumnNames.size(); ++i) {
                logger.trace("inspector:typeName={}, className={}, TypeInfo: {}, converter:{}", new Object[]{this.selectedColumnObjInspectors.get(i).getTypeName(), this.selectedColumnObjInspectors.get(i).getClass().getName(), this.selectedColumnTypes.get(i).toString(), this.selectedColumnFieldConverters.get(i).getClass().getName()});
            }
            for (i = 0; i < this.table.getPartitionKeys().size(); ++i) {
                FieldSchema field = (FieldSchema)this.table.getPartitionKeys().get(i);
                if (!this.selectedPartitionNames.contains(field.getName())) continue;
                TypeInfo pType = TypeInfoUtils.getTypeInfoFromTypeString((String)field.getType());
                this.selectedPartitionTypes.add(pType);
                if (this.partition == null) continue;
                this.selectedPartitionValues.add(HiveUtilities.convertPartitionType(pType, (String)this.partition.getValues().get(i), this.defaultPartitionValue));
            }
        }
        catch (Exception e) {
            throw new ExecutionSetupException("Failure while initializing Hive Reader " + ((Object)((Object)this)).getClass().getName(), (Throwable)e);
        }
        if (!this.empty && this.initNextReader(this.job)) {
            this.internalInit(tableProperties, this.reader);
        }
    }

    protected boolean initNextReader(JobConf job) throws ExecutionSetupException {
        if (this.inputSplitsIterator.hasNext()) {
            if (this.reader != null) {
                this.closeReader();
            }
            InputSplit inputSplit = this.inputSplitsIterator.next();
            try {
                this.reader = job.getInputFormat().getRecordReader(inputSplit, job, Reporter.NULL);
                logger.trace("hive reader created: {} for inputSplit {}", (Object)this.reader.getClass().getName(), (Object)inputSplit.toString());
            }
            catch (Exception e) {
                throw new ExecutionSetupException("Failed to get o.a.hadoop.mapred.RecordReader from Hive InputFormat", (Throwable)e);
            }
            return true;
        }
        return false;
    }

    private static Deserializer createDeserializer(JobConf job, String sLib, Properties properties) throws Exception {
        Class<Deserializer> c = Class.forName(sLib).asSubclass(Deserializer.class);
        Deserializer deserializer = c.getConstructor(new Class[0]).newInstance(new Object[0]);
        deserializer.initialize((Configuration)job, properties);
        return deserializer;
    }

    private static StructObjectInspector getStructOI(Deserializer deserializer) throws Exception {
        ObjectInspector oi = deserializer.getObjectInspector();
        if (oi.getCategory() != ObjectInspector.Category.STRUCT) {
            throw new UnsupportedOperationException(String.format("%s category not supported", oi.getCategory()));
        }
        return (StructObjectInspector)oi;
    }

    public void setup(OperatorContext context, OutputMutator output) throws ExecutionSetupException {
        Callable<Void> readerInitializer = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                HiveAbstractReader.this.init();
                return null;
            }
        };
        ListenableFuture result = context.runCallableAs(this.proxyUgi, (Callable)readerInitializer);
        try {
            result.get();
        }
        catch (InterruptedException e) {
            result.cancel(true);
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            throw ExecutionSetupException.fromThrowable((String)e.getMessage(), (Throwable)e);
        }
        try {
            Class vvClass;
            MaterializedField field;
            TypeProtos.MajorType type;
            int i;
            OptionManager options = this.fragmentContext.getOptions();
            for (i = 0; i < this.selectedColumnNames.size(); ++i) {
                type = HiveUtilities.getMajorTypeFromHiveTypeInfo(this.selectedColumnTypes.get(i), (OptionSet)options);
                field = MaterializedField.create((String)this.selectedColumnNames.get(i), (TypeProtos.MajorType)type);
                vvClass = TypeHelper.getValueVectorClass((TypeProtos.MinorType)type.getMinorType(), (TypeProtos.DataMode)type.getMode());
                this.vectors.add(output.addField(field, vvClass));
            }
            for (i = 0; i < this.selectedPartitionNames.size(); ++i) {
                type = HiveUtilities.getMajorTypeFromHiveTypeInfo(this.selectedPartitionTypes.get(i), (OptionSet)options);
                field = MaterializedField.create((String)this.selectedPartitionNames.get(i), (TypeProtos.MajorType)type);
                vvClass = TypeHelper.getValueVectorClass((TypeProtos.MinorType)field.getType().getMinorType(), (TypeProtos.DataMode)field.getDataMode());
                this.pVectors.add(output.addField(field, vvClass));
            }
        }
        catch (SchemaChangeException e) {
            throw new ExecutionSetupException((Throwable)e);
        }
    }

    public abstract int next();

    protected void setValueCountAndPopulatePartitionVectors(int recordCount) {
        for (ValueVector v : this.vectors) {
            v.getMutator().setValueCount(recordCount);
        }
        if (this.partition != null) {
            this.populatePartitionVectors(recordCount);
        }
    }

    protected void readHiveRecordAndInsertIntoRecordBatch(Object deSerializedValue, int outputRecordIndex) {
        for (int i = 0; i < this.selectedStructFieldRefs.size(); ++i) {
            Object hiveValue = this.finalOI.getStructFieldData(deSerializedValue, this.selectedStructFieldRefs.get(i));
            if (hiveValue == null) continue;
            this.selectedColumnFieldConverters.get(i).setSafeValue(this.selectedColumnObjInspectors.get(i), hiveValue, this.vectors.get(i), outputRecordIndex);
        }
    }

    public void close() {
        this.closeReader();
    }

    private void closeReader() {
        try {
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
            }
        }
        catch (Exception e) {
            logger.warn("Failure while closing Hive Record reader.", (Throwable)e);
        }
    }

    protected void populatePartitionVectors(int recordCount) {
        for (int i = 0; i < this.pVectors.size(); ++i) {
            ValueVector vector = this.pVectors.get(i);
            Object val = this.selectedPartitionValues.get(i);
            AllocationHelper.allocateNew((ValueVector)vector, (int)recordCount);
            if (val != null) {
                HiveUtilities.populateVector(vector, this.managedBuffer, val, 0, recordCount);
            }
            vector.getMutator().setValueCount(recordCount);
        }
    }

    protected boolean hasNextValue(Object value) {
        try {
            do {
                if (!this.reader.next(this.key, value)) continue;
                return true;
            } while (this.initNextReader(this.job));
            return false;
        }
        catch (IOException | ExecutionSetupException e) {
            throw new DrillRuntimeException(e);
        }
    }

    public String toString() {
        long position = -1L;
        try {
            if (this.reader != null) {
                position = this.reader.getPos();
            }
        }
        catch (IOException e) {
            logger.trace("Unable to obtain reader position.", (Throwable)e);
        }
        return ((Object)((Object)this)).getClass().getSimpleName() + "[Database=" + this.table.getDbName() + ", Table=" + this.table.getTableName() + ", Position=" + position + "]";
    }
}

