/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hive.client;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.calcite.schema.Schema;
import org.apache.drill.common.AutoCloseables;
import org.apache.drill.exec.store.hive.client.DrillHiveMetaStoreClient;
import org.apache.drill.shaded.guava.com.google.common.cache.CacheLoader;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TableNameCacheLoader
extends CacheLoader<String, Map<String, Schema.TableType>> {
    private static final Logger logger = LoggerFactory.getLogger(TableNameCacheLoader.class);
    private final DrillHiveMetaStoreClient client;

    TableNameCacheLoader(DrillHiveMetaStoreClient client) {
        this.client = client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Schema.TableType> load(String dbName) throws Exception {
        List tableAndViewNames;
        HashSet<String> viewNames = new HashSet<String>();
        DrillHiveMetaStoreClient drillHiveMetaStoreClient = this.client;
        synchronized (drillHiveMetaStoreClient) {
            try {
                tableAndViewNames = this.client.getAllTables(dbName);
                viewNames.addAll(this.client.getTables(dbName, "*", TableType.VIRTUAL_VIEW));
            }
            catch (MetaException e) {
                logger.warn("Failure while attempting to get hive tables. Retries once.", (Throwable)e);
                AutoCloseable[] autoCloseableArray = new AutoCloseable[1];
                autoCloseableArray[0] = () -> ((DrillHiveMetaStoreClient)this.client).close();
                AutoCloseables.closeSilently((AutoCloseable[])autoCloseableArray);
                this.client.reconnect();
                tableAndViewNames = this.client.getAllTables(dbName);
                viewNames.addAll(this.client.getTables(dbName, "*", TableType.VIRTUAL_VIEW));
            }
        }
        Map result = tableAndViewNames.stream().collect(Collectors.toMap(Function.identity(), this.getValueMapper(viewNames)));
        return Collections.unmodifiableMap(result);
    }

    private Function<String, Schema.TableType> getValueMapper(Set<String> viewNames) {
        if (viewNames.isEmpty()) {
            return tableName -> Schema.TableType.TABLE;
        }
        return tableName -> viewNames.contains(tableName) ? Schema.TableType.VIEW : Schema.TableType.TABLE;
    }
}

