/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hive;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.exec.physical.EndpointAffinity;
import org.apache.drill.exec.physical.base.AbstractGroupScan;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.ScanStats;
import org.apache.drill.exec.physical.base.SubScan;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.store.hive.ColumnListsCache;
import org.apache.drill.exec.store.hive.HiveMetadataProvider;
import org.apache.drill.exec.store.hive.HiveReadEntry;
import org.apache.drill.exec.store.hive.HiveStoragePlugin;
import org.apache.drill.exec.store.hive.HiveStoragePluginConfig;
import org.apache.drill.exec.store.hive.HiveSubScan;
import org.apache.drill.exec.store.hive.HiveTableWithColumnCache;
import org.apache.drill.exec.store.hive.HiveTableWrapper;
import org.apache.drill.exec.store.hive.HiveUtilities;
import org.apache.drill.exec.util.Utilities;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeName(value="hive-scan")
public class HiveScan
extends AbstractGroupScan {
    private static final Logger logger = LoggerFactory.getLogger(HiveScan.class);
    private static int HIVE_SERDE_SCAN_OVERHEAD_FACTOR_PER_COLUMN = 20;
    private final HiveStoragePlugin hiveStoragePlugin;
    private final HiveReadEntry hiveReadEntry;
    private final HiveMetadataProvider metadataProvider;
    private final Map<String, String> confProperties;
    private List<List<HiveMetadataProvider.LogicalInputSplit>> mappings;
    private List<HiveMetadataProvider.LogicalInputSplit> inputSplits;
    protected List<SchemaPath> columns;

    @JsonCreator
    public HiveScan(@JsonProperty(value="userName") String userName, @JsonProperty(value="hiveReadEntry") HiveReadEntry hiveReadEntry, @JsonProperty(value="hiveStoragePluginConfig") HiveStoragePluginConfig hiveStoragePluginConfig, @JsonProperty(value="columns") List<SchemaPath> columns, @JsonProperty(value="confProperties") Map<String, String> confProperties, @JacksonInject StoragePluginRegistry pluginRegistry) throws ExecutionSetupException {
        this(userName, hiveReadEntry, (HiveStoragePlugin)pluginRegistry.getPlugin((StoragePluginConfig)hiveStoragePluginConfig), columns, null, confProperties);
    }

    public HiveScan(String userName, HiveReadEntry hiveReadEntry, HiveStoragePlugin hiveStoragePlugin, List<SchemaPath> columns, HiveMetadataProvider metadataProvider, Map<String, String> confProperties) throws ExecutionSetupException {
        super(userName);
        this.hiveReadEntry = hiveReadEntry;
        this.columns = columns;
        this.hiveStoragePlugin = hiveStoragePlugin;
        this.confProperties = confProperties;
        this.metadataProvider = metadataProvider == null ? new HiveMetadataProvider(userName, hiveReadEntry, this.getHiveConf()) : metadataProvider;
    }

    public HiveScan(HiveScan that) {
        super((AbstractGroupScan)that);
        this.columns = that.columns;
        this.hiveReadEntry = that.hiveReadEntry;
        this.hiveStoragePlugin = that.hiveStoragePlugin;
        this.metadataProvider = that.metadataProvider;
        this.confProperties = that.confProperties;
    }

    public HiveScan clone(HiveReadEntry hiveReadEntry) throws ExecutionSetupException {
        return new HiveScan(this.getUserName(), hiveReadEntry, this.hiveStoragePlugin, this.columns, this.metadataProvider, this.confProperties);
    }

    @JsonProperty
    public HiveReadEntry getHiveReadEntry() {
        return this.hiveReadEntry;
    }

    @JsonProperty
    public HiveStoragePluginConfig getHiveStoragePluginConfig() {
        return this.hiveStoragePlugin.getConfig();
    }

    @JsonProperty
    public List<SchemaPath> getColumns() {
        return this.columns;
    }

    @JsonProperty
    public Map<String, String> getConfProperties() {
        return this.confProperties;
    }

    @JsonIgnore
    public HiveStoragePlugin getStoragePlugin() {
        return this.hiveStoragePlugin;
    }

    @JsonIgnore
    public HiveConf getHiveConf() {
        return HiveUtilities.generateHiveConf(this.hiveStoragePlugin.getHiveConf(), this.confProperties);
    }

    @JsonIgnore
    public boolean isNativeReader() {
        return false;
    }

    public boolean supportsPartitionFilterPushdown() {
        List partitionKeys = this.hiveReadEntry.getTable().getPartitionKeys();
        return partitionKeys != null && partitionKeys.size() != 0;
    }

    public void applyAssignments(List<CoordinationProtos.DrillbitEndpoint> endpoints) {
        this.mappings = new ArrayList<List<HiveMetadataProvider.LogicalInputSplit>>();
        for (int i = 0; i < endpoints.size(); ++i) {
            this.mappings.add(new ArrayList());
        }
        int count = endpoints.size();
        List<HiveMetadataProvider.LogicalInputSplit> inputSplits = this.getInputSplits();
        for (int i = 0; i < inputSplits.size(); ++i) {
            this.mappings.get(i % count).add(inputSplits.get(i));
        }
    }

    public SubScan getSpecificScan(int minorFragmentId) throws ExecutionSetupException {
        try {
            List<HiveMetadataProvider.LogicalInputSplit> splits = this.mappings.get(minorFragmentId);
            ArrayList<HiveTableWrapper.HivePartitionWrapper> parts = new ArrayList<HiveTableWrapper.HivePartitionWrapper>();
            ArrayList<List<String>> encodedInputSplits = new ArrayList<List<String>>();
            ArrayList<String> splitTypes = new ArrayList<String>();
            for (HiveMetadataProvider.LogicalInputSplit split : splits) {
                Partition splitPartition = split.getPartition();
                if (splitPartition != null) {
                    HiveTableWithColumnCache table = this.hiveReadEntry.getTable();
                    parts.add(HiveUtilities.createPartitionWithSpecColumns(new HiveTableWithColumnCache(table, new ColumnListsCache(table)), splitPartition));
                }
                encodedInputSplits.add(split.serialize());
                splitTypes.add(split.getType());
            }
            if (parts.size() <= 0) {
                parts = null;
            }
            HiveReadEntry subEntry = new HiveReadEntry(this.hiveReadEntry.getTableWrapper(), parts);
            return new HiveSubScan(this.getUserName(), encodedInputSplits, subEntry, splitTypes, this.columns, this.hiveStoragePlugin, this.confProperties);
        }
        catch (IOException | ReflectiveOperationException e) {
            throw new ExecutionSetupException((Throwable)e);
        }
    }

    public int getMaxParallelizationWidth() {
        return this.getInputSplits().size();
    }

    public List<EndpointAffinity> getOperatorAffinity() {
        HashMap<String, CoordinationProtos.DrillbitEndpoint> endpointMap = new HashMap<String, CoordinationProtos.DrillbitEndpoint>();
        for (CoordinationProtos.DrillbitEndpoint endpoint : this.hiveStoragePlugin.getContext().getBits()) {
            endpointMap.put(endpoint.getAddress(), endpoint);
            logger.debug("Endpoint address: {}", (Object)endpoint.getAddress());
        }
        HashMap<CoordinationProtos.DrillbitEndpoint, EndpointAffinity> affinityMap = new HashMap<CoordinationProtos.DrillbitEndpoint, EndpointAffinity>();
        try {
            long totalSize = 0L;
            List<HiveMetadataProvider.LogicalInputSplit> inputSplits = this.getInputSplits();
            for (HiveMetadataProvider.LogicalInputSplit split : inputSplits) {
                totalSize += Math.max(1L, split.getLength());
            }
            for (HiveMetadataProvider.LogicalInputSplit split : inputSplits) {
                float affinity = (float)Math.max(1L, split.getLength()) / (float)totalSize;
                for (String loc : split.getLocations()) {
                    logger.debug("Split location: {}", (Object)loc);
                    CoordinationProtos.DrillbitEndpoint endpoint = (CoordinationProtos.DrillbitEndpoint)endpointMap.get(loc);
                    if (endpoint == null) continue;
                    if (affinityMap.containsKey(endpoint)) {
                        ((EndpointAffinity)affinityMap.get(endpoint)).addAffinity((double)affinity);
                        continue;
                    }
                    affinityMap.put(endpoint, new EndpointAffinity(endpoint, (double)affinity));
                }
            }
        }
        catch (IOException e) {
            throw new DrillRuntimeException((Throwable)e);
        }
        return new ArrayList<EndpointAffinity>(affinityMap.values());
    }

    public ScanStats getScanStats() {
        try {
            HiveMetadataProvider.HiveStats stats = this.metadataProvider.getStats(this.hiveReadEntry);
            logger.debug("HiveStats: {}", (Object)stats.toString());
            float cpuCost = 1 * this.getSerDeOverheadFactor();
            return new ScanStats(ScanStats.GroupScanProperty.NO_EXACT_ROW_COUNT, (double)stats.getNumRows(), (double)cpuCost, (double)stats.getSizeInBytes());
        }
        catch (IOException e) {
            throw new DrillRuntimeException((Throwable)e);
        }
    }

    public PhysicalOperator getNewWithChildren(List<PhysicalOperator> children) {
        return new HiveScan(this);
    }

    public String getDigest() {
        return this.toString();
    }

    public String toString() {
        List<HiveTableWrapper.HivePartitionWrapper> partitions = this.hiveReadEntry.getHivePartitionWrappers();
        int numPartitions = partitions == null ? 0 : partitions.size();
        return "HiveScan [table=" + this.hiveReadEntry.getHiveTableWrapper() + ", columns=" + this.columns + ", numPartitions=" + numPartitions + ", partitions= " + partitions + ", inputDirectories=" + this.metadataProvider.getInputDirectories(this.hiveReadEntry) + ", confProperties=" + this.confProperties + "]";
    }

    public GroupScan clone(List<SchemaPath> columns) {
        HiveScan newScan = new HiveScan(this);
        newScan.columns = columns;
        return newScan;
    }

    public boolean canPushdownProjects(List<SchemaPath> columns) {
        return true;
    }

    private List<HiveMetadataProvider.LogicalInputSplit> getInputSplits() {
        if (this.inputSplits == null) {
            this.inputSplits = this.metadataProvider.getInputSplits(this.hiveReadEntry);
        }
        return this.inputSplits;
    }

    private int getSerDeOverheadFactor() {
        int projectedColumnCount;
        if (Utilities.isStarQuery(this.columns)) {
            HiveTableWithColumnCache hiveTable = this.hiveReadEntry.getTable();
            projectedColumnCount = hiveTable.getSd().getColsSize() + hiveTable.getPartitionKeysSize();
        } else {
            projectedColumnCount = Math.max(this.columns.size(), 1);
        }
        return projectedColumnCount * HIVE_SERDE_SCAN_OVERHEAD_FACTOR_PER_COLUMN;
    }
}

