/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hive;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.record.metadata.TupleSchema;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.store.hive.HivePartitionHolder;
import org.apache.drill.exec.store.hive.HiveStoragePlugin;
import org.apache.drill.exec.store.hive.HiveStoragePluginConfig;
import org.apache.drill.exec.store.hive.HiveUtilities;
import org.apache.drill.exec.store.parquet.AbstractParquetRowGroupScan;
import org.apache.drill.exec.store.parquet.ParquetReaderConfig;
import org.apache.drill.exec.store.parquet.RowGroupReadEntry;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.parquet.ProjectionPusher;
import org.apache.hadoop.mapred.JobConf;

@JsonTypeName(value="hive-drill-native-parquet-row-group-scan")
public class HiveDrillNativeParquetRowGroupScan
extends AbstractParquetRowGroupScan {
    private final HiveStoragePlugin hiveStoragePlugin;
    private final HiveStoragePluginConfig hiveStoragePluginConfig;
    private final HivePartitionHolder hivePartitionHolder;
    private final Map<String, String> confProperties;

    @JsonCreator
    public HiveDrillNativeParquetRowGroupScan(@JacksonInject StoragePluginRegistry registry, @JsonProperty(value="userName") String userName, @JsonProperty(value="hiveStoragePluginConfig") HiveStoragePluginConfig hiveStoragePluginConfig, @JsonProperty(value="rowGroupReadEntries") List<RowGroupReadEntry> rowGroupReadEntries, @JsonProperty(value="columns") List<SchemaPath> columns, @JsonProperty(value="hivePartitionHolder") HivePartitionHolder hivePartitionHolder, @JsonProperty(value="confProperties") Map<String, String> confProperties, @JsonProperty(value="readerConfig") ParquetReaderConfig readerConfig, @JsonProperty(value="filter") LogicalExpression filter, @JsonProperty(value="tupleSchema") TupleSchema tupleSchema) throws ExecutionSetupException {
        this(userName, (HiveStoragePlugin)registry.getPlugin((StoragePluginConfig)hiveStoragePluginConfig), rowGroupReadEntries, columns, hivePartitionHolder, confProperties, readerConfig, filter, tupleSchema);
    }

    public HiveDrillNativeParquetRowGroupScan(String userName, HiveStoragePlugin hiveStoragePlugin, List<RowGroupReadEntry> rowGroupReadEntries, List<SchemaPath> columns, HivePartitionHolder hivePartitionHolder, Map<String, String> confProperties, ParquetReaderConfig readerConfig, LogicalExpression filter, TupleSchema tupleSchema) {
        super(userName, rowGroupReadEntries, columns, readerConfig, filter, null, tupleSchema);
        this.hiveStoragePlugin = (HiveStoragePlugin)((Object)Preconditions.checkNotNull((Object)((Object)hiveStoragePlugin), (Object)"Could not find format config for the given configuration"));
        this.hiveStoragePluginConfig = hiveStoragePlugin.getConfig();
        this.hivePartitionHolder = hivePartitionHolder;
        this.confProperties = confProperties;
    }

    @JsonProperty
    public HiveStoragePluginConfig getHiveStoragePluginConfig() {
        return this.hiveStoragePluginConfig;
    }

    @JsonProperty
    public HivePartitionHolder getHivePartitionHolder() {
        return this.hivePartitionHolder;
    }

    @JsonProperty
    public Map<String, String> getConfProperties() {
        return this.confProperties;
    }

    @JsonIgnore
    public HiveStoragePlugin getHiveStoragePlugin() {
        return this.hiveStoragePlugin;
    }

    public PhysicalOperator getNewWithChildren(List<PhysicalOperator> children) {
        Preconditions.checkArgument((boolean)children.isEmpty());
        return new HiveDrillNativeParquetRowGroupScan(this.getUserName(), this.hiveStoragePlugin, this.rowGroupReadEntries, this.columns, this.hivePartitionHolder, this.confProperties, this.readerConfig, this.filter, this.tupleSchema);
    }

    public int getOperatorType() {
        return 43;
    }

    public AbstractParquetRowGroupScan copy(List<SchemaPath> columns) {
        return new HiveDrillNativeParquetRowGroupScan(this.getUserName(), this.hiveStoragePlugin, this.rowGroupReadEntries, columns, this.hivePartitionHolder, this.confProperties, this.readerConfig, this.filter, this.tupleSchema);
    }

    public Configuration getFsConf(RowGroupReadEntry rowGroupReadEntry) throws IOException {
        Path path = rowGroupReadEntry.getPath().getParent();
        return new ProjectionPusher().pushProjectionsAndFilters(new JobConf((Configuration)HiveUtilities.generateHiveConf(this.hiveStoragePlugin.getHiveConf(), this.confProperties)), path.getParent());
    }

    public boolean supportsFileImplicitColumns() {
        return false;
    }

    public List<String> getPartitionValues(RowGroupReadEntry rowGroupReadEntry) {
        return this.hivePartitionHolder.get(rowGroupReadEntry.getPath());
    }
}

