/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.hive;

import java.sql.Timestamp;
import org.apache.drill.exec.expr.fn.impl.hive.AbstractDrillPrimitiveObjectInspector;
import org.apache.drill.exec.expr.holders.NullableTimeStampHolder;
import org.apache.drill.exec.expr.holders.TimeStampHolder;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDateTime;

public class DrillTimeStampTimestampObjectInspector {

    public static class Optional
    extends AbstractDrillPrimitiveObjectInspector
    implements TimestampObjectInspector {
        public Optional() {
            super(TypeInfoFactory.timestampTypeInfo);
        }

        public Timestamp getPrimitiveJavaObject(Object o) {
            if (o == null) {
                return null;
            }
            NullableTimeStampHolder h = (NullableTimeStampHolder)o;
            LocalDateTime dateTime = new LocalDateTime(h.value, DateTimeZone.UTC);
            return new Timestamp(dateTime.toDate().getTime());
        }

        public TimestampWritable getPrimitiveWritableObject(Object o) {
            if (o == null) {
                return null;
            }
            NullableTimeStampHolder h = (NullableTimeStampHolder)o;
            LocalDateTime dateTime = new LocalDateTime(h.value, DateTimeZone.UTC);
            return new TimestampWritable(new Timestamp(dateTime.toDate().getTime()));
        }
    }

    public static class Required
    extends AbstractDrillPrimitiveObjectInspector
    implements TimestampObjectInspector {
        public Required() {
            super(TypeInfoFactory.timestampTypeInfo);
        }

        public Timestamp getPrimitiveJavaObject(Object o) {
            TimeStampHolder h = (TimeStampHolder)o;
            LocalDateTime dateTime = new LocalDateTime(h.value, DateTimeZone.UTC);
            return new Timestamp(dateTime.toDate().getTime());
        }

        public TimestampWritable getPrimitiveWritableObject(Object o) {
            TimeStampHolder h = (TimeStampHolder)o;
            LocalDateTime dateTime = new LocalDateTime(h.value, DateTimeZone.UTC);
            return new TimestampWritable(new Timestamp(dateTime.toDate().getTime()));
        }
    }
}

