/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.kafka;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import kafka.common.KafkaException;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.store.kafka.KafkaPartitionScanSpec;
import org.apache.drill.shaded.guava.com.google.common.base.Stopwatch;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageIterator
implements Iterator<ConsumerRecord<byte[], byte[]>> {
    private static final Logger logger = LoggerFactory.getLogger(MessageIterator.class);
    private final KafkaConsumer<byte[], byte[]> kafkaConsumer;
    private Iterator<ConsumerRecord<byte[], byte[]>> recordIter;
    private final TopicPartition topicPartition;
    private long totalFetchTime = 0L;
    private final long kafkaPollTimeOut;
    private final long endOffset;

    public MessageIterator(KafkaConsumer<byte[], byte[]> kafkaConsumer, KafkaPartitionScanSpec subScanSpec, long kafkaPollTimeOut) {
        this.kafkaConsumer = kafkaConsumer;
        this.kafkaPollTimeOut = kafkaPollTimeOut;
        ArrayList partitions = Lists.newArrayListWithCapacity((int)1);
        this.topicPartition = new TopicPartition(subScanSpec.getTopicName(), subScanSpec.getPartitionId());
        partitions.add(this.topicPartition);
        this.kafkaConsumer.assign((Collection)partitions);
        logger.info("Start offset of {}:{} is - {}", new Object[]{subScanSpec.getTopicName(), subScanSpec.getPartitionId(), subScanSpec.getStartOffset()});
        this.kafkaConsumer.seek(this.topicPartition, subScanSpec.getStartOffset());
        this.endOffset = subScanSpec.getEndOffset();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Does not support remove operation");
    }

    @Override
    public boolean hasNext() {
        if (this.recordIter != null && this.recordIter.hasNext()) {
            return true;
        }
        long nextPosition = this.kafkaConsumer.position(this.topicPartition);
        if (nextPosition >= this.endOffset) {
            return false;
        }
        ConsumerRecords consumerRecords = null;
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            consumerRecords = this.kafkaConsumer.poll(this.kafkaPollTimeOut);
        }
        catch (KafkaException ke) {
            logger.error(ke.getMessage(), (Throwable)ke);
            throw UserException.dataReadError((Throwable)ke).message(ke.getMessage(), new Object[0]).build(logger);
        }
        stopwatch.stop();
        if (consumerRecords.isEmpty()) {
            String errorMsg = "Failed to fetch messages within " + this.kafkaPollTimeOut + " milliseconds. Consider increasing the value of the property : " + "store.kafka.poll.timeout";
            throw UserException.dataReadError().message(errorMsg, new Object[0]).build(logger);
        }
        long lastFetchTime = stopwatch.elapsed(TimeUnit.MILLISECONDS);
        logger.debug("Total number of messages fetched : {}", (Object)consumerRecords.count());
        logger.debug("Time taken to fetch : {} milliseconds", (Object)lastFetchTime);
        this.totalFetchTime += lastFetchTime;
        this.recordIter = consumerRecords.iterator();
        return this.recordIter.hasNext();
    }

    public long getTotalFetchTime() {
        return this.totalFetchTime;
    }

    @Override
    public ConsumerRecord<byte[], byte[]> next() {
        return this.recordIter.next();
    }
}

