/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.httpdlog.dissectors.nginxmodules;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import nl.basjes.parse.core.Casts;
import nl.basjes.parse.core.Dissector;
import nl.basjes.parse.core.Parsable;
import nl.basjes.parse.core.ParsedField;
import nl.basjes.parse.core.exceptions.DissectionFailure;
import nl.basjes.parse.core.exceptions.InvalidDissectorException;

public class UpstreamListDissector
extends Dissector {
    private static final String OUTPUT_ORIGINAL_NAME = ".value";
    private static final String OUTPUT_REDIRECTED_NAME = ".redirected";
    private String inputType;
    private String outputOriginalType;
    private EnumSet<Casts> outputOriginalCasts;
    private String outputRedirectedType;
    private EnumSet<Casts> outputRedirectedCasts;

    public UpstreamListDissector() {
        this.inputType = null;
        this.outputOriginalType = null;
        this.outputOriginalCasts = null;
        this.outputRedirectedType = null;
        this.outputRedirectedCasts = null;
    }

    public UpstreamListDissector(String inputType, String outputOriginalType, EnumSet<Casts> outputOriginalCasts, String outputRedirectedType, EnumSet<Casts> outputRedirectedCasts) {
        this.inputType = inputType;
        this.outputOriginalType = outputOriginalType;
        this.outputOriginalCasts = outputOriginalCasts;
        this.outputRedirectedType = outputRedirectedType;
        this.outputRedirectedCasts = outputRedirectedCasts;
    }

    public void dissect(Parsable<?> parsable, String inputname) throws DissectionFailure {
        ParsedField field = parsable.getParsableField(this.inputType, inputname);
        String fieldValue = field.getValue().getString();
        String[] servers = fieldValue.split(", ");
        int serverNr = 0;
        for (String server : servers) {
            String[] parts = server.split(": ");
            if (parts.length == 1) {
                parsable.addDissection(inputname, this.outputOriginalType, serverNr + OUTPUT_ORIGINAL_NAME, parts[0].trim());
                parsable.addDissection(inputname, this.outputRedirectedType, serverNr + OUTPUT_REDIRECTED_NAME, parts[0].trim());
            } else {
                parsable.addDissection(inputname, this.outputOriginalType, serverNr + OUTPUT_ORIGINAL_NAME, parts[0].trim());
                parsable.addDissection(inputname, this.outputRedirectedType, serverNr + OUTPUT_REDIRECTED_NAME, parts[1].trim());
            }
            ++serverNr;
        }
    }

    public String getInputType() {
        return this.inputType;
    }

    public List<String> getPossibleOutput() {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < 32; ++i) {
            result.add(this.outputOriginalType + ":" + i + OUTPUT_ORIGINAL_NAME);
            result.add(this.outputRedirectedType + ":" + i + OUTPUT_REDIRECTED_NAME);
        }
        return result;
    }

    public EnumSet<Casts> prepareForDissect(String inputname, String outputname) {
        String name = this.extractFieldName(inputname, outputname);
        if (name.endsWith(OUTPUT_ORIGINAL_NAME)) {
            return this.outputOriginalCasts;
        }
        if (name.endsWith(OUTPUT_REDIRECTED_NAME)) {
            return this.outputRedirectedCasts;
        }
        return Casts.NO_CASTS;
    }

    protected void initializeNewInstance(Dissector newInstance) throws InvalidDissectorException {
        if (!(newInstance instanceof UpstreamListDissector)) {
            throw new InvalidDissectorException("Called UpstreamListDissector::initializeNewInstance with a dissector of class " + newInstance.getClass().getCanonicalName());
        }
        UpstreamListDissector dissector = (UpstreamListDissector)newInstance;
        dissector.inputType = this.inputType;
        dissector.outputOriginalType = this.outputOriginalType;
        dissector.outputOriginalCasts = this.outputOriginalCasts;
        dissector.outputRedirectedType = this.outputRedirectedType;
        dissector.outputRedirectedCasts = this.outputRedirectedCasts;
    }
}

