/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestCellComparator {
    byte[] row1 = Bytes.toBytes((String)"row1");
    byte[] row2 = Bytes.toBytes((String)"row2");
    byte[] row_1_0 = Bytes.toBytes((String)"row10");
    byte[] fam1 = Bytes.toBytes((String)"fam1");
    byte[] fam2 = Bytes.toBytes((String)"fam2");
    byte[] fam_1_2 = Bytes.toBytes((String)"fam12");
    byte[] qual1 = Bytes.toBytes((String)"qual1");
    byte[] qual2 = Bytes.toBytes((String)"qual2");
    byte[] val = Bytes.toBytes((String)"val");

    @Test
    public void testCompareCells() {
        KeyValue kv1 = new KeyValue(this.row1, this.fam1, this.qual1, this.val);
        KeyValue kv2 = new KeyValue(this.row2, this.fam1, this.qual1, this.val);
        Assert.assertTrue((CellComparator.compare((Cell)kv1, (Cell)kv2, (boolean)false) < 0 ? 1 : 0) != 0);
        kv1 = new KeyValue(this.row1, this.fam2, this.qual1, this.val);
        kv2 = new KeyValue(this.row1, this.fam1, this.qual1, this.val);
        Assert.assertTrue((CellComparator.compareFamilies((Cell)kv1, (Cell)kv2) > 0 ? 1 : 0) != 0);
        kv1 = new KeyValue(this.row1, this.fam1, this.qual1, 1L, this.val);
        kv2 = new KeyValue(this.row1, this.fam1, this.qual1, 2L, this.val);
        Assert.assertTrue((CellComparator.compare((Cell)kv1, (Cell)kv2, (boolean)false) > 0 ? 1 : 0) != 0);
        kv1 = new KeyValue(this.row1, this.fam1, this.qual1, 1L, KeyValue.Type.Put);
        kv2 = new KeyValue(this.row1, this.fam1, this.qual1, 1L, KeyValue.Type.Maximum);
        Assert.assertTrue((CellComparator.compare((Cell)kv1, (Cell)kv2, (boolean)false) > 0 ? 1 : 0) != 0);
        kv1 = new KeyValue(this.row1, this.fam1, this.qual1, 1L, KeyValue.Type.Put);
        kv2 = new KeyValue(this.row1, this.fam_1_2, this.qual1, 1L, KeyValue.Type.Maximum);
        Assert.assertTrue((CellComparator.compareCommonFamilyPrefix((Cell)kv1, (Cell)kv2, (int)4) < 0 ? 1 : 0) != 0);
        kv1 = new KeyValue(this.row1, this.fam1, this.qual1, 1L, KeyValue.Type.Put);
        kv2 = new KeyValue(this.row_1_0, this.fam_1_2, this.qual1, 1L, KeyValue.Type.Maximum);
        Assert.assertTrue((CellComparator.compareCommonRowPrefix((Cell)kv1, (Cell)kv2, (int)4) < 0 ? 1 : 0) != 0);
        kv1 = new KeyValue(this.row1, this.fam1, this.qual2, 1L, KeyValue.Type.Put);
        kv2 = new KeyValue(this.row1, this.fam1, this.qual1, 1L, KeyValue.Type.Maximum);
        Assert.assertTrue((CellComparator.compareCommonQualifierPrefix((Cell)kv1, (Cell)kv2, (int)4) > 0 ? 1 : 0) != 0);
        kv1 = new KeyValue(this.row1, this.fam1, this.qual1, 1L, KeyValue.Type.Put);
        kv2 = new KeyValue(this.row1, this.fam1, this.qual1, 1L, KeyValue.Type.Put);
        Assert.assertTrue((boolean)CellComparator.equals((Cell)kv1, (Cell)kv2));
    }

    @Test
    public void testGetShortMidpoint() {
        Cell right;
        Cell mid;
        KeyValue.KVComparator comparator = new KeyValue.KVComparator();
        Cell left = CellUtil.createCell((byte[])Bytes.toBytes((String)"a"), (byte[])Bytes.toBytes((String)"a"), (byte[])Bytes.toBytes((String)"a"));
        Assert.assertTrue((CellComparator.compare((Cell)left, (Cell)(mid = CellComparator.getMidpoint((KeyValue.KVComparator)comparator, (Cell)left, (Cell)(right = CellUtil.createCell((byte[])Bytes.toBytes((String)"a"), (byte[])Bytes.toBytes((String)"a"), (byte[])Bytes.toBytes((String)"a"))))), (boolean)true) <= 0 ? 1 : 0) != 0);
        Assert.assertTrue((CellComparator.compare((Cell)mid, (Cell)right, (boolean)true) <= 0 ? 1 : 0) != 0);
        left = CellUtil.createCell((byte[])Bytes.toBytes((String)"a"), (byte[])Bytes.toBytes((String)"a"), (byte[])Bytes.toBytes((String)"a"));
        right = CellUtil.createCell((byte[])Bytes.toBytes((String)"b"), (byte[])Bytes.toBytes((String)"a"), (byte[])Bytes.toBytes((String)"a"));
        mid = CellComparator.getMidpoint((KeyValue.KVComparator)comparator, (Cell)left, (Cell)right);
        Assert.assertTrue((CellComparator.compare((Cell)left, (Cell)mid, (boolean)true) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((CellComparator.compare((Cell)mid, (Cell)right, (boolean)true) <= 0 ? 1 : 0) != 0);
        left = CellUtil.createCell((byte[])Bytes.toBytes((String)"g"), (byte[])Bytes.toBytes((String)"a"), (byte[])Bytes.toBytes((String)"a"));
        right = CellUtil.createCell((byte[])Bytes.toBytes((String)"i"), (byte[])Bytes.toBytes((String)"a"), (byte[])Bytes.toBytes((String)"a"));
        mid = CellComparator.getMidpoint((KeyValue.KVComparator)comparator, (Cell)left, (Cell)right);
        Assert.assertTrue((CellComparator.compare((Cell)left, (Cell)mid, (boolean)true) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((CellComparator.compare((Cell)mid, (Cell)right, (boolean)true) <= 0 ? 1 : 0) != 0);
        left = CellUtil.createCell((byte[])Bytes.toBytes((String)"a"), (byte[])Bytes.toBytes((String)"a"), (byte[])Bytes.toBytes((String)"a"));
        right = CellUtil.createCell((byte[])Bytes.toBytes((String)"bbbbbbb"), (byte[])Bytes.toBytes((String)"a"), (byte[])Bytes.toBytes((String)"a"));
        mid = CellComparator.getMidpoint((KeyValue.KVComparator)comparator, (Cell)left, (Cell)right);
        Assert.assertTrue((CellComparator.compare((Cell)left, (Cell)mid, (boolean)true) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((CellComparator.compare((Cell)mid, (Cell)right, (boolean)true) < 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)mid.getRowLength());
        left = CellUtil.createCell((byte[])Bytes.toBytes((String)"a"), (byte[])Bytes.toBytes((String)"a"), (byte[])Bytes.toBytes((String)"a"));
        right = CellUtil.createCell((byte[])Bytes.toBytes((String)"a"), (byte[])Bytes.toBytes((String)"b"), (byte[])Bytes.toBytes((String)"a"));
        mid = CellComparator.getMidpoint((KeyValue.KVComparator)comparator, (Cell)left, (Cell)right);
        Assert.assertTrue((CellComparator.compare((Cell)left, (Cell)mid, (boolean)true) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((CellComparator.compare((Cell)mid, (Cell)right, (boolean)true) <= 0 ? 1 : 0) != 0);
        left = CellUtil.createCell((byte[])Bytes.toBytes((String)"a"), (byte[])Bytes.toBytes((String)"a"), (byte[])Bytes.toBytes((String)"a"));
        right = CellUtil.createCell((byte[])Bytes.toBytes((String)"a"), (byte[])Bytes.toBytes((String)"aaaaaaaa"), (byte[])Bytes.toBytes((String)"b"));
        mid = CellComparator.getMidpoint((KeyValue.KVComparator)comparator, (Cell)left, (Cell)right);
        Assert.assertTrue((CellComparator.compare((Cell)left, (Cell)mid, (boolean)true) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((CellComparator.compare((Cell)mid, (Cell)right, (boolean)true) < 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)mid.getFamilyLength());
        left = CellUtil.createCell((byte[])Bytes.toBytes((String)"a"), (byte[])Bytes.toBytes((String)"a"), (byte[])Bytes.toBytes((String)"a"));
        right = CellUtil.createCell((byte[])Bytes.toBytes((String)"a"), (byte[])Bytes.toBytes((String)"a"), (byte[])Bytes.toBytes((String)"aaaaaaaaa"));
        mid = CellComparator.getMidpoint((KeyValue.KVComparator)comparator, (Cell)left, (Cell)right);
        Assert.assertTrue((CellComparator.compare((Cell)left, (Cell)mid, (boolean)true) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((CellComparator.compare((Cell)mid, (Cell)right, (boolean)true) < 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)mid.getQualifierLength());
        left = CellUtil.createCell((byte[])Bytes.toBytes((String)"a"), (byte[])Bytes.toBytes((String)"a"), (byte[])Bytes.toBytes((String)"a"));
        right = CellUtil.createCell((byte[])Bytes.toBytes((String)"a"), (byte[])Bytes.toBytes((String)"a"), (byte[])Bytes.toBytes((String)"b"));
        mid = CellComparator.getMidpoint((KeyValue.KVComparator)comparator, (Cell)left, (Cell)right);
        Assert.assertTrue((CellComparator.compare((Cell)left, (Cell)mid, (boolean)true) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((CellComparator.compare((Cell)mid, (Cell)right, (boolean)true) <= 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)mid.getQualifierLength());
        left = CellUtil.createCell((byte[])Bytes.toBytes((String)"g"), (byte[])Bytes.toBytes((String)"a"), (byte[])Bytes.toBytes((String)"a"));
        right = CellUtil.createCell((byte[])Bytes.toBytes((String)"i"), (byte[])Bytes.toBytes((String)"a"), (byte[])Bytes.toBytes((String)"a"));
        mid = CellComparator.getMidpoint((KeyValue.KVComparator)new KeyValue.MetaComparator(), (Cell)left, (Cell)right);
        Assert.assertTrue((CellComparator.compare((Cell)left, (Cell)mid, (boolean)true) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((CellComparator.compare((Cell)mid, (Cell)right, (boolean)true) == 0 ? 1 : 0) != 0);
    }
}

