/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.type.base;

import org.apache.kerby.asn1.Asn1FieldInfo;
import org.apache.kerby.asn1.EnumType;
import org.apache.kerby.asn1.ExplicitField;
import org.apache.kerby.asn1.type.Asn1Integer;
import org.apache.kerby.asn1.type.Asn1OctetString;
import org.apache.kerby.asn1.type.Asn1Type;
import org.apache.kerby.kerberos.kerb.KrbErrorCode;
import org.apache.kerby.kerberos.kerb.type.KerberosString;
import org.apache.kerby.kerberos.kerb.type.KerberosTime;
import org.apache.kerby.kerberos.kerb.type.base.KrbMessage;
import org.apache.kerby.kerberos.kerb.type.base.KrbMessageType;
import org.apache.kerby.kerberos.kerb.type.base.PrincipalName;

public class KrbError
extends KrbMessage {
    static Asn1FieldInfo[] fieldInfos = new Asn1FieldInfo[]{new ExplicitField((EnumType)KrbErrorField.PVNO, Asn1Integer.class), new ExplicitField((EnumType)KrbErrorField.MSG_TYPE, Asn1Integer.class), new ExplicitField((EnumType)KrbErrorField.CTIME, KerberosTime.class), new ExplicitField((EnumType)KrbErrorField.CUSEC, Asn1Integer.class), new ExplicitField((EnumType)KrbErrorField.STIME, KerberosTime.class), new ExplicitField((EnumType)KrbErrorField.SUSEC, Asn1Integer.class), new ExplicitField((EnumType)KrbErrorField.ERROR_CODE, Asn1Integer.class), new ExplicitField((EnumType)KrbErrorField.CREALM, KerberosString.class), new ExplicitField((EnumType)KrbErrorField.CNAME, PrincipalName.class), new ExplicitField((EnumType)KrbErrorField.REALM, KerberosString.class), new ExplicitField((EnumType)KrbErrorField.SNAME, PrincipalName.class), new ExplicitField((EnumType)KrbErrorField.ETEXT, KerberosString.class), new ExplicitField((EnumType)KrbErrorField.EDATA, Asn1OctetString.class)};

    public KrbError() {
        super(KrbMessageType.KRB_ERROR, fieldInfos);
    }

    public KerberosTime getCtime() {
        return (KerberosTime)this.getFieldAs(KrbErrorField.CTIME, KerberosTime.class);
    }

    public void setCtime(KerberosTime ctime) {
        this.setFieldAs(KrbErrorField.CTIME, (Asn1Type)ctime);
    }

    public int getCusec() {
        return this.getFieldAsInt(KrbErrorField.CUSEC);
    }

    public void setCusec(int cusec) {
        this.setFieldAsInt(KrbErrorField.CUSEC, cusec);
    }

    public KerberosTime getStime() {
        return (KerberosTime)this.getFieldAs(KrbErrorField.STIME, KerberosTime.class);
    }

    public void setStime(KerberosTime stime) {
        this.setFieldAs(KrbErrorField.STIME, (Asn1Type)stime);
    }

    public int getSusec() {
        return this.getFieldAsInt(KrbErrorField.SUSEC);
    }

    public void setSusec(int susec) {
        this.setFieldAsInt(KrbErrorField.SUSEC, susec);
    }

    public KrbErrorCode getErrorCode() {
        return KrbErrorCode.fromValue(this.getFieldAsInt(KrbErrorField.ERROR_CODE));
    }

    public void setErrorCode(KrbErrorCode errorCode) {
        this.setField(KrbErrorField.ERROR_CODE, errorCode);
    }

    public String getCrealm() {
        return this.getFieldAsString(KrbErrorField.CREALM);
    }

    public void setCrealm(String realm) {
        this.setFieldAs(KrbErrorField.CREALM, (Asn1Type)new KerberosString(realm));
    }

    public PrincipalName getCname() {
        return (PrincipalName)this.getFieldAs(KrbErrorField.CNAME, PrincipalName.class);
    }

    public void setCname(PrincipalName sname) {
        this.setFieldAs(KrbErrorField.CNAME, (Asn1Type)sname);
    }

    public PrincipalName getSname() {
        return (PrincipalName)this.getFieldAs(KrbErrorField.SNAME, PrincipalName.class);
    }

    public void setSname(PrincipalName sname) {
        this.setFieldAs(KrbErrorField.SNAME, (Asn1Type)sname);
    }

    public String getRealm() {
        return this.getFieldAsString(KrbErrorField.REALM);
    }

    public void setRealm(String realm) {
        this.setFieldAs(KrbErrorField.REALM, (Asn1Type)new KerberosString(realm));
    }

    public String getEtext() {
        return this.getFieldAsString(KrbErrorField.ETEXT);
    }

    public void setEtext(String realm) {
        this.setFieldAs(KrbErrorField.ETEXT, (Asn1Type)new KerberosString(realm));
    }

    public byte[] getEdata() {
        return this.getFieldAsOctetBytes(KrbErrorField.EDATA);
    }

    public void setEdata(byte[] edata) {
        this.setFieldAsOctetBytes(KrbErrorField.EDATA, edata);
    }

    protected static enum KrbErrorField implements EnumType
    {
        PVNO,
        MSG_TYPE,
        CTIME,
        CUSEC,
        STIME,
        SUSEC,
        ERROR_CODE,
        CREALM,
        CNAME,
        REALM,
        SNAME,
        ETEXT,
        EDATA;


        public int getValue() {
            return this.ordinal();
        }

        public String getName() {
            return this.name();
        }
    }
}

