/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedOutputStream;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.StringTokenizer;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BufferedFSInputStream;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FSError;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FSLinkResolver;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.FsStatus;
import org.apache.hadoop.fs.HasFileDescriptor;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.Stat;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.nativeio.NativeIO;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class RawLocalFileSystem
extends FileSystem {
    static final URI NAME = URI.create("file:///");
    private Path workingDir = this.getInitialWorkingDirectory();
    private static boolean useDeprecatedFileStatus = true;

    @VisibleForTesting
    public static void useStatIfAvailable() {
        useDeprecatedFileStatus = !Stat.isAvailable();
    }

    private Path makeAbsolute(Path f) {
        if (f.isAbsolute()) {
            return f;
        }
        return new Path(this.workingDir, f);
    }

    public File pathToFile(Path path) {
        this.checkPath(path);
        if (!path.isAbsolute()) {
            path = new Path(this.getWorkingDirectory(), path);
        }
        return new File(path.toUri().getPath());
    }

    @Override
    public URI getUri() {
        return NAME;
    }

    @Override
    public void initialize(URI uri, Configuration conf) throws IOException {
        super.initialize(uri, conf);
        this.setConf(conf);
    }

    @Override
    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        if (!this.exists(f)) {
            throw new FileNotFoundException(f.toString());
        }
        return new FSDataInputStream(new BufferedFSInputStream(new LocalFSFileInputStream(f), bufferSize));
    }

    @Override
    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        if (!this.exists(f)) {
            throw new FileNotFoundException("File " + f + " not found");
        }
        if (this.getFileStatus(f).isDirectory()) {
            throw new IOException("Cannot append to a diretory (=" + f + " )");
        }
        return new FSDataOutputStream(new BufferedOutputStream(this.createOutputStreamWithMode(f, true, null), bufferSize), this.statistics);
    }

    @Override
    public FSDataOutputStream create(Path f, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return this.create(f, overwrite, true, bufferSize, replication, blockSize, progress, null);
    }

    private FSDataOutputStream create(Path f, boolean overwrite, boolean createParent, int bufferSize, short replication, long blockSize, Progressable progress, FsPermission permission) throws IOException {
        if (this.exists(f) && !overwrite) {
            throw new FileAlreadyExistsException("File already exists: " + f);
        }
        Path parent = f.getParent();
        if (parent != null && !this.mkdirs(parent)) {
            throw new IOException("Mkdirs failed to create " + parent.toString());
        }
        return new FSDataOutputStream(new BufferedOutputStream(this.createOutputStreamWithMode(f, false, permission), bufferSize), this.statistics);
    }

    protected OutputStream createOutputStream(Path f, boolean append) throws IOException {
        return this.createOutputStreamWithMode(f, append, null);
    }

    protected OutputStream createOutputStreamWithMode(Path f, boolean append, FsPermission permission) throws IOException {
        return new LocalFSFileOutputStream(f, append, permission);
    }

    @Override
    @Deprecated
    public FSDataOutputStream createNonRecursive(Path f, FsPermission permission, EnumSet<CreateFlag> flags, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        if (this.exists(f) && !flags.contains((Object)CreateFlag.OVERWRITE)) {
            throw new FileAlreadyExistsException("File already exists: " + f);
        }
        return new FSDataOutputStream(new BufferedOutputStream(this.createOutputStreamWithMode(f, false, permission), bufferSize), this.statistics);
    }

    @Override
    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        FSDataOutputStream out = this.create(f, overwrite, true, bufferSize, replication, blockSize, progress, permission);
        return out;
    }

    @Override
    public FSDataOutputStream createNonRecursive(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        FSDataOutputStream out = this.create(f, overwrite, false, bufferSize, replication, blockSize, progress, permission);
        return out;
    }

    @Override
    public boolean rename(Path src, Path dst) throws IOException {
        FileStatus sdst;
        File dstFile;
        File srcFile = this.pathToFile(src);
        if (srcFile.renameTo(dstFile = this.pathToFile(dst))) {
            return true;
        }
        if (this.exists(dst) && (sdst = this.getFileStatus(dst)).isDirectory() && dstFile.list().length == 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Deleting empty destination and renaming " + src + " to " + dst));
            }
            if (this.delete(dst, false) && srcFile.renameTo(dstFile)) {
                return true;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Falling through to a copy of " + src + " to " + dst));
        }
        return FileUtil.copy(this, src, this, dst, true, this.getConf());
    }

    @Override
    public boolean truncate(Path f, long newLength) throws IOException {
        FileStatus status = this.getFileStatus(f);
        if (status == null) {
            throw new FileNotFoundException("File " + f + " not found");
        }
        if (status.isDirectory()) {
            throw new IOException("Cannot truncate a directory (=" + f + ")");
        }
        long oldLength = status.getLen();
        if (newLength > oldLength) {
            throw new IllegalArgumentException("Cannot truncate to a larger file size. Current size: " + oldLength + ", truncate size: " + newLength + ".");
        }
        try (FileOutputStream out = new FileOutputStream(this.pathToFile(f), true);){
            try {
                out.getChannel().truncate(newLength);
            }
            catch (IOException e) {
                throw new FSError(e);
            }
        }
        return true;
    }

    @Override
    public boolean delete(Path p, boolean recursive) throws IOException {
        File f = this.pathToFile(p);
        if (!f.exists()) {
            return false;
        }
        if (f.isFile()) {
            return f.delete();
        }
        if (!recursive && f.isDirectory() && FileUtil.listFiles(f).length != 0) {
            throw new IOException("Directory " + f.toString() + " is not empty");
        }
        return FileUtil.fullyDelete(f);
    }

    @Override
    public FileStatus[] listStatus(Path f) throws IOException {
        File localf = this.pathToFile(f);
        if (!localf.exists()) {
            throw new FileNotFoundException("File " + f + " does not exist");
        }
        if (localf.isFile()) {
            if (!useDeprecatedFileStatus) {
                return new FileStatus[]{this.getFileStatus(f)};
            }
            return new FileStatus[]{new DeprecatedRawLocalFileStatus(localf, this.getDefaultBlockSize(f), this)};
        }
        String[] names = localf.list();
        if (names == null) {
            throw new FileNotFoundException(f + ": null file list");
        }
        FileStatus[] results = new FileStatus[names.length];
        int j = 0;
        for (int i = 0; i < names.length; ++i) {
            try {
                results[j] = this.getFileStatus(new Path(f, new Path(null, null, names[i])));
                ++j;
                continue;
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        if (j == names.length) {
            return results;
        }
        return Arrays.copyOf(results, j);
    }

    protected boolean mkOneDir(File p2f) throws IOException {
        return this.mkOneDirWithMode(new Path(p2f.getAbsolutePath()), p2f, null);
    }

    protected boolean mkOneDirWithMode(Path p, File p2f, FsPermission permission) throws IOException {
        if (permission == null) {
            return p2f.mkdir();
        }
        if (Shell.WINDOWS && NativeIO.isAvailable()) {
            try {
                NativeIO.Windows.createDirectoryWithMode(p2f, permission.toShort());
                return true;
            }
            catch (IOException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)String.format("NativeIO.createDirectoryWithMode error, path = %s, mode = %o", p2f, permission.toShort()), (Throwable)e);
                }
                return false;
            }
        }
        boolean b = p2f.mkdir();
        if (b) {
            this.setPermission(p, permission);
        }
        return b;
    }

    @Override
    public boolean mkdirs(Path f) throws IOException {
        return this.mkdirsWithOptionalPermission(f, null);
    }

    @Override
    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        return this.mkdirsWithOptionalPermission(f, permission);
    }

    private boolean mkdirsWithOptionalPermission(Path f, FsPermission permission) throws IOException {
        if (f == null) {
            throw new IllegalArgumentException("mkdirs path arg is null");
        }
        Path parent = f.getParent();
        File p2f = this.pathToFile(f);
        File parent2f = null;
        if (parent != null && (parent2f = this.pathToFile(parent)) != null && parent2f.exists() && !parent2f.isDirectory()) {
            throw new ParentNotDirectoryException("Parent path is not a directory: " + parent);
        }
        if (p2f.exists() && !p2f.isDirectory()) {
            throw new FileNotFoundException("Destination exists and is not a directory: " + p2f.getCanonicalPath());
        }
        return !(parent != null && !parent2f.exists() && !this.mkdirs(parent) || !this.mkOneDirWithMode(f, p2f, permission) && !p2f.isDirectory());
    }

    @Override
    public Path getHomeDirectory() {
        return this.makeQualified(new Path(System.getProperty("user.home")));
    }

    @Override
    public void setWorkingDirectory(Path newDir) {
        this.workingDir = this.makeAbsolute(newDir);
        this.checkPath(this.workingDir);
    }

    @Override
    public Path getWorkingDirectory() {
        return this.workingDir;
    }

    @Override
    protected Path getInitialWorkingDirectory() {
        return this.makeQualified(new Path(System.getProperty("user.dir")));
    }

    @Override
    public FsStatus getStatus(Path p) throws IOException {
        File partition = this.pathToFile(p == null ? new Path("/") : p);
        return new FsStatus(partition.getTotalSpace(), partition.getTotalSpace() - partition.getFreeSpace(), partition.getFreeSpace());
    }

    @Override
    public void moveFromLocalFile(Path src, Path dst) throws IOException {
        this.rename(src, dst);
    }

    @Override
    public Path startLocalOutput(Path fsOutputFile, Path tmpLocalFile) throws IOException {
        return fsOutputFile;
    }

    @Override
    public void completeLocalOutput(Path fsWorkingFile, Path tmpLocalFile) throws IOException {
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    public String toString() {
        return "LocalFS";
    }

    @Override
    public FileStatus getFileStatus(Path f) throws IOException {
        return this.getFileLinkStatusInternal(f, true);
    }

    @Deprecated
    private FileStatus deprecatedGetFileStatus(Path f) throws IOException {
        File path = this.pathToFile(f);
        if (path.exists()) {
            return new DeprecatedRawLocalFileStatus(this.pathToFile(f), this.getDefaultBlockSize(f), this);
        }
        throw new FileNotFoundException("File " + f + " does not exist");
    }

    @Override
    public void setOwner(Path p, String username, String groupname) throws IOException {
        FileUtil.setOwner(this.pathToFile(p), username, groupname);
    }

    @Override
    public void setPermission(Path p, FsPermission permission) throws IOException {
        if (NativeIO.isAvailable()) {
            NativeIO.POSIX.chmod(this.pathToFile(p).getCanonicalPath(), permission.toShort());
        } else {
            String perm = String.format("%05o", permission.toShort());
            Shell.execCommand(Shell.getSetPermissionCommand(perm, false, FileUtil.makeShellPath(this.pathToFile(p), true)));
        }
    }

    @Override
    public void setTimes(Path p, long mtime, long atime) throws IOException {
        try {
            BasicFileAttributeView view = Files.getFileAttributeView(this.pathToFile(p).toPath(), BasicFileAttributeView.class, new LinkOption[0]);
            FileTime fmtime = mtime >= 0L ? FileTime.fromMillis(mtime) : null;
            FileTime fatime = atime >= 0L ? FileTime.fromMillis(atime) : null;
            view.setTimes(fmtime, fatime, null);
        }
        catch (NoSuchFileException e) {
            throw new FileNotFoundException("File " + p + " does not exist");
        }
    }

    @Override
    public boolean supportsSymlinks() {
        return true;
    }

    @Override
    public void createSymlink(Path oldPath, Path newPath, boolean createParent) throws IOException {
        Path parentOfNewPath;
        if (!FileSystem.areSymlinksEnabled()) {
            throw new UnsupportedOperationException("Symlinks not supported");
        }
        if (oldPath == null) {
            throw new RuntimeException("Target cannot be null");
        }
        if (newPath == null) {
            throw new RuntimeException("Link cannot be null");
        }
        String target = this.pathToFile(oldPath).toString();
        String link = this.pathToFile(newPath).toString();
        if (createParent && (parentOfNewPath = newPath.getParent()) != null && !this.mkdirs(parentOfNewPath)) {
            throw new IOException("Mkdirs failed " + parentOfNewPath.toString());
        }
        if (NativeIO.isAvailable()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("NativeIO.symlink: " + target + " <- " + link));
            }
            NativeIO.POSIX.symlink(target, link);
        } else {
            FileUtil.symLink(target, link);
        }
    }

    @Override
    public FileStatus getFileLinkStatus(Path f) throws IOException {
        FileStatus fi = this.getFileLinkStatusInternal(f, false);
        if (fi.isSymlink()) {
            Path targetQual = FSLinkResolver.qualifySymlinkTarget(this.getUri(), fi.getPath(), fi.getSymlink());
            fi.setSymlink(targetQual);
        }
        return fi;
    }

    private FileStatus getFileLinkStatusInternal(Path f, boolean dereference) throws IOException {
        if (!useDeprecatedFileStatus) {
            return this.getNativeFileLinkStatus(f, dereference);
        }
        if (dereference) {
            return this.deprecatedGetFileStatus(f);
        }
        return this.deprecatedGetFileLinkStatusInternal(f);
    }

    @Deprecated
    private FileStatus deprecatedGetFileLinkStatusInternal(Path f) throws IOException {
        String target = FileUtil.readLink(new File(f.toString()));
        try {
            FileStatus fs = this.getFileStatus(f);
            if (target.isEmpty()) {
                return fs;
            }
            return new FileStatus(fs.getLen(), false, fs.getReplication(), fs.getBlockSize(), fs.getModificationTime(), fs.getAccessTime(), fs.getPermission(), fs.getOwner(), fs.getGroup(), new Path(target), f);
        }
        catch (FileNotFoundException e) {
            if (!target.isEmpty()) {
                return new FileStatus(0L, false, 0, 0L, 0L, 0L, FsPermission.getDefault(), "", "", new Path(target), f);
            }
            throw e;
        }
    }

    private FileStatus getNativeFileLinkStatus(Path f, boolean dereference) throws IOException {
        this.checkPath(f);
        Stat stat = new Stat(f, this.getDefaultBlockSize(f), dereference, this);
        FileStatus status = stat.getFileStatus();
        return status;
    }

    @Override
    public Path getLinkTarget(Path f) throws IOException {
        FileStatus fi = this.getFileLinkStatusInternal(f, false);
        return fi.getSymlink();
    }

    @Deprecated
    static class DeprecatedRawLocalFileStatus
    extends FileStatus {
        private boolean isPermissionLoaded() {
            return !super.getOwner().isEmpty();
        }

        private static long getLastAccessTime(File f) throws IOException {
            long accessTime;
            try {
                accessTime = Files.readAttributes(f.toPath(), BasicFileAttributes.class, new LinkOption[0]).lastAccessTime().toMillis();
            }
            catch (NoSuchFileException e) {
                throw new FileNotFoundException("File " + f + " does not exist");
            }
            return accessTime;
        }

        DeprecatedRawLocalFileStatus(File f, long defaultBlockSize, FileSystem fs) throws IOException {
            super(f.length(), f.isDirectory(), 1, defaultBlockSize, f.lastModified(), DeprecatedRawLocalFileStatus.getLastAccessTime(f), null, null, null, new Path(f.getPath()).makeQualified(fs.getUri(), fs.getWorkingDirectory()));
        }

        @Override
        public FsPermission getPermission() {
            if (!this.isPermissionLoaded()) {
                this.loadPermissionInfo();
            }
            return super.getPermission();
        }

        @Override
        public String getOwner() {
            if (!this.isPermissionLoaded()) {
                this.loadPermissionInfo();
            }
            return super.getOwner();
        }

        @Override
        public String getGroup() {
            if (!this.isPermissionLoaded()) {
                this.loadPermissionInfo();
            }
            return super.getGroup();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void loadPermissionInfo() {
            block12: {
                if (!Shell.WINDOWS && NativeIO.isAvailable()) {
                    this.loadNativePermissionInfo();
                } else {
                    IOException e = null;
                    try {
                        int i;
                        String output = FileUtil.execCommand(new File(this.getPath().toUri()), Shell.getGetPermissionCommand());
                        StringTokenizer t = new StringTokenizer(output, Shell.TOKEN_SEPARATOR_REGEX);
                        String permission = t.nextToken();
                        if (permission.length() > 10) {
                            permission = permission.substring(0, 10);
                        }
                        this.setPermission(FsPermission.valueOf(permission));
                        t.nextToken();
                        String owner = t.nextToken();
                        if (Shell.WINDOWS && (i = owner.indexOf(92)) != -1) {
                            owner = owner.substring(i + 1);
                        }
                        this.setOwner(owner);
                        this.setGroup(t.nextToken());
                    }
                    catch (Shell.ExitCodeException ioe) {
                        if (ioe.getExitCode() != 1) {
                            e = ioe;
                        }
                        this.setPermission(null);
                        this.setOwner(null);
                        this.setGroup(null);
                    }
                    catch (IOException ioe) {
                        e = ioe;
                    }
                    finally {
                        if (e == null) break block12;
                        throw new RuntimeException("Error while running command to get file permissions : " + StringUtils.stringifyException(e));
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void loadNativePermissionInfo() {
            if (NativeIO.isAvailable()) {
                FileDescriptor fd;
                String pstr = this.getPath().toUri().getPath();
                try {
                    fd = NativeIO.POSIX.open(pstr, 0, 0);
                }
                catch (IOException maybeDir) {
                    try {
                        fd = NativeIO.POSIX.open(pstr, 65536, 0);
                    }
                    catch (IOException e) {
                        if (FileSystem.LOG.isErrorEnabled()) {
                            FileSystem.LOG.error((Object)("Failed to fstat on: " + pstr), (Throwable)e);
                        }
                        throw new RuntimeException(pstr, e);
                    }
                }
                FileInputStream dummy = new FileInputStream(fd);
                try {
                    NativeIO.POSIX.Stat st = NativeIO.POSIX.getFstat(fd);
                    this.setPermission(new FsPermission((short)st.getMode()));
                    this.setOwner(st.getOwner());
                    this.setGroup(st.getGroup());
                }
                catch (IOException e) {
                    if (FileSystem.LOG.isInfoEnabled()) {
                        FileSystem.LOG.info((Object)"Native fstat failed.", (Throwable)e);
                    }
                }
                finally {
                    block19: {
                        try {
                            dummy.close();
                        }
                        catch (IOException e) {
                            if (!FileSystem.LOG.isInfoEnabled()) break block19;
                            FileSystem.LOG.info((Object)"Failed to close dummy descriptor.", (Throwable)e);
                        }
                    }
                }
            }
        }

        @Override
        public void write(DataOutput out) throws IOException {
            if (!this.isPermissionLoaded()) {
                this.loadPermissionInfo();
            }
            super.write(out);
        }
    }

    class LocalFSFileOutputStream
    extends OutputStream {
        private FileOutputStream fos;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private LocalFSFileOutputStream(Path f, boolean append, FsPermission permission) throws IOException {
            File file = RawLocalFileSystem.this.pathToFile(f);
            if (permission == null) {
                this.fos = new FileOutputStream(file, append);
                return;
            } else if (Shell.WINDOWS && NativeIO.isAvailable()) {
                this.fos = NativeIO.Windows.createFileOutputStreamWithMode(file, append, permission.toShort());
                return;
            } else {
                this.fos = new FileOutputStream(file, append);
                boolean success = false;
                try {
                    RawLocalFileSystem.this.setPermission(f, permission);
                    return;
                }
                catch (Throwable throwable) {
                    if (success) throw throwable;
                    IOUtils.cleanup(FileSystem.LOG, this.fos);
                    throw throwable;
                }
            }
        }

        @Override
        public void close() throws IOException {
            this.fos.close();
        }

        @Override
        public void flush() throws IOException {
            this.fos.flush();
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            try {
                this.fos.write(b, off, len);
            }
            catch (IOException e) {
                throw new FSError(e);
            }
        }

        @Override
        public void write(int b) throws IOException {
            try {
                this.fos.write(b);
            }
            catch (IOException e) {
                throw new FSError(e);
            }
        }
    }

    class LocalFSFileInputStream
    extends FSInputStream
    implements HasFileDescriptor {
        private FileInputStream fis;
        private long position;

        public LocalFSFileInputStream(Path f) throws IOException {
            this.fis = new FileInputStream(RawLocalFileSystem.this.pathToFile(f));
        }

        @Override
        public void seek(long pos) throws IOException {
            if (pos < 0L) {
                throw new EOFException("Cannot seek to a negative offset");
            }
            this.fis.getChannel().position(pos);
            this.position = pos;
        }

        @Override
        public long getPos() throws IOException {
            return this.position;
        }

        @Override
        public boolean seekToNewSource(long targetPos) throws IOException {
            return false;
        }

        @Override
        public int available() throws IOException {
            return this.fis.available();
        }

        @Override
        public void close() throws IOException {
            this.fis.close();
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        @Override
        public int read() throws IOException {
            try {
                int value = this.fis.read();
                if (value >= 0) {
                    ++this.position;
                    RawLocalFileSystem.this.statistics.incrementBytesRead(1L);
                }
                return value;
            }
            catch (IOException e) {
                throw new FSError(e);
            }
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            try {
                int value = this.fis.read(b, off, len);
                if (value > 0) {
                    this.position += (long)value;
                    RawLocalFileSystem.this.statistics.incrementBytesRead(value);
                }
                return value;
            }
            catch (IOException e) {
                throw new FSError(e);
            }
        }

        @Override
        public int read(long position, byte[] b, int off, int len) throws IOException {
            ByteBuffer bb = ByteBuffer.wrap(b, off, len);
            try {
                int value = this.fis.getChannel().read(bb, position);
                if (value > 0) {
                    RawLocalFileSystem.this.statistics.incrementBytesRead(value);
                }
                return value;
            }
            catch (IOException e) {
                throw new FSError(e);
            }
        }

        @Override
        public long skip(long n) throws IOException {
            long value = this.fis.skip(n);
            if (value > 0L) {
                this.position += value;
            }
            return value;
        }

        @Override
        public FileDescriptor getFileDescriptor() throws IOException {
            return this.fis.getFD();
        }
    }
}

