/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.crypto.CryptoProtocolVersion;
import org.apache.hadoop.fs.CanSetDropBehind;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSOutputSummer;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileEncryptionInfo;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.StreamCapabilities;
import org.apache.hadoop.fs.Syncable;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSClientFaultInjector;
import org.apache.hadoop.hdfs.DFSPacket;
import org.apache.hadoop.hdfs.UnknownCryptoProtocolVersionException;
import org.apache.hadoop.hdfs.client.HdfsDataOutputStream;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.DSQuotaExceededException;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.NSQuotaExceededException;
import org.apache.hadoop.hdfs.protocol.SnapshotAccessControlException;
import org.apache.hadoop.hdfs.protocol.UnresolvedPathException;
import org.apache.hadoop.hdfs.protocol.datatransfer.BlockConstructionStage;
import org.apache.hadoop.hdfs.protocol.datatransfer.DataTransferProtoUtil;
import org.apache.hadoop.hdfs.protocol.datatransfer.DataTransferProtocol;
import org.apache.hadoop.hdfs.protocol.datatransfer.IOStreamPair;
import org.apache.hadoop.hdfs.protocol.datatransfer.InvalidEncryptionKeyException;
import org.apache.hadoop.hdfs.protocol.datatransfer.PacketHeader;
import org.apache.hadoop.hdfs.protocol.datatransfer.PipelineAck;
import org.apache.hadoop.hdfs.protocol.datatransfer.Sender;
import org.apache.hadoop.hdfs.protocol.proto.DataTransferProtos;
import org.apache.hadoop.hdfs.protocolPB.PBHelper;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockStoragePolicySuite;
import org.apache.hadoop.hdfs.server.datanode.CachingStrategy;
import org.apache.hadoop.hdfs.server.namenode.NotReplicatedYetException;
import org.apache.hadoop.hdfs.server.namenode.RetryStartFileException;
import org.apache.hadoop.hdfs.server.namenode.SafeModeException;
import org.apache.hadoop.hdfs.util.ByteArrayManager;
import org.apache.hadoop.io.EnumSetWritable;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.Daemon;
import org.apache.hadoop.util.DataChecksum;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Time;
import org.apache.htrace.NullScope;
import org.apache.htrace.Sampler;
import org.apache.htrace.Span;
import org.apache.htrace.Trace;
import org.apache.htrace.TraceInfo;
import org.apache.htrace.TraceScope;

@InterfaceAudience.Private
public class DFSOutputStream
extends FSOutputSummer
implements Syncable,
CanSetDropBehind,
StreamCapabilities {
    private final long dfsclientSlowLogThresholdMs;
    @VisibleForTesting
    static final int CREATE_RETRY_COUNT = 10;
    @VisibleForTesting
    static CryptoProtocolVersion[] SUPPORTED_CRYPTO_VERSIONS = CryptoProtocolVersion.supported();
    private final DFSClient dfsClient;
    private final ByteArrayManager byteArrayManager;
    private Socket s;
    private volatile boolean closed = false;
    private String src;
    private final long fileId;
    private final long blockSize;
    private final DataChecksum checksum4WriteBlock;
    private final int bytesPerChecksum;
    private final LinkedList<DFSPacket> dataQueue = new LinkedList();
    private final LinkedList<DFSPacket> ackQueue = new LinkedList();
    private DFSPacket currentPacket = null;
    private DataStreamer streamer;
    private long currentSeqno = 0L;
    private long lastQueuedSeqno = -1L;
    private long lastAckedSeqno = -1L;
    private long bytesCurBlock = 0L;
    private int packetSize = 0;
    private int chunksPerPacket = 0;
    private final AtomicReference<IOException> lastException = new AtomicReference();
    private long artificialSlowdown = 0L;
    private long lastFlushOffset = 0L;
    private final AtomicBoolean persistBlocks = new AtomicBoolean(false);
    private volatile boolean appendChunk = false;
    private long initialFileSize = 0L;
    private final Progressable progress;
    private final short blockReplication;
    private boolean shouldSyncBlock = false;
    private final AtomicReference<CachingStrategy> cachingStrategy;
    private boolean failPacket = false;
    private FileEncryptionInfo fileEncryptionInfo;
    private static final BlockStoragePolicySuite blockStoragePolicySuite = BlockStoragePolicySuite.createDefaultSuite();

    private DFSPacket createPacket(int packetSize, int chunksPerPkt, long offsetInBlock, long seqno, boolean lastPacketInBlock) throws InterruptedIOException {
        byte[] buf;
        int bufferSize = PacketHeader.PKT_MAX_HEADER_LEN + packetSize;
        try {
            buf = this.byteArrayManager.newByteArray(bufferSize);
        }
        catch (InterruptedException ie) {
            InterruptedIOException iioe = new InterruptedIOException("seqno=" + seqno);
            iioe.initCause(ie);
            throw iioe;
        }
        return new DFSPacket(buf, chunksPerPkt, offsetInBlock, seqno, this.getChecksumSize(), lastPacketInBlock);
    }

    private DFSPacket createHeartbeatPacket() throws InterruptedIOException {
        byte[] buf = new byte[PacketHeader.PKT_MAX_HEADER_LEN];
        return new DFSPacket(buf, 0, 0L, -1L, this.getChecksumSize(), false);
    }

    static Socket createSocketForPipeline(DatanodeInfo first, int length, DFSClient client) throws IOException {
        String dnAddr = first.getXferAddr(client.getConf().connectToDnViaHostname);
        if (DFSClient.LOG.isDebugEnabled()) {
            DFSClient.LOG.debug((Object)("Connecting to datanode " + dnAddr));
        }
        InetSocketAddress isa = NetUtils.createSocketAddr((String)dnAddr);
        Socket sock = client.socketFactory.createSocket();
        int timeout = client.getDatanodeReadTimeout(length);
        NetUtils.connect((Socket)sock, (SocketAddress)isa, (SocketAddress)client.getRandomLocalInterfaceAddr(), (int)client.getConf().socketTimeout);
        sock.setSoTimeout(timeout);
        sock.setSendBufferSize(131072);
        if (DFSClient.LOG.isDebugEnabled()) {
            DFSClient.LOG.debug((Object)("Send buf size " + sock.getSendBufferSize()));
        }
        return sock;
    }

    protected void checkClosed() throws IOException {
        if (this.isClosed()) {
            IOException e = this.lastException.get();
            throw e != null ? e : new ClosedChannelException();
        }
    }

    @VisibleForTesting
    public synchronized DatanodeInfo[] getPipeline() {
        if (this.streamer == null) {
            return null;
        }
        DatanodeInfo[] currentNodes = this.streamer.getNodes();
        if (currentNodes == null) {
            return null;
        }
        DatanodeInfo[] value = new DatanodeInfo[currentNodes.length];
        for (int i = 0; i < currentNodes.length; ++i) {
            value[i] = currentNodes[i];
        }
        return value;
    }

    private static DataChecksum getChecksum4Compute(DataChecksum checksum, HdfsFileStatus stat) {
        if (DFSOutputStream.isLazyPersist(stat) && stat.getReplication() == 1) {
            return DataChecksum.newDataChecksum((DataChecksum.Type)DataChecksum.Type.NULL, (int)checksum.getBytesPerChecksum());
        }
        return checksum;
    }

    private DFSOutputStream(DFSClient dfsClient, String src, Progressable progress, HdfsFileStatus stat, DataChecksum checksum) throws IOException {
        super(DFSOutputStream.getChecksum4Compute(checksum, stat));
        this.dfsClient = dfsClient;
        this.src = src;
        this.fileId = stat.getFileId();
        this.blockSize = stat.getBlockSize();
        this.blockReplication = stat.getReplication();
        this.fileEncryptionInfo = stat.getFileEncryptionInfo();
        this.progress = progress;
        this.cachingStrategy = new AtomicReference<CachingStrategy>(dfsClient.getDefaultWriteCachingStrategy());
        if (progress != null && DFSClient.LOG.isDebugEnabled()) {
            DFSClient.LOG.debug((Object)("Set non-null progress callback on DFSOutputStream " + src));
        }
        this.bytesPerChecksum = checksum.getBytesPerChecksum();
        if (this.bytesPerChecksum <= 0) {
            throw new HadoopIllegalArgumentException("Invalid value: bytesPerChecksum = " + this.bytesPerChecksum + " <= 0");
        }
        if (this.blockSize % (long)this.bytesPerChecksum != 0L) {
            throw new HadoopIllegalArgumentException("Invalid values: dfs.bytes-per-checksum (=" + this.bytesPerChecksum + ") must divide block size (=" + this.blockSize + ").");
        }
        this.checksum4WriteBlock = checksum;
        this.dfsclientSlowLogThresholdMs = dfsClient.getConf().dfsclientSlowIoWarningThresholdMs;
        this.byteArrayManager = dfsClient.getClientContext().getByteArrayManager();
    }

    private DFSOutputStream(DFSClient dfsClient, String src, HdfsFileStatus stat, EnumSet<CreateFlag> flag, Progressable progress, DataChecksum checksum, String[] favoredNodes) throws IOException {
        this(dfsClient, src, progress, stat, checksum);
        this.shouldSyncBlock = flag.contains(CreateFlag.SYNC_BLOCK);
        this.computePacketChunkSize(dfsClient.getConf().writePacketSize, this.bytesPerChecksum);
        this.streamer = new DataStreamer(stat, null);
        if (favoredNodes != null && favoredNodes.length != 0) {
            this.streamer.setFavoredNodes(favoredNodes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DFSOutputStream newStreamForCreate(DFSClient dfsClient, String src, FsPermission masked, EnumSet<CreateFlag> flag, boolean createParent, short replication, long blockSize, Progressable progress, int buffersize, DataChecksum checksum, String[] favoredNodes) throws IOException {
        try (TraceScope scope = dfsClient.getPathTraceScope("newStreamForCreate", src);){
            HdfsFileStatus stat = null;
            boolean shouldRetry = true;
            int retryCount = 10;
            while (shouldRetry) {
                shouldRetry = false;
                try {
                    stat = dfsClient.namenode.create(src, masked, dfsClient.clientName, (EnumSetWritable<CreateFlag>)new EnumSetWritable(flag), createParent, replication, blockSize, SUPPORTED_CRYPTO_VERSIONS);
                    break;
                }
                catch (RemoteException re) {
                    IOException e = re.unwrapRemoteException(new Class[]{AccessControlException.class, DSQuotaExceededException.class, FileAlreadyExistsException.class, FileNotFoundException.class, ParentNotDirectoryException.class, NSQuotaExceededException.class, RetryStartFileException.class, SafeModeException.class, UnresolvedPathException.class, SnapshotAccessControlException.class, UnknownCryptoProtocolVersionException.class});
                    if (e instanceof RetryStartFileException) {
                        if (retryCount > 0) {
                            shouldRetry = true;
                            --retryCount;
                            continue;
                        }
                        throw new IOException("Too many retries because of encryption zone operations", e);
                    }
                    throw e;
                }
            }
            Preconditions.checkNotNull(stat, (Object)"HdfsFileStatus should not be null!");
            DFSOutputStream out = new DFSOutputStream(dfsClient, src, stat, flag, progress, checksum, favoredNodes);
            out.start();
            DFSOutputStream dFSOutputStream = out;
            return dFSOutputStream;
        }
    }

    private DFSOutputStream(DFSClient dfsClient, String src, EnumSet<CreateFlag> flags, Progressable progress, LocatedBlock lastBlock, HdfsFileStatus stat, DataChecksum checksum) throws IOException {
        this(dfsClient, src, progress, stat, checksum);
        this.initialFileSize = stat.getLen();
        this.shouldSyncBlock = flags.contains(CreateFlag.SYNC_BLOCK);
        boolean toNewBlock = flags.contains(CreateFlag.NEW_BLOCK);
        if (!toNewBlock && lastBlock != null) {
            this.bytesCurBlock = lastBlock.getBlockSize();
            this.streamer = new DataStreamer(lastBlock, stat, this.bytesPerChecksum);
        } else {
            this.computePacketChunkSize(dfsClient.getConf().writePacketSize, this.bytesPerChecksum);
            this.streamer = new DataStreamer(stat, lastBlock != null ? lastBlock.getBlock() : null);
        }
        this.fileEncryptionInfo = stat.getFileEncryptionInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DFSOutputStream newStreamForAppend(DFSClient dfsClient, String src, EnumSet<CreateFlag> flags, int bufferSize, Progressable progress, LocatedBlock lastBlock, HdfsFileStatus stat, DataChecksum checksum, String[] favoredNodes) throws IOException {
        try (TraceScope scope = dfsClient.getPathTraceScope("newStreamForAppend", src);){
            DFSOutputStream out = new DFSOutputStream(dfsClient, src, flags, progress, lastBlock, stat, checksum);
            if (favoredNodes != null && favoredNodes.length != 0) {
                out.streamer.setFavoredNodes(favoredNodes);
            }
            out.start();
            DFSOutputStream dFSOutputStream = out;
            return dFSOutputStream;
        }
    }

    private static boolean isLazyPersist(HdfsFileStatus stat) {
        BlockStoragePolicy p = blockStoragePolicySuite.getPolicy("LAZY_PERSIST");
        return p != null && stat.getStoragePolicy() == p.getId();
    }

    private void computePacketChunkSize(int psize, int csize) {
        int bodySize = psize - PacketHeader.PKT_MAX_HEADER_LEN;
        int chunkSize = csize + this.getChecksumSize();
        this.chunksPerPacket = Math.max(bodySize / chunkSize, 1);
        this.packetSize = chunkSize * this.chunksPerPacket;
        if (DFSClient.LOG.isDebugEnabled()) {
            DFSClient.LOG.debug((Object)("computePacketChunkSize: src=" + this.src + ", chunkSize=" + chunkSize + ", chunksPerPacket=" + this.chunksPerPacket + ", packetSize=" + this.packetSize));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueCurrentPacket() {
        LinkedList<DFSPacket> linkedList = this.dataQueue;
        synchronized (linkedList) {
            if (this.currentPacket == null) {
                return;
            }
            this.currentPacket.addTraceParent(Trace.currentSpan());
            this.dataQueue.addLast(this.currentPacket);
            this.lastQueuedSeqno = this.currentPacket.getSeqno();
            if (DFSClient.LOG.isDebugEnabled()) {
                DFSClient.LOG.debug((Object)("Queued packet " + this.currentPacket.getSeqno()));
            }
            this.currentPacket = null;
            this.dataQueue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitAndQueueCurrentPacket() throws IOException {
        LinkedList<DFSPacket> linkedList = this.dataQueue;
        synchronized (linkedList) {
            try {
                Span span;
                boolean firstWait = true;
                try {
                    while (!this.isClosed() && this.dataQueue.size() + this.ackQueue.size() > this.dfsClient.getConf().writeMaxPackets) {
                        if (firstWait) {
                            span = Trace.currentSpan();
                            if (span != null) {
                                span.addTimelineAnnotation("dataQueue.wait");
                            }
                            firstWait = false;
                        }
                        try {
                            this.dataQueue.wait();
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            break;
                        }
                    }
                }
                finally {
                    span = Trace.currentSpan();
                    if (span != null && !firstWait) {
                        span.addTimelineAnnotation("end.wait");
                    }
                }
                this.checkClosed();
                this.queueCurrentPacket();
            }
            catch (ClosedChannelException closedChannelException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void writeChunk(byte[] b, int offset, int len, byte[] checksum, int ckoff, int cklen) throws IOException {
        try (TraceScope scope = this.dfsClient.getPathTraceScope("DFSOutputStream#writeChunk", this.src);){
            this.writeChunkImpl(b, offset, len, checksum, ckoff, cklen);
        }
    }

    private synchronized void writeChunkImpl(byte[] b, int offset, int len, byte[] checksum, int ckoff, int cklen) throws IOException {
        this.dfsClient.checkOpen();
        this.checkClosed();
        if (len > this.bytesPerChecksum) {
            throw new IOException("writeChunk() buffer size is " + len + " is larger than supported  bytesPerChecksum " + this.bytesPerChecksum);
        }
        if (cklen != 0 && cklen != this.getChecksumSize()) {
            throw new IOException("writeChunk() checksum size is supposed to be " + this.getChecksumSize() + " but found to be " + cklen);
        }
        if (this.currentPacket == null) {
            this.currentPacket = this.createPacket(this.packetSize, this.chunksPerPacket, this.bytesCurBlock, this.currentSeqno++, false);
            if (DFSClient.LOG.isDebugEnabled()) {
                DFSClient.LOG.debug((Object)("DFSClient writeChunk allocating new packet seqno=" + this.currentPacket.getSeqno() + ", src=" + this.src + ", packetSize=" + this.packetSize + ", chunksPerPacket=" + this.chunksPerPacket + ", bytesCurBlock=" + this.bytesCurBlock));
            }
        }
        this.currentPacket.writeChecksum(checksum, ckoff, cklen);
        this.currentPacket.writeData(b, offset, len);
        this.currentPacket.incNumChunks();
        this.bytesCurBlock += (long)len;
        if (this.currentPacket.getNumChunks() == this.currentPacket.getMaxChunks() || this.bytesCurBlock == this.blockSize) {
            if (DFSClient.LOG.isDebugEnabled()) {
                DFSClient.LOG.debug((Object)("DFSClient writeChunk packet full seqno=" + this.currentPacket.getSeqno() + ", src=" + this.src + ", bytesCurBlock=" + this.bytesCurBlock + ", blockSize=" + this.blockSize + ", appendChunk=" + this.appendChunk));
            }
            this.waitAndQueueCurrentPacket();
            if (this.appendChunk && this.bytesCurBlock % (long)this.bytesPerChecksum == 0L) {
                this.appendChunk = false;
                this.resetChecksumBufSize();
            }
            if (!this.appendChunk) {
                int psize = Math.min((int)(this.blockSize - this.bytesCurBlock), this.dfsClient.getConf().writePacketSize);
                this.computePacketChunkSize(psize, this.bytesPerChecksum);
            }
            if (this.bytesCurBlock == this.blockSize) {
                this.currentPacket = this.createPacket(0, 0, this.bytesCurBlock, this.currentSeqno++, true);
                this.currentPacket.setSyncBlock(this.shouldSyncBlock);
                this.waitAndQueueCurrentPacket();
                this.bytesCurBlock = 0L;
                this.lastFlushOffset = 0L;
            }
        }
    }

    @Deprecated
    public void sync() throws IOException {
        this.hflush();
    }

    public void hflush() throws IOException {
        try (TraceScope scope = this.dfsClient.getPathTraceScope("hflush", this.src);){
            this.flushOrSync(false, EnumSet.noneOf(HdfsDataOutputStream.SyncFlag.class));
        }
    }

    public void hsync() throws IOException {
        try (TraceScope scope = this.dfsClient.getPathTraceScope("hsync", this.src);){
            this.flushOrSync(true, EnumSet.noneOf(HdfsDataOutputStream.SyncFlag.class));
        }
    }

    public void hsync(EnumSet<HdfsDataOutputStream.SyncFlag> syncFlags) throws IOException {
        try (TraceScope scope = this.dfsClient.getPathTraceScope("hsync", this.src);){
            this.flushOrSync(true, syncFlags);
        }
    }

    public boolean hasCapability(String capability) {
        switch (StringUtils.toLowerCase((String)capability)) {
            case "hsync": 
            case "hflush": {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushOrSync(boolean isSync, EnumSet<HdfsDataOutputStream.SyncFlag> syncFlags) throws IOException {
        this.dfsClient.checkOpen();
        this.checkClosed();
        try {
            long toWaitFor;
            long lastBlockLength = -1L;
            boolean updateLength = syncFlags.contains((Object)HdfsDataOutputStream.SyncFlag.UPDATE_LENGTH);
            boolean endBlock = syncFlags.contains((Object)HdfsDataOutputStream.SyncFlag.END_BLOCK);
            DFSOutputStream dFSOutputStream = this;
            synchronized (dFSOutputStream) {
                int numKept = this.flushBuffer(!endBlock, true);
                if (DFSClient.LOG.isDebugEnabled()) {
                    DFSClient.LOG.debug((Object)("DFSClient flush(): bytesCurBlock=" + this.bytesCurBlock + " lastFlushOffset=" + this.lastFlushOffset + " createNewBlock=" + endBlock));
                }
                if (this.lastFlushOffset != this.bytesCurBlock) {
                    assert (this.bytesCurBlock > this.lastFlushOffset);
                    this.lastFlushOffset = this.bytesCurBlock;
                    if (isSync && this.currentPacket == null && !endBlock) {
                        this.currentPacket = this.createPacket(this.packetSize, this.chunksPerPacket, this.bytesCurBlock, this.currentSeqno++, false);
                    }
                } else if (isSync && this.bytesCurBlock > 0L && !endBlock) {
                    this.currentPacket = this.createPacket(this.packetSize, this.chunksPerPacket, this.bytesCurBlock, this.currentSeqno++, false);
                } else if (this.currentPacket != null) {
                    this.currentPacket.releaseBuffer(this.byteArrayManager);
                    this.currentPacket = null;
                }
                if (this.currentPacket != null) {
                    this.currentPacket.setSyncBlock(isSync);
                    this.waitAndQueueCurrentPacket();
                }
                if (endBlock && this.bytesCurBlock > 0L) {
                    this.currentPacket = this.createPacket(0, 0, this.bytesCurBlock, this.currentSeqno++, true);
                    this.currentPacket.setSyncBlock(this.shouldSyncBlock || isSync);
                    this.waitAndQueueCurrentPacket();
                    this.bytesCurBlock = 0L;
                    this.lastFlushOffset = 0L;
                } else {
                    this.bytesCurBlock -= (long)numKept;
                }
                toWaitFor = this.lastQueuedSeqno;
            }
            this.waitForAckedSeqno(toWaitFor);
            if (updateLength || this.persistBlocks.get()) {
                dFSOutputStream = this;
                synchronized (dFSOutputStream) {
                    if (this.streamer != null && this.streamer.block != null) {
                        lastBlockLength = this.streamer.block.getNumBytes();
                    }
                }
            }
            if (this.persistBlocks.getAndSet(false) || updateLength) {
                try {
                    this.dfsClient.namenode.fsync(this.src, this.fileId, this.dfsClient.clientName, lastBlockLength);
                }
                catch (IOException ioe) {
                    DFSClient.LOG.warn((Object)("Unable to persist blocks in hflush for " + this.src), (Throwable)ioe);
                    this.checkClosed();
                    throw ioe;
                }
            }
            dFSOutputStream = this;
            synchronized (dFSOutputStream) {
                if (this.streamer != null) {
                    this.streamer.setHflush();
                }
            }
        }
        catch (InterruptedIOException interrupt) {
            throw interrupt;
        }
        catch (IOException e) {
            DFSClient.LOG.warn((Object)"Error while syncing", (Throwable)e);
            DFSOutputStream dFSOutputStream = this;
            synchronized (dFSOutputStream) {
                if (!this.isClosed()) {
                    this.lastException.set(new IOException("IOException flush: " + e));
                    this.closeThreads(true);
                }
            }
            throw e;
        }
    }

    @Deprecated
    public synchronized int getNumCurrentReplicas() throws IOException {
        return this.getCurrentBlockReplication();
    }

    public synchronized int getCurrentBlockReplication() throws IOException {
        this.dfsClient.checkOpen();
        this.checkClosed();
        if (this.streamer == null) {
            return this.blockReplication;
        }
        DatanodeInfo[] currentNodes = this.streamer.getNodes();
        if (currentNodes == null) {
            return this.blockReplication;
        }
        return currentNodes.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushInternal() throws IOException {
        long toWaitFor;
        DFSOutputStream dFSOutputStream = this;
        synchronized (dFSOutputStream) {
            this.dfsClient.checkOpen();
            this.checkClosed();
            this.queueCurrentPacket();
            toWaitFor = this.lastQueuedSeqno;
        }
        this.waitForAckedSeqno(toWaitFor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForAckedSeqno(long seqno) throws IOException {
        try (TraceScope scope = Trace.startSpan((String)"waitForAckedSeqno", (Sampler)Sampler.NEVER);){
            if (DFSClient.LOG.isDebugEnabled()) {
                DFSClient.LOG.debug((Object)("Waiting for ack for: " + seqno));
            }
            long begin = Time.monotonicNow();
            try {
                LinkedList<DFSPacket> linkedList = this.dataQueue;
                synchronized (linkedList) {
                    while (!this.isClosed()) {
                        this.checkClosed();
                        if (this.lastAckedSeqno >= seqno) break;
                        try {
                            this.dataQueue.wait(1000L);
                        }
                        catch (InterruptedException ie) {
                            throw new InterruptedIOException("Interrupted while waiting for data to be acknowledged by pipeline");
                        }
                    }
                }
                this.checkClosed();
            }
            catch (ClosedChannelException closedChannelException) {
                // empty catch block
            }
            long duration = Time.monotonicNow() - begin;
            if (duration > this.dfsclientSlowLogThresholdMs) {
                DFSClient.LOG.warn((Object)("Slow waitForAckedSeqno took " + duration + "ms (threshold=" + this.dfsclientSlowLogThresholdMs + "ms)"));
            }
        }
    }

    private synchronized void start() {
        this.streamer.start();
    }

    synchronized void abort() throws IOException {
        if (this.isClosed()) {
            return;
        }
        this.streamer.setLastException(new IOException("Lease timeout of " + this.dfsClient.getHdfsTimeout() / 1000 + " seconds expired."));
        this.closeThreads(true);
        this.dfsClient.endFileLease(this.fileId);
    }

    boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setClosed() {
        this.closed = true;
        LinkedList<DFSPacket> linkedList = this.dataQueue;
        synchronized (linkedList) {
            DFSOutputStream.releaseBuffer(this.dataQueue, this.byteArrayManager);
            DFSOutputStream.releaseBuffer(this.ackQueue, this.byteArrayManager);
        }
    }

    private static void releaseBuffer(List<DFSPacket> packets, ByteArrayManager bam) {
        for (DFSPacket p : packets) {
            p.releaseBuffer(bam);
        }
        packets.clear();
    }

    private void closeThreads(boolean force) throws IOException {
        try {
            this.streamer.close(force);
            this.streamer.join();
            if (this.s != null) {
                this.s.close();
            }
        }
        catch (InterruptedException e) {
            throw new IOException("Failed to shutdown streamer");
        }
        finally {
            this.streamer = null;
            this.s = null;
            this.setClosed();
        }
    }

    public synchronized void close() throws IOException {
        try (TraceScope scope = this.dfsClient.getPathTraceScope("DFSOutputStream#close", this.src);){
            this.closeImpl();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void closeImpl() throws IOException {
        if (this.isClosed()) {
            IOException e = this.lastException.getAndSet(null);
            if (e == null) {
                return;
            }
            throw e;
        }
        try {
            this.flushBuffer();
            if (this.currentPacket != null) {
                this.waitAndQueueCurrentPacket();
            }
            if (this.bytesCurBlock != 0L) {
                this.currentPacket = this.createPacket(0, 0, this.bytesCurBlock, this.currentSeqno++, true);
                this.currentPacket.setSyncBlock(this.shouldSyncBlock);
            }
            this.flushInternal();
            ExtendedBlock lastBlock = this.streamer.getBlock();
            this.closeThreads(false);
            try (TraceScope scope = Trace.startSpan((String)"completeFile", (Sampler)Sampler.NEVER);){
                this.completeFile(lastBlock);
            }
            this.dfsClient.endFileLease(this.fileId);
        }
        catch (ClosedChannelException closedChannelException) {
        }
        finally {
            this.setClosed();
        }
    }

    private void completeFile(ExtendedBlock last) throws IOException {
        long localstart = Time.monotonicNow();
        long localTimeout = 400L;
        boolean fileComplete = false;
        int retries = this.dfsClient.getConf().nBlockWriteLocateFollowingRetry;
        while (!fileComplete) {
            fileComplete = this.dfsClient.namenode.complete(this.src, this.dfsClient.clientName, last, this.fileId);
            if (fileComplete) continue;
            int hdfsTimeout = this.dfsClient.getHdfsTimeout();
            if (!this.dfsClient.clientRunning || hdfsTimeout > 0 && localstart + (long)hdfsTimeout < Time.monotonicNow()) {
                String msg = "Unable to close file because dfsclient  was unable to contact the HDFS servers. clientRunning " + this.dfsClient.clientRunning + " hdfsTimeout " + hdfsTimeout;
                DFSClient.LOG.info((Object)msg);
                throw new IOException(msg);
            }
            try {
                if (retries == 0) {
                    throw new IOException("Unable to close file because the last block does not have enough number of replicas.");
                }
                --retries;
                Thread.sleep(localTimeout);
                localTimeout *= 2L;
                if (Time.monotonicNow() - localstart <= 5000L) continue;
                DFSClient.LOG.info((Object)("Could not complete " + this.src + " retrying..."));
            }
            catch (InterruptedException ie) {
                DFSClient.LOG.warn((Object)"Caught exception ", (Throwable)ie);
            }
        }
    }

    @VisibleForTesting
    public void setArtificialSlowdown(long period) {
        this.artificialSlowdown = period;
    }

    @VisibleForTesting
    public synchronized void setChunksPerPacket(int value) {
        this.chunksPerPacket = Math.min(this.chunksPerPacket, value);
        this.packetSize = (this.bytesPerChecksum + this.getChecksumSize()) * this.chunksPerPacket;
    }

    synchronized void setTestFilename(String newname) {
        this.src = newname;
    }

    public long getInitialLen() {
        return this.initialFileSize;
    }

    public FileEncryptionInfo getFileEncryptionInfo() {
        return this.fileEncryptionInfo;
    }

    synchronized Token<BlockTokenIdentifier> getBlockToken() {
        return this.streamer.getBlockToken();
    }

    public void setDropBehind(Boolean dropBehind) throws IOException {
        CachingStrategy nextStrategy;
        CachingStrategy prevStrategy;
        while (!this.cachingStrategy.compareAndSet(prevStrategy = this.cachingStrategy.get(), nextStrategy = new CachingStrategy.Builder(prevStrategy).setDropBehind(dropBehind).build())) {
        }
    }

    @VisibleForTesting
    ExtendedBlock getBlock() {
        return this.streamer.getBlock();
    }

    @VisibleForTesting
    public long getFileId() {
        return this.fileId;
    }

    private static <T> void arraycopy(T[] srcs, T[] dsts, int skipIndex) {
        System.arraycopy(srcs, 0, dsts, 0, skipIndex);
        System.arraycopy(srcs, skipIndex + 1, dsts, skipIndex, dsts.length - skipIndex);
    }

    class DataStreamer
    extends Daemon {
        private volatile boolean streamerClosed = false;
        private ExtendedBlock block;
        private Token<BlockTokenIdentifier> accessToken;
        private DataOutputStream blockStream;
        private DataInputStream blockReplyStream;
        private ResponseProcessor response = null;
        private volatile DatanodeInfo[] nodes = null;
        private volatile StorageType[] storageTypes = null;
        private volatile String[] storageIDs = null;
        private final LoadingCache<DatanodeInfo, DatanodeInfo> excludedNodes;
        private String[] favoredNodes;
        volatile boolean hasError;
        volatile int errorIndex;
        AtomicInteger restartingNodeIndex;
        private long restartDeadline;
        private BlockConstructionStage stage;
        private long bytesSent;
        private final boolean isLazyPersistFile;
        private final List<DatanodeInfo> failed;
        private long lastAckedSeqnoBeforeFailure;
        private int pipelineRecoveryCount;
        private boolean isHflushed;
        private final boolean isAppend;

        private DataStreamer(HdfsFileStatus stat, ExtendedBlock block) {
            this.excludedNodes = CacheBuilder.newBuilder().expireAfterWrite(((DFSOutputStream)DFSOutputStream.this).dfsClient.getConf().excludedNodesCacheExpiry, TimeUnit.MILLISECONDS).removalListener((RemovalListener)new RemovalListener<DatanodeInfo, DatanodeInfo>(){

                public void onRemoval(RemovalNotification<DatanodeInfo, DatanodeInfo> notification) {
                    DFSClient.LOG.info((Object)("Removing node " + notification.getKey() + " from the excluded nodes list"));
                }
            }).build((CacheLoader)new CacheLoader<DatanodeInfo, DatanodeInfo>(){

                public DatanodeInfo load(DatanodeInfo key) throws Exception {
                    return key;
                }
            });
            this.hasError = false;
            this.errorIndex = -1;
            this.restartingNodeIndex = new AtomicInteger(-1);
            this.restartDeadline = 0L;
            this.bytesSent = 0L;
            this.failed = new ArrayList<DatanodeInfo>();
            this.lastAckedSeqnoBeforeFailure = -1L;
            this.pipelineRecoveryCount = 0;
            this.isHflushed = false;
            this.isAppend = false;
            this.isLazyPersistFile = DFSOutputStream.isLazyPersist(stat);
            this.block = block;
            this.stage = BlockConstructionStage.PIPELINE_SETUP_CREATE;
        }

        private DataStreamer(LocatedBlock lastBlock, HdfsFileStatus stat, int bytesPerChecksum) throws IOException {
            this.excludedNodes = CacheBuilder.newBuilder().expireAfterWrite(((DFSOutputStream)DFSOutputStream.this).dfsClient.getConf().excludedNodesCacheExpiry, TimeUnit.MILLISECONDS).removalListener((RemovalListener)new /* invalid duplicate definition of identical inner class */).build((CacheLoader)new /* invalid duplicate definition of identical inner class */);
            this.hasError = false;
            this.errorIndex = -1;
            this.restartingNodeIndex = new AtomicInteger(-1);
            this.restartDeadline = 0L;
            this.bytesSent = 0L;
            this.failed = new ArrayList<DatanodeInfo>();
            this.lastAckedSeqnoBeforeFailure = -1L;
            this.pipelineRecoveryCount = 0;
            this.isHflushed = false;
            this.isAppend = true;
            this.stage = BlockConstructionStage.PIPELINE_SETUP_APPEND;
            this.block = lastBlock.getBlock();
            this.bytesSent = this.block.getNumBytes();
            this.accessToken = lastBlock.getBlockToken();
            this.isLazyPersistFile = DFSOutputStream.isLazyPersist(stat);
            long usedInLastBlock = stat.getLen() % DFSOutputStream.this.blockSize;
            int freeInLastBlock = (int)(DFSOutputStream.this.blockSize - usedInLastBlock);
            int usedInCksum = (int)(stat.getLen() % (long)bytesPerChecksum);
            int freeInCksum = bytesPerChecksum - usedInCksum;
            if ((long)freeInLastBlock == DFSOutputStream.this.blockSize) {
                throw new IOException("The last block for file " + DFSOutputStream.this.src + " is full.");
            }
            if (usedInCksum > 0 && freeInCksum > 0) {
                DFSOutputStream.this.computePacketChunkSize(0, freeInCksum);
                DFSOutputStream.this.setChecksumBufSize(freeInCksum);
                DFSOutputStream.this.appendChunk = true;
            } else {
                DFSOutputStream.this.computePacketChunkSize(Math.min(((DFSOutputStream)DFSOutputStream.this).dfsClient.getConf().writePacketSize, freeInLastBlock), bytesPerChecksum);
            }
            this.setPipeline(lastBlock);
            this.errorIndex = -1;
            if (this.nodes.length < 1) {
                throw new IOException("Unable to retrieve blocks locations  for last block " + this.block + "of file " + DFSOutputStream.this.src);
            }
        }

        private void setPipeline(LocatedBlock lb) {
            this.setPipeline(lb.getLocations(), lb.getStorageTypes(), lb.getStorageIDs());
        }

        private void setPipeline(DatanodeInfo[] nodes, StorageType[] storageTypes, String[] storageIDs) {
            this.nodes = nodes;
            this.storageTypes = storageTypes;
            this.storageIDs = storageIDs;
        }

        private void setFavoredNodes(String[] favoredNodes) {
            this.favoredNodes = favoredNodes;
        }

        private void initDataStreaming() {
            this.setName("DataStreamer for file " + DFSOutputStream.this.src + " block " + this.block);
            this.response = new ResponseProcessor(this.nodes);
            this.response.start();
            this.stage = BlockConstructionStage.DATA_STREAMING;
        }

        private void endBlock() {
            if (DFSClient.LOG.isDebugEnabled()) {
                DFSClient.LOG.debug((Object)("Closing old block " + this.block));
            }
            this.setName("DataStreamer for file " + DFSOutputStream.this.src);
            this.closeResponder();
            this.closeStream();
            this.setPipeline(null, null, null);
            this.stage = BlockConstructionStage.PIPELINE_SETUP_CREATE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            long lastPacket = Time.monotonicNow();
            TraceScope scope = NullScope.INSTANCE;
            while (!this.streamerClosed && ((DFSOutputStream)DFSOutputStream.this).dfsClient.clientRunning) {
                if (this.hasError && this.response != null) {
                    try {
                        this.response.close();
                        this.response.join();
                        this.response = null;
                    }
                    catch (InterruptedException e) {
                        DFSClient.LOG.warn((Object)"Caught exception ", (Throwable)e);
                    }
                }
                try {
                    DFSPacket one;
                    boolean doSleep = false;
                    if (this.hasError && (this.errorIndex >= 0 || this.restartingNodeIndex.get() >= 0)) {
                        doSleep = this.processDatanodeError();
                    }
                    LinkedList linkedList = DFSOutputStream.this.dataQueue;
                    synchronized (linkedList) {
                        block58: {
                            long now = Time.monotonicNow();
                            while (!this.streamerClosed && !this.hasError && ((DFSOutputStream)DFSOutputStream.this).dfsClient.clientRunning && DFSOutputStream.this.dataQueue.size() == 0 && (this.stage != BlockConstructionStage.DATA_STREAMING || this.stage == BlockConstructionStage.DATA_STREAMING && now - lastPacket < (long)(((DFSOutputStream)DFSOutputStream.this).dfsClient.getConf().socketTimeout / 2)) || doSleep) {
                                long timeout = (long)(((DFSOutputStream)DFSOutputStream.this).dfsClient.getConf().socketTimeout / 2) - (now - lastPacket);
                                timeout = timeout <= 0L ? 1000L : timeout;
                                timeout = this.stage == BlockConstructionStage.DATA_STREAMING ? timeout : 1000L;
                                try {
                                    DFSOutputStream.this.dataQueue.wait(timeout);
                                }
                                catch (InterruptedException e) {
                                    DFSClient.LOG.warn((Object)"Caught exception ", (Throwable)e);
                                }
                                doSleep = false;
                                now = Time.monotonicNow();
                            }
                            if (!this.streamerClosed && !this.hasError && ((DFSOutputStream)DFSOutputStream.this).dfsClient.clientRunning) break block58;
                            continue;
                        }
                        if (DFSOutputStream.this.dataQueue.isEmpty()) {
                            one = DFSOutputStream.this.createHeartbeatPacket();
                            assert (one != null);
                        } else {
                            one = (DFSPacket)DFSOutputStream.this.dataQueue.getFirst();
                            long[] parents = one.getTraceParents();
                            if (parents.length > 0) {
                                scope = Trace.startSpan((String)"dataStreamer", (TraceInfo)new TraceInfo(0L, parents[0]));
                            }
                        }
                    }
                    if (this.stage == BlockConstructionStage.PIPELINE_SETUP_CREATE) {
                        if (DFSClient.LOG.isDebugEnabled()) {
                            DFSClient.LOG.debug((Object)"Allocating new block");
                        }
                        this.setPipeline(this.nextBlockOutputStream());
                        this.initDataStreaming();
                    } else if (this.stage == BlockConstructionStage.PIPELINE_SETUP_APPEND) {
                        if (DFSClient.LOG.isDebugEnabled()) {
                            DFSClient.LOG.debug((Object)("Append to block " + this.block));
                        }
                        this.setupPipelineForAppendOrRecovery();
                        this.initDataStreaming();
                    }
                    long lastByteOffsetInBlock = one.getLastByteOffsetBlock();
                    if (lastByteOffsetInBlock > DFSOutputStream.this.blockSize) {
                        throw new IOException("BlockSize " + DFSOutputStream.this.blockSize + " is smaller than data size.  Offset of packet in block " + lastByteOffsetInBlock + " Aborting file " + DFSOutputStream.this.src);
                    }
                    if (one.isLastPacketInBlock()) {
                        LinkedList linkedList2 = DFSOutputStream.this.dataQueue;
                        synchronized (linkedList2) {
                            while (!this.streamerClosed && !this.hasError && DFSOutputStream.this.ackQueue.size() != 0 && ((DFSOutputStream)DFSOutputStream.this).dfsClient.clientRunning) {
                                try {
                                    DFSOutputStream.this.dataQueue.wait(1000L);
                                }
                                catch (InterruptedException e) {
                                    DFSClient.LOG.warn((Object)"Caught exception ", (Throwable)e);
                                }
                            }
                        }
                        if (this.streamerClosed || this.hasError || !((DFSOutputStream)DFSOutputStream.this).dfsClient.clientRunning) continue;
                        this.stage = BlockConstructionStage.PIPELINE_CLOSE;
                    }
                    Span span = null;
                    LinkedList e = DFSOutputStream.this.dataQueue;
                    synchronized (e) {
                        if (!one.isHeartbeatPacket()) {
                            span = scope.detach();
                            one.setTraceSpan(span);
                            DFSOutputStream.this.dataQueue.removeFirst();
                            DFSOutputStream.this.ackQueue.addLast(one);
                            DFSOutputStream.this.dataQueue.notifyAll();
                        }
                    }
                    if (DFSClient.LOG.isDebugEnabled()) {
                        DFSClient.LOG.debug((Object)("DataStreamer block " + this.block + " sending packet " + one));
                    }
                    try (TraceScope writeScope = Trace.startSpan((String)"writeTo", (Span)span);){
                        one.writeTo(this.blockStream);
                        this.blockStream.flush();
                    }
                    lastPacket = Time.monotonicNow();
                    long tmpBytesSent = one.getLastByteOffsetBlock();
                    if (this.bytesSent < tmpBytesSent) {
                        this.bytesSent = tmpBytesSent;
                    }
                    if (this.streamerClosed || this.hasError || !((DFSOutputStream)DFSOutputStream.this).dfsClient.clientRunning) continue;
                    if (one.isLastPacketInBlock()) {
                        LinkedList linkedList3 = DFSOutputStream.this.dataQueue;
                        synchronized (linkedList3) {
                            while (!this.streamerClosed && !this.hasError && DFSOutputStream.this.ackQueue.size() != 0 && ((DFSOutputStream)DFSOutputStream.this).dfsClient.clientRunning) {
                                DFSOutputStream.this.dataQueue.wait(1000L);
                            }
                        }
                        if (this.streamerClosed || this.hasError || !((DFSOutputStream)DFSOutputStream.this).dfsClient.clientRunning) continue;
                        this.endBlock();
                    }
                    if (DFSOutputStream.this.progress != null) {
                        DFSOutputStream.this.progress.progress();
                    }
                    if (DFSOutputStream.this.artificialSlowdown == 0L || !((DFSOutputStream)DFSOutputStream.this).dfsClient.clientRunning) continue;
                    Thread.sleep(DFSOutputStream.this.artificialSlowdown);
                }
                catch (Throwable e) {
                    if (this.restartingNodeIndex.get() == -1) {
                        DFSClient.LOG.warn((Object)"DataStreamer Exception", e);
                    }
                    if (e instanceof IOException) {
                        this.setLastException((IOException)e);
                    } else {
                        this.setLastException(new IOException("DataStreamer Exception: ", e));
                    }
                    this.hasError = true;
                    if (this.errorIndex != -1 || this.restartingNodeIndex.get() != -1) continue;
                    this.streamerClosed = true;
                }
                finally {
                    scope.close();
                }
            }
            this.closeInternal();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void closeInternal() {
            this.closeResponder();
            this.closeStream();
            this.streamerClosed = true;
            DFSOutputStream.this.setClosed();
            LinkedList linkedList = DFSOutputStream.this.dataQueue;
            synchronized (linkedList) {
                DFSOutputStream.this.dataQueue.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close(boolean force) {
            this.streamerClosed = true;
            LinkedList linkedList = DFSOutputStream.this.dataQueue;
            synchronized (linkedList) {
                DFSOutputStream.this.dataQueue.notifyAll();
            }
            if (force) {
                this.interrupt();
            }
        }

        private void closeResponder() {
            if (this.response != null) {
                try {
                    this.response.close();
                    this.response.join();
                }
                catch (InterruptedException e) {
                    DFSClient.LOG.warn((Object)"Caught exception ", (Throwable)e);
                }
                finally {
                    this.response = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void closeStream() {
            if (this.blockStream != null) {
                try {
                    this.blockStream.close();
                }
                catch (IOException e) {
                    this.setLastException(e);
                }
                finally {
                    this.blockStream = null;
                }
            }
            if (this.blockReplyStream != null) {
                try {
                    this.blockReplyStream.close();
                }
                catch (IOException e) {
                    this.setLastException(e);
                }
                finally {
                    this.blockReplyStream = null;
                }
            }
            if (null != DFSOutputStream.this.s) {
                try {
                    DFSOutputStream.this.s.close();
                }
                catch (IOException e) {
                    this.setLastException(e);
                }
                finally {
                    DFSOutputStream.this.s = null;
                }
            }
        }

        synchronized void setErrorIndex(int idx) {
            this.errorIndex = idx;
        }

        synchronized void setRestartingNodeIndex(int idx) {
            this.restartingNodeIndex.set(idx);
            this.errorIndex = -1;
        }

        synchronized void tryMarkPrimaryDatanodeFailed() {
            if (this.errorIndex == -1 && this.restartingNodeIndex.get() == -1) {
                this.errorIndex = 0;
            }
        }

        boolean shouldWaitForRestart(int index) {
            InetAddress addr;
            block3: {
                if (this.nodes.length == 1) {
                    return true;
                }
                addr = null;
                try {
                    addr = InetAddress.getByName(this.nodes[index].getIpAddr());
                }
                catch (UnknownHostException e) {
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError();
                }
            }
            return addr != null && NetUtils.isLocalAddress((InetAddress)addr);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean processDatanodeError() throws IOException {
            if (this.response != null) {
                DFSClient.LOG.info((Object)("Error Recovery for " + this.block + " waiting for responder to exit. "));
                return true;
            }
            this.closeStream();
            LinkedList linkedList = DFSOutputStream.this.dataQueue;
            synchronized (linkedList) {
                DFSOutputStream.this.dataQueue.addAll(0, DFSOutputStream.this.ackQueue);
                DFSOutputStream.this.ackQueue.clear();
            }
            if (this.lastAckedSeqnoBeforeFailure != DFSOutputStream.this.lastAckedSeqno) {
                this.lastAckedSeqnoBeforeFailure = DFSOutputStream.this.lastAckedSeqno;
                this.pipelineRecoveryCount = 1;
            } else if (++this.pipelineRecoveryCount > 5) {
                DFSClient.LOG.warn((Object)("Error recovering pipeline for writing " + this.block + ". Already retried 5 times for the same packet."));
                DFSOutputStream.this.lastException.set(new IOException("Failing write. Tried pipeline recovery 5 times without success."));
                this.streamerClosed = true;
                return false;
            }
            boolean doSleep = this.setupPipelineForAppendOrRecovery();
            if (!this.streamerClosed && ((DFSOutputStream)DFSOutputStream.this).dfsClient.clientRunning) {
                if (this.stage == BlockConstructionStage.PIPELINE_CLOSE) {
                    LinkedList linkedList2 = DFSOutputStream.this.dataQueue;
                    synchronized (linkedList2) {
                        DFSPacket endOfBlockPacket = (DFSPacket)DFSOutputStream.this.dataQueue.remove();
                        Span span = endOfBlockPacket.getTraceSpan();
                        if (span != null) {
                            TraceScope scope = Trace.continueSpan((Span)span);
                            scope.close();
                        }
                        assert (endOfBlockPacket.isLastPacketInBlock());
                        assert (DFSOutputStream.this.lastAckedSeqno == endOfBlockPacket.getSeqno() - 1L);
                        DFSOutputStream.this.lastAckedSeqno = endOfBlockPacket.getSeqno();
                        DFSOutputStream.this.dataQueue.notifyAll();
                    }
                    this.endBlock();
                } else {
                    this.initDataStreaming();
                }
            }
            return doSleep;
        }

        private void setHflush() {
            this.isHflushed = true;
        }

        private int findNewDatanode(DatanodeInfo[] original) throws IOException {
            if (this.nodes.length != original.length + 1) {
                throw new IOException("Failed to replace a bad datanode on the existing pipeline " + "due to no more good datanodes being available to try. " + "(Nodes: current=" + Arrays.asList(this.nodes) + ", original=" + Arrays.asList(original) + "). " + "The current failed datanode replacement policy is " + ((DFSOutputStream)DFSOutputStream.this).dfsClient.dtpReplaceDatanodeOnFailure + ", and " + "a client may configure this via '" + "dfs.client.block.write.replace-datanode-on-failure.policy" + "' in its configuration.");
            }
            for (int i = 0; i < this.nodes.length; ++i) {
                int j;
                for (j = 0; j < original.length && !this.nodes[i].equals(original[j]); ++j) {
                }
                if (j != original.length) continue;
                return i;
            }
            throw new IOException("Failed: new datanode not found: nodes=" + Arrays.asList(this.nodes) + ", original=" + Arrays.asList(original));
        }

        private void addDatanode2ExistingPipeline() throws IOException {
            if (DataTransferProtocol.LOG.isDebugEnabled()) {
                DataTransferProtocol.LOG.debug((Object)("lastAckedSeqno = " + DFSOutputStream.this.lastAckedSeqno));
            }
            if (!this.isAppend && DFSOutputStream.this.lastAckedSeqno < 0L && this.stage == BlockConstructionStage.PIPELINE_SETUP_CREATE) {
                return;
            }
            if (this.stage == BlockConstructionStage.PIPELINE_CLOSE || this.stage == BlockConstructionStage.PIPELINE_CLOSE_RECOVERY) {
                return;
            }
            DatanodeInfo[] original = this.nodes;
            LocatedBlock lb = ((DFSOutputStream)DFSOutputStream.this).dfsClient.namenode.getAdditionalDatanode(DFSOutputStream.this.src, DFSOutputStream.this.fileId, this.block, this.nodes, this.storageIDs, this.failed.toArray(new DatanodeInfo[this.failed.size()]), 1, ((DFSOutputStream)DFSOutputStream.this).dfsClient.clientName);
            this.setPipeline(lb);
            int d = this.findNewDatanode(original);
            DatanodeInfo src = d == 0 ? this.nodes[1] : this.nodes[d - 1];
            DatanodeInfo[] targets = new DatanodeInfo[]{this.nodes[d]};
            StorageType[] targetStorageTypes = new StorageType[]{this.storageTypes[d]};
            this.transfer(src, targets, targetStorageTypes, lb.getBlockToken());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void transfer(DatanodeInfo src, DatanodeInfo[] targets, StorageType[] targetStorageTypes, Token<BlockTokenIdentifier> blockToken) throws IOException {
            Socket sock = null;
            DataOutputStream out = null;
            DataInputStream in = null;
            try {
                sock = DFSOutputStream.createSocketForPipeline(src, 2, DFSOutputStream.this.dfsClient);
                long writeTimeout = DFSOutputStream.this.dfsClient.getDatanodeWriteTimeout(2);
                OutputStream unbufOut = NetUtils.getOutputStream((Socket)sock, (long)writeTimeout);
                Object unbufIn = NetUtils.getInputStream((Socket)sock);
                IOStreamPair saslStreams = ((DFSOutputStream)DFSOutputStream.this).dfsClient.saslClient.socketSend(sock, unbufOut, (InputStream)unbufIn, DFSOutputStream.this.dfsClient, blockToken, src);
                unbufOut = saslStreams.out;
                unbufIn = saslStreams.in;
                out = new DataOutputStream(new BufferedOutputStream(unbufOut, HdfsConstants.SMALL_BUFFER_SIZE));
                in = new DataInputStream((InputStream)unbufIn);
                new Sender(out).transferBlock(this.block, blockToken, ((DFSOutputStream)DFSOutputStream.this).dfsClient.clientName, targets, targetStorageTypes);
                out.flush();
                DataTransferProtos.BlockOpResponseProto response = DataTransferProtos.BlockOpResponseProto.parseFrom(PBHelper.vintPrefixed(in));
                if (DataTransferProtos.Status.SUCCESS != response.getStatus()) {
                    throw new IOException("Failed to add a datanode");
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeStream(in);
                IOUtils.closeStream(out);
                IOUtils.closeSocket((Socket)sock);
                throw throwable;
            }
            IOUtils.closeStream((Closeable)in);
            IOUtils.closeStream((Closeable)out);
            IOUtils.closeSocket((Socket)sock);
        }

        private boolean setupPipelineForAppendOrRecovery() throws IOException {
            if (this.nodes == null || this.nodes.length == 0) {
                String msg = "Could not get block locations. Source file \"" + DFSOutputStream.this.src + "\" - Aborting...";
                DFSClient.LOG.warn((Object)msg);
                this.setLastException(new IOException(msg));
                this.streamerClosed = true;
                return false;
            }
            boolean success = false;
            long newGS = 0L;
            while (!success && !this.streamerClosed && ((DFSOutputStream)DFSOutputStream.this).dfsClient.clientRunning) {
                if (this.restartingNodeIndex.get() >= 0) {
                    long delay = Math.min(((DFSOutputStream)DFSOutputStream.this).dfsClient.getConf().datanodeRestartTimeout, 4000L);
                    try {
                        Thread.sleep(delay);
                    }
                    catch (InterruptedException ie) {
                        DFSOutputStream.this.lastException.set(new IOException("Interrupted while waiting for datanode to restart. " + this.nodes[this.restartingNodeIndex.get()]));
                        this.streamerClosed = true;
                        return false;
                    }
                }
                boolean isRecovery = this.hasError;
                if (this.errorIndex >= 0) {
                    StringBuilder pipelineMsg = new StringBuilder();
                    for (int j = 0; j < this.nodes.length; ++j) {
                        pipelineMsg.append(this.nodes[j]);
                        if (j >= this.nodes.length - 1) continue;
                        pipelineMsg.append(", ");
                    }
                    if (this.nodes.length <= 1) {
                        DFSOutputStream.this.lastException.set(new IOException("All datanodes " + pipelineMsg + " are bad. Aborting..."));
                        this.streamerClosed = true;
                        return false;
                    }
                    DFSClient.LOG.warn((Object)("Error Recovery for block " + this.block + " in pipeline " + pipelineMsg + ": bad datanode " + this.nodes[this.errorIndex]));
                    this.failed.add(this.nodes[this.errorIndex]);
                    Object[] newnodes = new DatanodeInfo[this.nodes.length - 1];
                    DFSOutputStream.arraycopy(this.nodes, newnodes, this.errorIndex);
                    Object[] newStorageTypes = new StorageType[newnodes.length];
                    DFSOutputStream.arraycopy(this.storageTypes, newStorageTypes, this.errorIndex);
                    Object[] newStorageIDs = new String[newnodes.length];
                    DFSOutputStream.arraycopy(this.storageIDs, newStorageIDs, this.errorIndex);
                    this.setPipeline((DatanodeInfo[])newnodes, (StorageType[])newStorageTypes, (String[])newStorageIDs);
                    if (this.restartingNodeIndex.get() >= 0) {
                        if (this.errorIndex > this.restartingNodeIndex.get()) {
                            this.restartingNodeIndex.set(-1);
                        } else if (this.errorIndex < this.restartingNodeIndex.get()) {
                            this.restartingNodeIndex.decrementAndGet();
                        } else assert (false);
                    }
                    if (this.restartingNodeIndex.get() == -1) {
                        this.hasError = false;
                    }
                    DFSOutputStream.this.lastException.set(null);
                    this.errorIndex = -1;
                }
                if (((DFSOutputStream)DFSOutputStream.this).dfsClient.dtpReplaceDatanodeOnFailure.satisfy(DFSOutputStream.this.blockReplication, this.nodes, this.isAppend, this.isHflushed)) {
                    try {
                        this.addDatanode2ExistingPipeline();
                    }
                    catch (IOException ioe) {
                        if (!((DFSOutputStream)DFSOutputStream.this).dfsClient.dtpReplaceDatanodeOnFailure.isBestEffort()) {
                            throw ioe;
                        }
                        DFSClient.LOG.warn((Object)"Failed to replace datanode. Continue with the remaining datanodes since dfs.client.block.write.replace-datanode-on-failure.best-effort is set to true.", (Throwable)ioe);
                    }
                }
                LocatedBlock lb = ((DFSOutputStream)DFSOutputStream.this).dfsClient.namenode.updateBlockForPipeline(this.block, ((DFSOutputStream)DFSOutputStream.this).dfsClient.clientName);
                newGS = lb.getBlock().getGenerationStamp();
                this.accessToken = lb.getBlockToken();
                if (DFSOutputStream.this.failPacket) {
                    success = this.createBlockOutputStream(this.nodes, this.storageTypes, newGS, isRecovery);
                    DFSOutputStream.this.failPacket = false;
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException newnodes) {}
                } else {
                    success = this.createBlockOutputStream(this.nodes, this.storageTypes, newGS, isRecovery);
                }
                if (this.restartingNodeIndex.get() < 0) continue;
                assert (this.hasError);
                if (this.errorIndex == this.restartingNodeIndex.get()) {
                    this.errorIndex = -1;
                }
                if (Time.monotonicNow() < this.restartDeadline) continue;
                this.restartDeadline = 0L;
                int expiredNodeIndex = this.restartingNodeIndex.get();
                this.restartingNodeIndex.set(-1);
                DFSClient.LOG.warn((Object)("Datanode did not restart in time: " + this.nodes[expiredNodeIndex]));
                if (this.errorIndex != -1) continue;
                this.errorIndex = expiredNodeIndex;
            }
            if (success) {
                ExtendedBlock newBlock = new ExtendedBlock(this.block.getBlockPoolId(), this.block.getBlockId(), this.block.getNumBytes(), newGS);
                ((DFSOutputStream)DFSOutputStream.this).dfsClient.namenode.updatePipeline(((DFSOutputStream)DFSOutputStream.this).dfsClient.clientName, this.block, newBlock, this.nodes, this.storageIDs);
                this.block = newBlock;
            }
            return false;
        }

        private LocatedBlock nextBlockOutputStream() throws IOException {
            LocatedBlock lb = null;
            DatanodeInfo[] nodes = null;
            StorageType[] storageTypes = null;
            int count = ((DFSOutputStream)DFSOutputStream.this).dfsClient.getConf().nBlockWriteRetry;
            boolean success = false;
            ExtendedBlock oldBlock = this.block;
            do {
                this.hasError = false;
                DFSOutputStream.this.lastException.set(null);
                this.errorIndex = -1;
                success = false;
                DatanodeInfo[] excluded = (DatanodeInfo[])this.excludedNodes.getAllPresent(this.excludedNodes.asMap().keySet()).keySet().toArray((Object[])new DatanodeInfo[0]);
                this.block = oldBlock;
                lb = this.locateFollowingBlock((DatanodeInfo[])(excluded.length > 0 ? excluded : null));
                this.block = lb.getBlock();
                this.block.setNumBytes(0L);
                this.bytesSent = 0L;
                this.accessToken = lb.getBlockToken();
                nodes = lb.getLocations();
                storageTypes = lb.getStorageTypes();
                success = this.createBlockOutputStream(nodes, storageTypes, 0L, false);
                if (success) continue;
                DFSClient.LOG.info((Object)("Abandoning " + this.block));
                ((DFSOutputStream)DFSOutputStream.this).dfsClient.namenode.abandonBlock(this.block, DFSOutputStream.this.fileId, DFSOutputStream.this.src, ((DFSOutputStream)DFSOutputStream.this).dfsClient.clientName);
                this.block = null;
                DFSClient.LOG.info((Object)("Excluding datanode " + nodes[this.errorIndex]));
                this.excludedNodes.put((Object)nodes[this.errorIndex], (Object)nodes[this.errorIndex]);
            } while (!success && --count >= 0);
            if (!success) {
                throw new IOException("Unable to create new block.");
            }
            return lb;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean createBlockOutputStream(DatanodeInfo[] nodes, StorageType[] nodeStorageTypes, long newGS, boolean recoveryFlag) {
            boolean result;
            if (nodes.length == 0) {
                DFSClient.LOG.info((Object)("nodes are empty for write pipeline of block " + this.block));
                return false;
            }
            DataTransferProtos.Status pipelineStatus = DataTransferProtos.Status.SUCCESS;
            String firstBadLink = "";
            boolean checkRestart = false;
            if (DFSClient.LOG.isDebugEnabled()) {
                for (int i = 0; i < nodes.length; ++i) {
                    DFSClient.LOG.debug((Object)("pipeline = " + nodes[i]));
                }
            }
            DFSOutputStream.this.persistBlocks.set(true);
            int refetchEncryptionKey = 1;
            while (true) {
                result = false;
                DataOutputStream out = null;
                try {
                    assert (null == DFSOutputStream.this.s) : "Previous socket unclosed";
                    assert (null == this.blockReplyStream) : "Previous blockReplyStream unclosed";
                    DFSOutputStream.this.s = DFSOutputStream.createSocketForPipeline(nodes[0], nodes.length, DFSOutputStream.this.dfsClient);
                    long writeTimeout = DFSOutputStream.this.dfsClient.getDatanodeWriteTimeout(nodes.length);
                    OutputStream unbufOut = NetUtils.getOutputStream((Socket)DFSOutputStream.this.s, (long)writeTimeout);
                    Object unbufIn = NetUtils.getInputStream((Socket)DFSOutputStream.this.s);
                    IOStreamPair saslStreams = ((DFSOutputStream)DFSOutputStream.this).dfsClient.saslClient.socketSend(DFSOutputStream.this.s, unbufOut, (InputStream)unbufIn, DFSOutputStream.this.dfsClient, this.accessToken, nodes[0]);
                    unbufOut = saslStreams.out;
                    unbufIn = saslStreams.in;
                    out = new DataOutputStream(new BufferedOutputStream(unbufOut, HdfsConstants.SMALL_BUFFER_SIZE));
                    this.blockReplyStream = new DataInputStream((InputStream)unbufIn);
                    BlockConstructionStage bcs = recoveryFlag ? this.stage.getRecoveryStage() : this.stage;
                    ExtendedBlock blockCopy = new ExtendedBlock(this.block);
                    blockCopy.setNumBytes(DFSOutputStream.this.blockSize);
                    boolean[] targetPinnings = this.getPinnings(nodes, true);
                    new Sender(out).writeBlock(blockCopy, nodeStorageTypes[0], this.accessToken, ((DFSOutputStream)DFSOutputStream.this).dfsClient.clientName, nodes, nodeStorageTypes, null, bcs, nodes.length, this.block.getNumBytes(), this.bytesSent, newGS, DFSOutputStream.this.checksum4WriteBlock, (CachingStrategy)DFSOutputStream.this.cachingStrategy.get(), this.isLazyPersistFile, targetPinnings == null ? false : targetPinnings[0], targetPinnings);
                    DataTransferProtos.BlockOpResponseProto resp = DataTransferProtos.BlockOpResponseProto.parseFrom(PBHelper.vintPrefixed(this.blockReplyStream));
                    pipelineStatus = resp.getStatus();
                    firstBadLink = resp.getFirstBadLink();
                    if (PipelineAck.isRestartOOBStatus(pipelineStatus) && this.restartingNodeIndex.get() == -1) {
                        checkRestart = true;
                        throw new IOException("A datanode is restarting.");
                    }
                    String logInfo = "ack with firstBadLink as " + firstBadLink;
                    DataTransferProtoUtil.checkBlockOpStatus(resp, logInfo);
                    assert (null == this.blockStream) : "Previous blockStream unclosed";
                    this.blockStream = out;
                    result = true;
                    this.restartingNodeIndex.set(-1);
                    this.hasError = false;
                    if (result) break;
                }
                catch (IOException ie) {
                    block20: {
                        block19: {
                            if (this.restartingNodeIndex.get() == -1) {
                                DFSClient.LOG.info((Object)"Exception in createBlockOutputStream", (Throwable)ie);
                            }
                            if (ie instanceof InvalidEncryptionKeyException && refetchEncryptionKey > 0) {
                                DFSClient.LOG.info((Object)("Will fetch a new encryption key and retry, encryption key was invalid when connecting to " + nodes[0] + " : " + ie));
                                --refetchEncryptionKey;
                                DFSOutputStream.this.dfsClient.clearDataEncryptionKey();
                                continue;
                            }
                            if (firstBadLink.length() == 0) break block19;
                            for (int i = 0; i < nodes.length; ++i) {
                                if (!firstBadLink.equals(nodes[i].getXferAddr())) continue;
                                this.errorIndex = i;
                                break block20;
                            }
                            break block20;
                        }
                        assert (!checkRestart);
                        this.errorIndex = 0;
                    }
                    if (checkRestart && this.shouldWaitForRestart(this.errorIndex)) {
                        this.restartDeadline = ((DFSOutputStream)DFSOutputStream.this).dfsClient.getConf().datanodeRestartTimeout + Time.monotonicNow();
                        this.restartingNodeIndex.set(this.errorIndex);
                        this.errorIndex = -1;
                        DFSClient.LOG.info((Object)("Waiting for the datanode to be restarted: " + nodes[this.restartingNodeIndex.get()]));
                    }
                    this.hasError = true;
                    this.setLastException(ie);
                    result = false;
                    break;
                }
                finally {
                    if (result) continue;
                    IOUtils.closeSocket((Socket)DFSOutputStream.this.s);
                    DFSOutputStream.this.s = null;
                    IOUtils.closeStream(out);
                    out = null;
                    IOUtils.closeStream((Closeable)this.blockReplyStream);
                    this.blockReplyStream = null;
                    continue;
                }
                IOUtils.closeSocket((Socket)DFSOutputStream.this.s);
                DFSOutputStream.this.s = null;
                IOUtils.closeStream((Closeable)out);
                out = null;
                IOUtils.closeStream((Closeable)this.blockReplyStream);
                this.blockReplyStream = null;
                break;
            }
            return result;
        }

        private boolean[] getPinnings(DatanodeInfo[] nodes, boolean shouldLog) {
            if (this.favoredNodes == null) {
                return null;
            }
            boolean[] pinnings = new boolean[nodes.length];
            HashSet<String> favoredSet = new HashSet<String>(Arrays.asList(this.favoredNodes));
            for (int i = 0; i < nodes.length; ++i) {
                pinnings[i] = favoredSet.remove(nodes[i].getXferAddrWithHostname());
                if (!DFSClient.LOG.isDebugEnabled()) continue;
                DFSClient.LOG.debug((Object)(nodes[i].getXferAddrWithHostname() + " was chosen by name node (favored=" + pinnings[i] + ")."));
            }
            if (shouldLog && !favoredSet.isEmpty()) {
                DFSClient.LOG.warn((Object)("These favored nodes were specified but not chosen: " + favoredSet + " Specified favored nodes: " + Arrays.toString(this.favoredNodes)));
            }
            return pinnings;
        }

        private LocatedBlock locateFollowingBlock(DatanodeInfo[] excludedNodes) throws IOException {
            int retries = ((DFSOutputStream)DFSOutputStream.this).dfsClient.getConf().nBlockWriteLocateFollowingRetry;
            long sleeptime = 400L;
            long localstart = Time.monotonicNow();
            while (true) {
                try {
                    return ((DFSOutputStream)DFSOutputStream.this).dfsClient.namenode.addBlock(DFSOutputStream.this.src, ((DFSOutputStream)DFSOutputStream.this).dfsClient.clientName, this.block, excludedNodes, DFSOutputStream.this.fileId, this.favoredNodes);
                }
                catch (RemoteException e) {
                    IOException ue = e.unwrapRemoteException(new Class[]{FileNotFoundException.class, AccessControlException.class, NSQuotaExceededException.class, DSQuotaExceededException.class, UnresolvedPathException.class});
                    if (ue != e) {
                        throw ue;
                    }
                    if (NotReplicatedYetException.class.getName().equals(e.getClassName())) {
                        if (retries == 0) {
                            throw e;
                        }
                        --retries;
                        DFSClient.LOG.info((Object)"Exception while adding a block", (Throwable)e);
                        long elapsed = Time.monotonicNow() - localstart;
                        if (elapsed > 5000L) {
                            DFSClient.LOG.info((Object)("Waiting for replication for " + elapsed / 1000L + " seconds"));
                        }
                        try {
                            DFSClient.LOG.warn((Object)("NotReplicatedYetException sleeping " + DFSOutputStream.this.src + " retries left " + retries));
                            Thread.sleep(sleeptime);
                            sleeptime *= 2L;
                        }
                        catch (InterruptedException ie) {
                            DFSClient.LOG.warn((Object)"Caught exception ", (Throwable)ie);
                        }
                        continue;
                    }
                    throw e;
                }
                break;
            }
        }

        ExtendedBlock getBlock() {
            return this.block;
        }

        DatanodeInfo[] getNodes() {
            return this.nodes;
        }

        Token<BlockTokenIdentifier> getBlockToken() {
            return this.accessToken;
        }

        private void setLastException(IOException e) {
            DFSOutputStream.this.lastException.compareAndSet(null, e);
        }

        private class ResponseProcessor
        extends Daemon {
            private volatile boolean responderClosed = false;
            private DatanodeInfo[] targets = null;
            private boolean isLastPacketInBlock = false;

            ResponseProcessor(DatanodeInfo[] targets) {
                this.targets = targets;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                this.setName("ResponseProcessor for block " + DataStreamer.this.block);
                PipelineAck ack = new PipelineAck();
                TraceScope scope = NullScope.INSTANCE;
                while (!this.responderClosed && ((DFSOutputStream)DFSOutputStream.this).dfsClient.clientRunning && !this.isLastPacketInBlock) {
                    try {
                        DFSPacket one;
                        long begin = Time.monotonicNow();
                        ack.readFields(DataStreamer.this.blockReplyStream);
                        long duration = Time.monotonicNow() - begin;
                        if (duration > DFSOutputStream.this.dfsclientSlowLogThresholdMs && ack.getSeqno() != -1L) {
                            DFSClient.LOG.warn((Object)("Slow ReadProcessor read fields took " + duration + "ms (threshold=" + DFSOutputStream.this.dfsclientSlowLogThresholdMs + "ms); ack: " + ack + ", targets: " + Arrays.asList(this.targets)));
                        } else if (DFSClient.LOG.isDebugEnabled()) {
                            DFSClient.LOG.debug((Object)("DFSClient " + ack));
                        }
                        long seqno = ack.getSeqno();
                        for (int i = ack.getNumOfReplies() - 1; i >= 0 && ((DFSOutputStream)DFSOutputStream.this).dfsClient.clientRunning; --i) {
                            DataTransferProtos.Status reply = PipelineAck.getStatusFromHeader(ack.getHeaderFlag(i));
                            if (PipelineAck.isRestartOOBStatus(reply) && DataStreamer.this.shouldWaitForRestart(i)) {
                                DataStreamer.this.restartDeadline = ((DFSOutputStream)DFSOutputStream.this).dfsClient.getConf().datanodeRestartTimeout + Time.monotonicNow();
                                DataStreamer.this.setRestartingNodeIndex(i);
                                String message = "A datanode is restarting: " + this.targets[i];
                                DFSClient.LOG.info((Object)message);
                                throw new IOException(message);
                            }
                            if (reply == DataTransferProtos.Status.SUCCESS) continue;
                            DataStreamer.this.setErrorIndex(i);
                            throw new IOException("Bad response " + (Object)((Object)reply) + " for block " + DataStreamer.this.block + " from datanode " + this.targets[i]);
                        }
                        assert (seqno != -2L) : "Ack for unknown seqno should be a failed ack: " + ack;
                        if (seqno == -1L) continue;
                        LinkedList linkedList = DFSOutputStream.this.dataQueue;
                        synchronized (linkedList) {
                            one = (DFSPacket)DFSOutputStream.this.ackQueue.getFirst();
                        }
                        if (one.getSeqno() != seqno) {
                            throw new IOException("ResponseProcessor: Expecting seqno  for block " + DataStreamer.this.block + one.getSeqno() + " but received " + seqno);
                        }
                        this.isLastPacketInBlock = one.isLastPacketInBlock();
                        if (DFSClientFaultInjector.get().failPacket() && this.isLastPacketInBlock) {
                            DFSOutputStream.this.failPacket = true;
                            throw new IOException("Failing the last packet for testing.");
                        }
                        DataStreamer.this.block.setNumBytes(one.getLastByteOffsetBlock());
                        linkedList = DFSOutputStream.this.dataQueue;
                        synchronized (linkedList) {
                            scope = Trace.continueSpan((Span)one.getTraceSpan());
                            one.setTraceSpan(null);
                            DFSOutputStream.this.lastAckedSeqno = seqno;
                            DFSOutputStream.this.ackQueue.removeFirst();
                            DFSOutputStream.this.dataQueue.notifyAll();
                            one.releaseBuffer(DFSOutputStream.this.byteArrayManager);
                        }
                    }
                    catch (Exception e) {
                        if (this.responderClosed) continue;
                        if (e instanceof IOException) {
                            DataStreamer.this.setLastException((IOException)e);
                        }
                        DataStreamer.this.hasError = true;
                        DataStreamer.this.tryMarkPrimaryDatanodeFailed();
                        LinkedList linkedList = DFSOutputStream.this.dataQueue;
                        synchronized (linkedList) {
                            DFSOutputStream.this.dataQueue.notifyAll();
                        }
                        if (DataStreamer.this.restartingNodeIndex.get() == -1) {
                            DFSClient.LOG.warn((Object)("DFSOutputStream ResponseProcessor exception  for block " + DataStreamer.this.block), (Throwable)e);
                        }
                        this.responderClosed = true;
                    }
                    finally {
                        scope.close();
                    }
                }
            }

            void close() {
                this.responderClosed = true;
                this.interrupt();
            }
        }
    }
}

