/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.jdbc;

import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexFieldCollation;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexPatternFieldRef;
import org.apache.calcite.rex.RexRangeRef;
import org.apache.calcite.rex.RexSubQuery;
import org.apache.calcite.rex.RexTableInputRef;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexWindow;
import org.apache.drill.exec.planner.sql.DrillSqlOperator;

class JdbcExpressionCheck
implements RexVisitor<Boolean> {
    private static final JdbcExpressionCheck INSTANCE = new JdbcExpressionCheck();

    JdbcExpressionCheck() {
    }

    public static boolean isOnlyStandardExpressions(RexNode rex) {
        return (Boolean)rex.accept((RexVisitor)INSTANCE);
    }

    public Boolean visitInputRef(RexInputRef paramRexInputRef) {
        return true;
    }

    public Boolean visitLocalRef(RexLocalRef paramRexLocalRef) {
        return true;
    }

    public Boolean visitLiteral(RexLiteral paramRexLiteral) {
        return true;
    }

    public Boolean visitCall(RexCall paramRexCall) {
        if (paramRexCall.getOperator() instanceof DrillSqlOperator) {
            return false;
        }
        for (RexNode operand : paramRexCall.operands) {
            if (((Boolean)operand.accept((RexVisitor)this)).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public Boolean visitOver(RexOver over) {
        if (!this.visitCall((RexCall)over).booleanValue()) {
            return false;
        }
        RexWindow window = over.getWindow();
        for (RexFieldCollation orderKey : window.orderKeys) {
            if (((Boolean)((RexNode)orderKey.left).accept((RexVisitor)this)).booleanValue()) continue;
            return false;
        }
        for (RexNode partitionKey : window.partitionKeys) {
            if (((Boolean)partitionKey.accept((RexVisitor)this)).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public Boolean visitCorrelVariable(RexCorrelVariable paramRexCorrelVariable) {
        return true;
    }

    public Boolean visitDynamicParam(RexDynamicParam paramRexDynamicParam) {
        return true;
    }

    public Boolean visitRangeRef(RexRangeRef paramRexRangeRef) {
        return true;
    }

    public Boolean visitFieldAccess(RexFieldAccess paramRexFieldAccess) {
        return (Boolean)paramRexFieldAccess.getReferenceExpr().accept((RexVisitor)this);
    }

    public Boolean visitSubQuery(RexSubQuery subQuery) {
        return null;
    }

    public Boolean visitTableInputRef(RexTableInputRef fieldRef) {
        return false;
    }

    public Boolean visitPatternFieldRef(RexPatternFieldRef fieldRef) {
        return false;
    }
}

