/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.File;
import java.nio.ByteBuffer;
import kafka.log.AbortedTxn;
import kafka.log.BatchMetadata;
import kafka.log.CorruptSnapshotException;
import kafka.log.Log$;
import kafka.log.OffsetIndex;
import kafka.log.OffsetIndex$;
import kafka.log.OffsetPosition;
import kafka.log.ProducerStateEntry;
import kafka.log.ProducerStateManager$;
import kafka.log.TimeIndex;
import kafka.log.TimeIndex$;
import kafka.log.TimestampOffset;
import kafka.log.TransactionIndex;
import kafka.tools.DumpLogSegments;
import kafka.tools.DumpLogSegments$$anonfun$kafka$tools$DumpLogSegments$;
import kafka.utils.CommandLineUtils$;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.FileLogInputStream;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;

public final class DumpLogSegments$ {
    public static final DumpLogSegments$ MODULE$;
    private final String RecordIndent;

    static {
        new DumpLogSegments$();
    }

    public String RecordIndent() {
        return this.RecordIndent;
    }

    public void main(String[] args) {
        DumpLogSegments.DumpLogSegmentsOptions opts = new DumpLogSegments.DumpLogSegmentsOptions(args);
        CommandLineUtils$.MODULE$.printHelpAndExitIfNeeded(opts, "This tool helps to parse a log file and dump its contents to the console, useful for debugging a seemingly corrupt log segment.");
        opts.checkArgs();
        Map misMatchesForIndexFilesMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        DumpLogSegments.TimeIndexDumpErrors timeIndexDumpErrors = new DumpLogSegments.TimeIndexDumpErrors();
        Map nonConsecutivePairsForLogFilesMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        Predef$.MODULE$.refArrayOps((Object[])opts.files()).foreach((Function1)new Serializable(opts, misMatchesForIndexFilesMap, timeIndexDumpErrors, nonConsecutivePairsForLogFilesMap){
            public static final long serialVersionUID = 0L;
            private final DumpLogSegments.DumpLogSegmentsOptions opts$1;
            private final Map misMatchesForIndexFilesMap$1;
            private final DumpLogSegments.TimeIndexDumpErrors timeIndexDumpErrors$1;
            private final Map nonConsecutivePairsForLogFilesMap$1;

            public final void apply(String arg) {
                String suffix;
                File file = new File(arg);
                Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Dumping ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file})));
                String filename = file.getName();
                String string = suffix = filename.substring(filename.lastIndexOf("."));
                String string2 = Log$.MODULE$.LogFileSuffix();
                String string3 = string;
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    DumpLogSegments$.MODULE$.kafka$tools$DumpLogSegments$$dumpLog(file, this.opts$1.shouldPrintDataLog(), (Map<String, List<Tuple2<Object, Object>>>)this.nonConsecutivePairsForLogFilesMap$1, this.opts$1.isDeepIteration(), this.opts$1.maxMessageSize(), this.opts$1.messageParser());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    String string4 = Log$.MODULE$.IndexFileSuffix();
                    String string5 = string;
                    if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                        DumpLogSegments$.MODULE$.dumpIndex(file, this.opts$1.indexSanityOnly(), this.opts$1.verifyOnly(), (Map<String, List<Tuple2<Object, Object>>>)this.misMatchesForIndexFilesMap$1, this.opts$1.maxMessageSize());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        String string6 = Log$.MODULE$.TimeIndexFileSuffix();
                        String string7 = string;
                        if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                            DumpLogSegments$.MODULE$.dumpTimeIndex(file, this.opts$1.indexSanityOnly(), this.opts$1.verifyOnly(), this.timeIndexDumpErrors$1, this.opts$1.maxMessageSize());
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            String string8 = Log$.MODULE$.ProducerSnapshotFileSuffix();
                            String string9 = string;
                            if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                                DumpLogSegments$.MODULE$.kafka$tools$DumpLogSegments$$dumpProducerIdSnapshot(file);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            } else {
                                String string10 = Log$.MODULE$.TxnIndexFileSuffix();
                                String string11 = string;
                                if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                                    DumpLogSegments$.MODULE$.kafka$tools$DumpLogSegments$$dumpTxnIndex(file);
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    System.err.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ignoring unknown file ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file})));
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                }
                            }
                        }
                    }
                }
            }
            {
                this.opts$1 = opts$1;
                this.misMatchesForIndexFilesMap$1 = misMatchesForIndexFilesMap$1;
                this.timeIndexDumpErrors$1 = timeIndexDumpErrors$1;
                this.nonConsecutivePairsForLogFilesMap$1 = nonConsecutivePairsForLogFilesMap$1;
            }
        });
        misMatchesForIndexFilesMap.foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<String, List<Tuple2<Object, Object>>> x0$1) {
                Tuple2<String, List<Tuple2<Object, Object>>> tuple2 = x0$1;
                if (tuple2 != null) {
                    String fileName = (String)tuple2._1();
                    List listOfMismatches = (List)tuple2._2();
                    System.err.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Mismatches in :", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fileName})));
                    listOfMismatches.foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply(Tuple2<Object, Object> x0$2) {
                            Tuple2<Object, Object> tuple2 = x0$2;
                            if (tuple2 != null) {
                                long indexOffset = tuple2._1$mcJ$sp();
                                long logOffset = tuple2._2$mcJ$sp();
                                System.err.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"  Index offset: ", ", log offset: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)indexOffset), BoxesRunTime.boxToLong((long)logOffset)})));
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                            throw new MatchError(tuple2);
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
        });
        timeIndexDumpErrors.printErrors();
        nonConsecutivePairsForLogFilesMap.foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<String, List<Tuple2<Object, Object>>> x0$3) {
                Tuple2<String, List<Tuple2<Object, Object>>> tuple2 = x0$3;
                if (tuple2 != null) {
                    String fileName = (String)tuple2._1();
                    List listOfNonConsecutivePairs = (List)tuple2._2();
                    System.err.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Non-consecutive offsets in ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fileName})));
                    listOfNonConsecutivePairs.foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply(Tuple2<Object, Object> x0$4) {
                            Tuple2<Object, Object> tuple2 = x0$4;
                            if (tuple2 != null) {
                                long first = tuple2._1$mcJ$sp();
                                long second = tuple2._2$mcJ$sp();
                                System.err.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"  ", " is followed by ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)first), BoxesRunTime.boxToLong((long)second)})));
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                            throw new MatchError(tuple2);
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
        });
    }

    public void kafka$tools$DumpLogSegments$$dumpTxnIndex(File file) {
        TransactionIndex index = new TransactionIndex(Log$.MODULE$.offsetFromFile(file), file);
        index.allAbortedTxns().foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(AbortedTxn abortedTxn) {
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"version: ", " producerId: ", " firstOffset: ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToShort((short)abortedTxn.version()), BoxesRunTime.boxToLong((long)abortedTxn.producerId()), BoxesRunTime.boxToLong((long)abortedTxn.firstOffset())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"lastOffset: ", " lastStableOffset: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)abortedTxn.lastOffset()), BoxesRunTime.boxToLong((long)abortedTxn.lastStableOffset())}))).toString());
            }
        });
    }

    public void kafka$tools$DumpLogSegments$$dumpProducerIdSnapshot(File file) {
        try {
            ProducerStateManager$.MODULE$.readSnapshot(file).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(ProducerStateEntry entry2) {
                    Predef$.MODULE$.print((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"producerId: ", " producerEpoch: ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)entry2.producerId()), BoxesRunTime.boxToShort((short)entry2.producerEpoch())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"coordinatorEpoch: ", " currentTxnFirstOffset: ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)entry2.coordinatorEpoch()), entry2.currentTxnFirstOffset()}))).toString());
                    entry2.batchMetadata().headOption().foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply(BatchMetadata metadata) {
                            Predef$.MODULE$.print((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"firstSequence: ", " lastSequence: ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)metadata.firstSeq()), BoxesRunTime.boxToInteger((int)metadata.lastSeq())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"lastOffset: ", " offsetDelta: ", " timestamp: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)metadata.lastOffset()), BoxesRunTime.boxToInteger((int)metadata.offsetDelta()), BoxesRunTime.boxToLong((long)metadata.timestamp())}))).toString());
                        }
                    });
                    Predef$.MODULE$.println();
                }
            });
        }
        catch (CorruptSnapshotException corruptSnapshotException) {
            System.err.println(corruptSnapshotException.getMessage());
        }
    }

    public void dumpIndex(File file, boolean indexSanityOnly, boolean verifyOnly, Map<String, List<Tuple2<Object, Object>>> misMatchesForIndexFilesMap, int maxMessageSize) {
        NonLocalReturnControl nonLocalReturnControl2;
        block3: {
            Object object = new Object();
            try {
                long startOffset = new StringOps(Predef$.MODULE$.augmentString(file.getName().split("\\.")[0])).toLong();
                File logFile = new File(file.getAbsoluteFile().getParent(), new StringBuilder().append((Object)file.getName().split("\\.")[0]).append((Object)Log$.MODULE$.LogFileSuffix()).toString());
                FileRecords fileRecords = FileRecords.open((File)logFile, (boolean)false);
                File x$4 = file;
                long x$5 = startOffset;
                boolean x$6 = false;
                int x$7 = OffsetIndex$.MODULE$.$lessinit$greater$default$3();
                OffsetIndex index = new OffsetIndex(x$4, x$5, x$7, x$6);
                if (indexSanityOnly) {
                    index.sanityCheck();
                    Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " passed sanity check."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file})));
                    return;
                }
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), index.entries()).foreach$mVc$sp((Function1)new Serializable(file, verifyOnly, misMatchesForIndexFilesMap, maxMessageSize, fileRecords, index, object){
                    public static final long serialVersionUID = 0L;
                    private final File file$2;
                    private final boolean verifyOnly$1;
                    private final Map misMatchesForIndexFilesMap$2;
                    private final int maxMessageSize$1;
                    private final FileRecords fileRecords$1;
                    private final OffsetIndex index$1;
                    private final Object nonLocalReturnKey1$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        BoxedUnit boxedUnit;
                        OffsetPosition entry2 = this.index$1.entry(i);
                        if (entry2.offset() == this.index$1.baseOffset() && i > 0) {
                            throw new NonLocalReturnControl.mcV.sp(this.nonLocalReturnKey1$1, BoxedUnit.UNIT);
                        }
                        FileRecords slice = this.fileRecords$1.slice(entry2.position(), this.maxMessageSize$1);
                        long firstBatchLastOffset = ((RecordBatch)slice.batches().iterator().next()).lastOffset();
                        if (firstBatchLastOffset != entry2.offset()) {
                            List misMatchesSeq = (List)this.misMatchesForIndexFilesMap$2.getOrElse((Object)this.file$2.getAbsolutePath(), (Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final List<Tuple2<Object, Object>> apply() {
                                    return Nil$.MODULE$;
                                }
                            });
                            misMatchesSeq = misMatchesSeq.$colon$colon((Object)new Tuple2.mcJJ.sp(entry2.offset(), firstBatchLastOffset));
                            boxedUnit = this.misMatchesForIndexFilesMap$2.put((Object)this.file$2.getAbsolutePath(), (Object)misMatchesSeq);
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        if (!this.verifyOnly$1) {
                            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"offset: ", " position: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)entry2.offset()), BoxesRunTime.boxToInteger((int)entry2.position())})));
                        }
                    }
                    {
                        this.file$2 = file$2;
                        this.verifyOnly$1 = verifyOnly$1;
                        this.misMatchesForIndexFilesMap$2 = misMatchesForIndexFilesMap$2;
                        this.maxMessageSize$1 = maxMessageSize$1;
                        this.fileRecords$1 = fileRecords$1;
                        this.index$1 = index$1;
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                });
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block3;
                nonLocalReturnControl2.value$mcV$sp();
            }
            return;
        }
        throw nonLocalReturnControl2;
    }

    /*
     * WARNING - void declaration
     */
    public void dumpTimeIndex(File file, boolean indexSanityOnly, boolean verifyOnly, DumpLogSegments.TimeIndexDumpErrors timeIndexDumpErrors, int maxMessageSize) {
        NonLocalReturnControl nonLocalReturnControl2;
        block7: {
            Object object = new Object();
            try {
                TimeIndex timeIndex;
                OffsetIndex index;
                FileRecords fileRecords;
                block5: {
                    File indexFile;
                    long startOffset = new StringOps(Predef$.MODULE$.augmentString(file.getName().split("\\.")[0])).toLong();
                    File logFile = new File(file.getAbsoluteFile().getParent(), new StringBuilder().append((Object)file.getName().split("\\.")[0]).append((Object)Log$.MODULE$.LogFileSuffix()).toString());
                    fileRecords = FileRecords.open((File)logFile, (boolean)false);
                    File x$8 = indexFile = new File(file.getAbsoluteFile().getParent(), new StringBuilder().append((Object)file.getName().split("\\.")[0]).append((Object)Log$.MODULE$.IndexFileSuffix()).toString());
                    long x$9 = startOffset;
                    boolean x$10 = false;
                    int x$11 = OffsetIndex$.MODULE$.$lessinit$greater$default$3();
                    index = new OffsetIndex(x$8, x$9, x$11, x$10);
                    File x$12 = file;
                    long x$13 = startOffset;
                    boolean x$14 = false;
                    int x$15 = TimeIndex$.MODULE$.$lessinit$greater$default$3();
                    timeIndex = new TimeIndex(x$12, x$13, x$15, x$14);
                    try {
                        if (!indexSanityOnly) break block5;
                        timeIndex.sanityCheck();
                        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " passed sanity check."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file})));
                    }
                    catch (Throwable throwable) {
                        void var19_20;
                        void var13_15;
                        void var11_9;
                        var11_9.closeHandlers();
                        var13_15.closeHandler();
                        var19_20.closeHandler();
                        throw throwable;
                    }
                    fileRecords.closeHandlers();
                    index.closeHandler();
                    timeIndex.closeHandler();
                    return;
                }
                LongRef prevTimestamp = LongRef.create((long)-1L);
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), timeIndex.entries()).foreach$mVc$sp((Function1)new Serializable(file, verifyOnly, timeIndexDumpErrors, fileRecords, index, timeIndex, prevTimestamp, object){
                    public static final long serialVersionUID = 0L;
                    private final File file$3;
                    private final boolean verifyOnly$2;
                    private final DumpLogSegments.TimeIndexDumpErrors timeIndexDumpErrors$2;
                    private final FileRecords fileRecords$2;
                    private final OffsetIndex index$2;
                    private final TimeIndex timeIndex$1;
                    private final LongRef prevTimestamp$1;
                    private final Object nonLocalReturnKey2$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        Option option;
                        block11: {
                            TimestampOffset entry2;
                            block9: {
                                BoxedUnit boxedUnit;
                                Some some;
                                boolean bl;
                                LongRef maxTimestamp;
                                block10: {
                                    block8: {
                                        entry2 = this.timeIndex$1.entry(i);
                                        if (entry2.offset() == this.timeIndex$1.baseOffset() && i > 0) {
                                            throw new NonLocalReturnControl.mcV.sp(this.nonLocalReturnKey2$1, BoxedUnit.UNIT);
                                        }
                                        int position = this.index$2.lookup(entry2.offset()).position();
                                        FileRecords partialFileRecords = this.fileRecords$2.slice(position, Integer.MAX_VALUE);
                                        Iterable batches = (Iterable)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(partialFileRecords.batches()).asScala();
                                        maxTimestamp = LongRef.create((long)-1L);
                                        bl = false;
                                        some = null;
                                        option = batches.find((Function1)new Serializable(this, entry2){
                                            public static final long serialVersionUID = 0L;
                                            private final TimestampOffset entry$1;

                                            public final boolean apply(FileLogInputStream.FileChannelRecordBatch x$1) {
                                                return x$1.lastOffset() >= this.entry$1.offset();
                                            }
                                            {
                                                this.entry$1 = entry$1;
                                            }
                                        });
                                        if (!None$.MODULE$.equals(option)) break block8;
                                        this.timeIndexDumpErrors$2.recordShallowOffsetNotFound(this.file$3, entry2.offset(), -1);
                                        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                                        break block9;
                                    }
                                    if (!(option instanceof Some)) break block10;
                                    bl = true;
                                    some = (Some)option;
                                    FileLogInputStream.FileChannelRecordBatch batch = (FileLogInputStream.FileChannelRecordBatch)some.x();
                                    if (batch.lastOffset() == entry2.offset()) break block10;
                                    this.timeIndexDumpErrors$2.recordShallowOffsetNotFound(this.file$3, entry2.offset(), batch.lastOffset());
                                    BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                                    break block9;
                                }
                                if (!bl) break block11;
                                FileLogInputStream.FileChannelRecordBatch batch = (FileLogInputStream.FileChannelRecordBatch)some.x();
                                ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)batch).asScala()).foreach((Function1)new Serializable(this, maxTimestamp){
                                    public static final long serialVersionUID = 0L;
                                    private final LongRef maxTimestamp$1;

                                    public final void apply(Record record2) {
                                        this.maxTimestamp$1.elem = package$.MODULE$.max(this.maxTimestamp$1.elem, record2.timestamp());
                                    }
                                    {
                                        this.maxTimestamp$1 = maxTimestamp$1;
                                    }
                                });
                                if (maxTimestamp.elem != entry2.timestamp()) {
                                    this.timeIndexDumpErrors$2.recordMismatchTimeIndex(this.file$3, entry2.timestamp(), maxTimestamp.elem);
                                }
                                if (this.prevTimestamp$1.elem >= entry2.timestamp()) {
                                    this.timeIndexDumpErrors$2.recordOutOfOrderIndexTimestamp(this.file$3, entry2.timestamp(), this.prevTimestamp$1.elem);
                                    boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    BoxedUnit boxedUnit4;
                                    boxedUnit = boxedUnit4 = BoxedUnit.UNIT;
                                }
                            }
                            if (!this.verifyOnly$2) {
                                Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"timestamp: ", " offset: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)entry2.timestamp()), BoxesRunTime.boxToLong((long)entry2.offset())})));
                            }
                            this.prevTimestamp$1.elem = entry2.timestamp();
                            return;
                        }
                        throw new MatchError((Object)option);
                    }
                    {
                        this.file$3 = file$3;
                        this.verifyOnly$2 = verifyOnly$2;
                        this.timeIndexDumpErrors$2 = timeIndexDumpErrors$2;
                        this.fileRecords$2 = fileRecords$2;
                        this.index$2 = index$2;
                        this.timeIndex$1 = timeIndex$1;
                        this.prevTimestamp$1 = prevTimestamp$1;
                        this.nonLocalReturnKey2$1 = nonLocalReturnKey2$1;
                    }
                });
                fileRecords.closeHandlers();
                index.closeHandler();
                timeIndex.closeHandler();
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block7;
                nonLocalReturnControl2.value$mcV$sp();
            }
            return;
        }
        throw nonLocalReturnControl2;
    }

    /*
     * WARNING - void declaration
     */
    public void kafka$tools$DumpLogSegments$$dumpLog(File file, boolean printContents, Map<String, List<Tuple2<Object, Object>>> nonConsecutivePairsForLogFilesMap, boolean isDeepIteration, int maxMessageSize, DumpLogSegments.MessageParser<?, ?> parser) {
        FileRecords fileRecords;
        block2: {
            long startOffset = new StringOps(Predef$.MODULE$.augmentString(file.getName().split("\\.")[0])).toLong();
            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Starting offset: ").append((Object)BoxesRunTime.boxToLong((long)startOffset)).toString());
            fileRecords = FileRecords.open((File)file, (boolean)false);
            try {
                LongRef validBytes = LongRef.create((long)0L);
                LongRef lastOffset = LongRef.create((long)-1L);
                ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(fileRecords.batches()).asScala()).foreach((Function1)new Serializable(file, printContents, nonConsecutivePairsForLogFilesMap, isDeepIteration, parser, validBytes, lastOffset){
                    public static final long serialVersionUID = 0L;
                    public final File file$1;
                    public final boolean printContents$1;
                    public final Map nonConsecutivePairsForLogFilesMap$2;
                    private final boolean isDeepIteration$1;
                    public final DumpLogSegments.MessageParser parser$1;
                    private final LongRef validBytes$1;
                    public final LongRef lastOffset$1;

                    public final void apply(FileLogInputStream.FileChannelRecordBatch batch) {
                        DumpLogSegments$.MODULE$.kafka$tools$DumpLogSegments$$printBatchLevel(batch, this.validBytes$1.elem);
                        if (this.isDeepIteration$1) {
                            ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)batch).asScala()).foreach((Function1)new Serializable(this, batch){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun$kafka$tools$DumpLogSegments$$dumpLog$1 $outer;
                                private final FileLogInputStream.FileChannelRecordBatch batch$1;

                                public final void apply(Record record2) {
                                    BoxedUnit boxedUnit;
                                    if (this.$outer.lastOffset$1.elem == -1L) {
                                        this.$outer.lastOffset$1.elem = record2.offset();
                                        boxedUnit = BoxedUnit.UNIT;
                                    } else if (record2.offset() != this.$outer.lastOffset$1.elem + 1L) {
                                        List nonConsecutivePairsSeq = (List)this.$outer.nonConsecutivePairsForLogFilesMap$2.getOrElse((Object)this.$outer.file$1.getAbsolutePath(), (Function0)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final List<Tuple2<Object, Object>> apply() {
                                                return Nil$.MODULE$;
                                            }
                                        });
                                        nonConsecutivePairsSeq = nonConsecutivePairsSeq.$colon$colon((Object)new Tuple2.mcJJ.sp(this.$outer.lastOffset$1.elem, record2.offset()));
                                        boxedUnit = this.$outer.nonConsecutivePairsForLogFilesMap$2.put((Object)this.$outer.file$1.getAbsolutePath(), (Object)nonConsecutivePairsSeq);
                                    } else {
                                        boxedUnit = BoxedUnit.UNIT;
                                    }
                                    this.$outer.lastOffset$1.elem = record2.offset();
                                    Predef$.MODULE$.print((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " offset: ", " ", ": ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DumpLogSegments$.MODULE$.RecordIndent(), BoxesRunTime.boxToLong((long)record2.offset()), this.batch$1.timestampType(), BoxesRunTime.boxToLong((long)record2.timestamp())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keysize: ", " valuesize: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)record2.keySize()), BoxesRunTime.boxToInteger((int)record2.valueSize())}))).toString());
                                    if (this.batch$1.magic() >= 2) {
                                        Predef$.MODULE$.print((Object)new StringBuilder().append((Object)" sequence: ").append((Object)BoxesRunTime.boxToInteger((int)record2.sequence())).append((Object)" headerKeys: ").append((Object)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])record2.headers()).map((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final String apply(Header x$2) {
                                                return x$2.key();
                                            }
                                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString("[", ",", "]")).toString());
                                    } else {
                                        Predef$.MODULE$.print((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" crc: ", " isvalid: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{record2.checksumOrNull(), BoxesRunTime.boxToBoolean((boolean)record2.isValid())})));
                                    }
                                    if (this.batch$1.isControlBatch()) {
                                        short controlTypeId = ControlRecordType.parseTypeId((ByteBuffer)record2.key());
                                        ControlRecordType controlRecordType = ControlRecordType.fromTypeId((short)controlTypeId);
                                        boolean bl = ControlRecordType.ABORT.equals(controlRecordType) ? true : ControlRecordType.COMMIT.equals(controlRecordType);
                                        if (bl) {
                                            EndTransactionMarker endTxnMarker = EndTransactionMarker.deserialize((Record)record2);
                                            Predef$.MODULE$.print((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" endTxnMarker: ", " coordinatorEpoch: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{endTxnMarker.controlType(), BoxesRunTime.boxToInteger((int)endTxnMarker.coordinatorEpoch())})));
                                            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                                        } else {
                                            Predef$.MODULE$.print((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" controlType: ", "(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{controlRecordType, BoxesRunTime.boxToShort((short)controlTypeId)})));
                                            BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                                        }
                                    } else if (this.$outer.printContents$1) {
                                        Tuple2<Option<K>, Option<V>> tuple2 = this.$outer.parser$1.parse(record2);
                                        if (tuple2 != null) {
                                            Tuple2 tuple22;
                                            Option key = (Option)tuple2._1();
                                            Option payload = (Option)tuple2._2();
                                            Tuple2 tuple23 = tuple22 = new Tuple2((Object)key, (Object)payload);
                                            Option key2 = (Option)tuple23._1();
                                            Option payload2 = (Option)tuple23._2();
                                            key2.foreach((Function1)new Serializable(this){
                                                public static final long serialVersionUID = 0L;

                                                public final void apply(Object key) {
                                                    Predef$.MODULE$.print((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" key: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key})));
                                                }
                                            });
                                            payload2.foreach((Function1)new Serializable(this){
                                                public static final long serialVersionUID = 0L;

                                                public final void apply(Object payload) {
                                                    Predef$.MODULE$.print((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" payload: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{payload})));
                                                }
                                            });
                                        } else {
                                            throw new MatchError(tuple2);
                                        }
                                    }
                                    Predef$.MODULE$.println();
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.batch$1 = batch$1;
                                }
                            });
                        }
                        this.validBytes$1.elem += (long)batch.sizeInBytes();
                    }
                    {
                        this.file$1 = file$1;
                        this.printContents$1 = printContents$1;
                        this.nonConsecutivePairsForLogFilesMap$2 = nonConsecutivePairsForLogFilesMap$2;
                        this.isDeepIteration$1 = isDeepIteration$1;
                        this.parser$1 = parser$1;
                        this.validBytes$1 = validBytes$1;
                        this.lastOffset$1 = lastOffset$1;
                    }
                });
                long trailingBytes = (long)fileRecords.sizeInBytes() - validBytes.elem;
                if (trailingBytes <= 0L) break block2;
                Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found ", " invalid bytes at the end of ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)trailingBytes), file.getName()})));
            }
            catch (Throwable throwable) {
                void var9_8;
                var9_8.closeHandlers();
                throw throwable;
            }
        }
        fileRecords.closeHandlers();
    }

    public void kafka$tools$DumpLogSegments$$printBatchLevel(FileLogInputStream.FileChannelRecordBatch batch, long accumulativeBytes) {
        if (batch.magic() >= 2) {
            Predef$.MODULE$.print((Object)new StringBuilder().append((Object)"baseOffset: ").append((Object)BoxesRunTime.boxToLong((long)batch.baseOffset())).append((Object)" lastOffset: ").append((Object)BoxesRunTime.boxToLong((long)batch.lastOffset())).append((Object)" count: ").append((Object)batch.countOrNull()).append((Object)" baseSequence: ").append((Object)BoxesRunTime.boxToInteger((int)batch.baseSequence())).append((Object)" lastSequence: ").append((Object)BoxesRunTime.boxToInteger((int)batch.lastSequence())).append((Object)" producerId: ").append((Object)BoxesRunTime.boxToLong((long)batch.producerId())).append((Object)" producerEpoch: ").append((Object)BoxesRunTime.boxToShort((short)batch.producerEpoch())).append((Object)" partitionLeaderEpoch: ").append((Object)BoxesRunTime.boxToInteger((int)batch.partitionLeaderEpoch())).append((Object)" isTransactional: ").append((Object)BoxesRunTime.boxToBoolean((boolean)batch.isTransactional())).append((Object)" isControl: ").append((Object)BoxesRunTime.boxToBoolean((boolean)batch.isControlBatch())).toString());
        } else {
            Predef$.MODULE$.print((Object)new StringBuilder().append((Object)"offset: ").append((Object)BoxesRunTime.boxToLong((long)batch.lastOffset())).toString());
        }
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)" position: ").append((Object)BoxesRunTime.boxToLong((long)accumulativeBytes)).append((Object)" ").append((Object)batch.timestampType()).append((Object)": ").append((Object)BoxesRunTime.boxToLong((long)batch.maxTimestamp())).append((Object)" size: ").append((Object)BoxesRunTime.boxToInteger((int)batch.sizeInBytes())).append((Object)" magic: ").append((Object)BoxesRunTime.boxToByte((byte)batch.magic())).append((Object)" compresscodec: ").append((Object)batch.compressionType()).append((Object)" crc: ").append((Object)BoxesRunTime.boxToLong((long)batch.checksum())).append((Object)" isvalid: ").append((Object)BoxesRunTime.boxToBoolean((boolean)batch.isValid())).toString());
    }

    private DumpLogSegments$() {
        MODULE$ = this;
        this.RecordIndent = "|";
    }
}

