/*
 * Decompiled with CFR 0.152.
 */
package org.ojai.json.mapreduce;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.ojai.Document;
import org.ojai.json.Json;
import org.ojai.json.impl.JsonDocumentStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONFileRecordReader
extends RecordReader<LongWritable, Document> {
    private static Logger LOG = LoggerFactory.getLogger(JSONFileRecordReader.class);
    private InputStream inputStream;
    private JsonDocumentStream documentStream;
    private Iterator<Document> it;
    private long documentCount;
    private LongWritable key = null;
    private Document document;
    private long currentPos;
    private long start;
    private long end;
    private Decompressor decompressor;

    public void close() throws IOException {
        try {
            this.documentStream.close();
        }
        catch (Exception e) {
            throw new IOException("Error closing document Stream in JsonFileRecordReader");
        }
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
        finally {
            if (this.decompressor != null) {
                CodecPool.returnDecompressor((Decompressor)this.decompressor);
                this.decompressor = null;
            }
        }
    }

    public LongWritable getCurrentKey() throws IOException, InterruptedException {
        return this.key;
    }

    public Document getCurrentValue() throws IOException, InterruptedException {
        return this.document;
    }

    public float getProgress() throws IOException, InterruptedException {
        if (this.start == this.end) {
            return 0.0f;
        }
        return Math.min(1.0f, (float)(this.currentPos - this.start) / (float)(this.end - this.start));
    }

    public void initialize(InputSplit arg0, TaskAttemptContext taskContext) throws IOException, InterruptedException {
        this.documentStream = null;
        this.it = null;
        this.documentCount = 0L;
        this.key = new LongWritable();
        this.document = null;
        this.currentPos = 0L;
        FileSplit split = (FileSplit)arg0;
        Configuration job = taskContext.getConfiguration();
        Path path = split.getPath();
        FileSystem fs = path.getFileSystem(job);
        this.inputStream = fs.open(path);
        CompressionCodec codec = new CompressionCodecFactory(job).getCodec(path);
        if (codec != null) {
            this.decompressor = CodecPool.getDecompressor((CompressionCodec)codec);
            this.inputStream = codec.createInputStream(this.inputStream, this.decompressor);
        }
        this.start = split.getStart();
        this.end = this.start + split.getLength();
        this.documentStream = (JsonDocumentStream)Json.newDocumentStream((InputStream)this.inputStream);
        this.it = this.documentStream.iterator();
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        boolean hasNextKeyVal = false;
        if (this.it.hasNext()) {
            this.key.set(this.documentCount);
            this.document = this.it.next();
            ++this.documentCount;
            hasNextKeyVal = true;
            this.currentPos = this.documentStream.getInputStreamPosition();
        }
        return hasNextKeyVal;
    }
}

